/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.openfire.commands.AdHocCommand;
import org.xmpp.packet.JID;

public class SessionData {
    private long creationStamp;
    private String id;
    private JID owner;
    private Map<Integer, Map<String, List<String>>> stagesData = new HashMap<Integer, Map<String, List<String>>>();
    private AdHocCommand.Action executeAction;
    private List<AdHocCommand.Action> allowedActions = new ArrayList<AdHocCommand.Action>();
    private int stage;

    public SessionData(String sessionid, JID owner) {
        this.id = sessionid;
        this.creationStamp = System.currentTimeMillis();
        this.stage = -1;
        this.owner = owner;
    }

    public String getId() {
        return this.id;
    }

    public JID getOwner() {
        return this.owner;
    }

    public long getCreationStamp() {
        return this.creationStamp;
    }

    protected AdHocCommand.Action getExecuteAction() {
        return this.executeAction;
    }

    protected void setExecuteAction(AdHocCommand.Action executeAction) {
        this.executeAction = executeAction;
    }

    protected void setAllowedActions(List<AdHocCommand.Action> allowedActions) {
        if (allowedActions == null) {
            allowedActions = new ArrayList<AdHocCommand.Action>();
        }
        this.allowedActions = allowedActions;
    }

    protected boolean isValidAction(String actionName) {
        for (AdHocCommand.Action action : this.allowedActions) {
            if (!actionName.equals(action.name())) continue;
            return true;
        }
        return false;
    }

    protected void addStageForm(Map<String, List<String>> data) {
        this.stagesData.put(this.stage, data);
    }

    public Map<String, List<String>> getData() {
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        for (Map<String, List<String>> stageData : this.stagesData.values()) {
            data.putAll(stageData);
        }
        return data;
    }

    public int getStage() {
        return this.stage;
    }

    protected void setStage(int stage) {
        this.stage = stage;
    }
}

