/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.auth;

import java.util.Properties;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.AuthProvider;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.StringUtils;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POP3AuthProvider
implements AuthProvider {
    private static final Logger Log = LoggerFactory.getLogger(POP3AuthProvider.class);
    private Cache<String, String> authCache = null;
    private String host = null;
    private String domain = null;
    private int port = -1;
    private boolean useSSL = false;
    private boolean authRequiresDomain = false;
    private boolean debugEnabled;

    public POP3AuthProvider() {
        JiveGlobals.migrateProperty("pop3.authCache.enabled");
        JiveGlobals.migrateProperty("pop3.ssl");
        JiveGlobals.migrateProperty("pop3.authRequiresDomain");
        JiveGlobals.migrateProperty("pop3.host");
        JiveGlobals.migrateProperty("pop3.debug");
        JiveGlobals.migrateProperty("pop3.domain");
        JiveGlobals.migrateProperty("pop3.port");
        if (Boolean.valueOf(JiveGlobals.getProperty("pop3.authCache.enabled")).booleanValue()) {
            String cacheName = "POP3 Authentication";
            this.authCache = CacheFactory.createCache(cacheName);
        }
        this.useSSL = Boolean.valueOf(JiveGlobals.getProperty("pop3.ssl"));
        this.authRequiresDomain = Boolean.valueOf(JiveGlobals.getProperty("pop3.authRequiresDomain"));
        this.host = JiveGlobals.getProperty("pop3.host");
        if (this.host == null || this.host.length() < 1) {
            throw new IllegalArgumentException("pop3.host is null or empty");
        }
        this.debugEnabled = Boolean.valueOf(JiveGlobals.getProperty("pop3.debug"));
        this.domain = JiveGlobals.getProperty("pop3.domain");
        this.port = JiveGlobals.getIntProperty("pop3.port", this.useSSL ? 995 : 110);
        if (Log.isDebugEnabled()) {
            Log.debug("POP3AuthProvider: Created new POP3AuthProvider instance, fields:");
            Log.debug("\t host: " + this.host);
            Log.debug("\t port: " + this.port);
            Log.debug("\t domain: " + this.domain);
            Log.debug("\t useSSL: " + this.useSSL);
            Log.debug("\t authRequiresDomain: " + this.authRequiresDomain);
            Log.debug("\t authCacheEnabled: " + (this.authCache != null));
            if (this.authCache != null) {
                Log.debug("\t authCacheSize: " + this.authCache.getCacheSize());
                Log.debug("\t authCacheMaxLifetime: " + this.authCache.getMaxLifetime());
            }
        }
    }

    @Override
    public void authenticate(String username, String password) throws UnauthorizedException {
        Store store;
        if (username == null || password == null) {
            throw new UnauthorizedException();
        }
        if (username.contains("@")) {
            int index = username.indexOf("@");
            String domain = username.substring(index + 1);
            if (domain.equals(XMPPServer.getInstance().getServerInfo().getXMPPDomain())) {
                username = username.substring(0, index);
            }
        } else {
            throw new UnauthorizedException();
        }
        Log.debug("POP3AuthProvider.authenticate(" + username + ", ******)");
        if (this.authCache != null && this.authCache.containsKey(username)) {
            String hash = (String)this.authCache.get(username);
            if (StringUtils.hash(password).equals(hash)) {
                return;
            }
        }
        Properties mailProps = new Properties();
        mailProps.setProperty("mail.debug", String.valueOf(this.debugEnabled));
        Session session = Session.getInstance((Properties)mailProps, null);
        try {
            store = session.getStore(this.useSSL ? "pop3s" : "pop3");
        }
        catch (NoSuchProviderException e) {
            Log.error(e.getMessage(), (Throwable)e);
            throw new UnauthorizedException(e);
        }
        try {
            if (this.authRequiresDomain) {
                store.connect(this.host, this.port, username + "@" + this.domain, password);
            } else {
                store.connect(this.host, this.port, username, password);
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
            throw new UnauthorizedException(e);
        }
        if (!store.isConnected()) {
            throw new UnauthorizedException("Could not authenticate user");
        }
        try {
            store.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.authCache != null) {
            this.authCache.put(username, StringUtils.hash(password));
        }
        UserManager userManager = UserManager.getInstance();
        try {
            userManager.getUser(username);
        }
        catch (UserNotFoundException unfe) {
            String email = username + "@" + (this.domain != null ? this.domain : this.host);
            try {
                Log.debug("POP3AuthProvider: Automatically creating new user account for " + username);
                UserManager.getUserProvider().createUser(username, StringUtils.randomString(8), null, email);
            }
            catch (UserAlreadyExistsException userAlreadyExistsException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getPassword(String username) throws UserNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPassword(String username, String password) throws UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsPasswordRetrieval() {
        return false;
    }

    @Override
    public boolean isScramSupported() {
        return false;
    }

    @Override
    public String getSalt(String username) throws UnsupportedOperationException, UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIterations(String username) throws UnsupportedOperationException, UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getServerKey(String username) throws UnsupportedOperationException, UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStoredKey(String username) throws UnsupportedOperationException, UserNotFoundException {
        throw new UnsupportedOperationException();
    }
}

