/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.auth;

import java.util.StringTokenizer;
import java.util.Vector;
import org.jivesoftware.openfire.auth.AuthorizationMapping;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthorizationMapping
implements AuthorizationMapping {
    private static final Logger Log = LoggerFactory.getLogger(DefaultAuthorizationMapping.class);
    private Vector<String> approvedRealms = new Vector();

    public DefaultAuthorizationMapping() {
        String realmList = JiveGlobals.getProperty("sasl.approvedRealms");
        if (realmList != null) {
            StringTokenizer st = new StringTokenizer(realmList, " ,\t\n\r\f");
            while (st.hasMoreTokens()) {
                this.approvedRealms.add(st.nextToken());
            }
        }
    }

    @Override
    public String map(String principal) {
        if (principal.contains("@")) {
            String realm = principal.substring(principal.lastIndexOf(64) + 1);
            String username = principal.substring(0, principal.lastIndexOf(64));
            if (realm.length() > 0) {
                if (realm.equals(JiveGlobals.getProperty("xmpp.domain"))) {
                    Log.debug("DefaultAuthorizationMapping: realm = xmpp.domain");
                    return username;
                }
                if (realm.equals(JiveGlobals.getProperty("sasl.realm"))) {
                    Log.debug("DefaultAuthorizationMapping: ream = sasl.realm");
                    return username;
                }
                for (String approvedRealm : this.approvedRealms) {
                    if (realm.equals(approvedRealm)) {
                        Log.debug("DefaultAuthorizationMapping: realm (" + realm + ") = " + approvedRealm + " which is approved");
                        return username;
                    }
                    Log.debug("DefaultAuthorizationPolicy: realm (" + realm + ") != " + approvedRealm + " which is approved");
                }
                Log.debug("DefaultAuthorizationMapping: No approved mappings found.");
                return principal;
            }
            Log.debug("DefaultAuthorizationMapping: Realm has no length");
        } else {
            Log.debug("DefaultAuthorizationMapping: No realm found");
        }
        return principal;
    }

    @Override
    public String name() {
        return "Default Mapping";
    }

    @Override
    public String description() {
        return "Simply remove's the realm of the requesting principal if and only if the realm matches the server's realm or the server's xmpp domain name. Otherwise the principal is used as the username.";
    }
}

