/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.event.UserEventDispatcher;
import org.jivesoftware.openfire.event.UserEventListener;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivateStorage
extends BasicModule
implements UserEventListener {
    private static final Logger Log = LoggerFactory.getLogger(PrivateStorage.class);
    private static final String LOAD_PRIVATE = "SELECT privateData FROM ofPrivate WHERE username=? AND name=? AND namespace=?";
    private static final String INSERT_PRIVATE = "INSERT INTO ofPrivate (privateData, name, username, namespace) VALUES (?,?,?,?)";
    private static final String UPDATE_PRIVATE = "UPDATE ofPrivate SET privateData=? WHERE name=? AND username=? AND namespace=?";
    private static final String DELETE_PRIVATES = "DELETE FROM ofPrivate WHERE username=?";
    private static final int POOL_SIZE = 10;
    private boolean enabled = JiveGlobals.getBooleanProperty("xmpp.privateStorageEnabled", true);
    private BlockingQueue<SAXReader> xmlReaders = new LinkedBlockingQueue<SAXReader>(10);

    public PrivateStorage() {
        super("Private user data storage");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        JiveGlobals.setProperty("xmpp.privateStorageEnabled", Boolean.toString(enabled));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String username, Element data) {
        if (this.enabled) {
            Connection con = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                StringWriter writer = new StringWriter();
                data.write((Writer)writer);
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(LOAD_PRIVATE);
                pstmt.setString(1, username);
                pstmt.setString(2, data.getName());
                pstmt.setString(3, data.getNamespaceURI());
                rs = pstmt.executeQuery();
                boolean update = false;
                if (rs.next()) {
                    update = true;
                }
                DbConnectionManager.fastcloseStmt(rs, pstmt);
                pstmt = update ? con.prepareStatement(UPDATE_PRIVATE) : con.prepareStatement(INSERT_PRIVATE);
                pstmt.setString(1, writer.toString());
                pstmt.setString(2, data.getName());
                pstmt.setString(3, username);
                pstmt.setString(4, data.getNamespaceURI());
                pstmt.executeUpdate();
            }
            catch (Exception e) {
                try {
                    Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, pstmt, con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection(rs, pstmt, con);
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element get(String username, Element data) {
        if (this.enabled) {
            SAXReader xmlReader;
            ResultSet rs;
            PreparedStatement pstmt;
            Connection con;
            block8: {
                con = null;
                pstmt = null;
                rs = null;
                xmlReader = null;
                try {
                    xmlReader = this.xmlReaders.take();
                    con = DbConnectionManager.getConnection();
                    pstmt = con.prepareStatement(LOAD_PRIVATE);
                    pstmt.setString(1, username);
                    pstmt.setString(2, data.getName());
                    pstmt.setString(3, data.getNamespaceURI());
                    rs = pstmt.executeQuery();
                    if (!rs.next()) break block8;
                    data.clearContent();
                    String result = rs.getString(1).trim();
                    Document doc = xmlReader.read((Reader)new StringReader(result));
                    data = doc.getRootElement();
                }
                catch (Exception e) {
                    try {
                        Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        DbConnectionManager.closeConnection(rs, pstmt, con);
                        if (xmlReader != null) {
                            this.xmlReaders.add(xmlReader);
                        }
                        throw throwable;
                    }
                    DbConnectionManager.closeConnection(rs, pstmt, con);
                    if (xmlReader != null) {
                        this.xmlReaders.add(xmlReader);
                    }
                }
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
            if (xmlReader != null) {
                this.xmlReaders.add(xmlReader);
            }
        }
        return data;
    }

    public void userCreated(User user, Map params) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userDeleting(User user, Map params) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_PRIVATES);
            pstmt.setString(1, user.getUsername());
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    public void userModified(User user, Map params) {
    }

    @Override
    public void start() throws IllegalStateException {
        super.start();
        for (int i = 0; i < 10; ++i) {
            SAXReader xmlReader = new SAXReader();
            xmlReader.setEncoding("UTF-8");
            this.xmlReaders.add(xmlReader);
        }
        UserEventDispatcher.addListener(this);
    }

    @Override
    public void stop() {
        super.stop();
        this.xmlReaders.clear();
        UserEventDispatcher.removeListener(this);
    }
}

