/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.openfire.OfflineMessageListener;
import org.jivesoftware.openfire.OfflineMessageStore;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.disco.ServerFeaturesProvider;
import org.jivesoftware.openfire.privacy.PrivacyList;
import org.jivesoftware.openfire.privacy.PrivacyListManager;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;

public class OfflineMessageStrategy
extends BasicModule
implements ServerFeaturesProvider {
    private static final Logger Log = LoggerFactory.getLogger(OfflineMessageStrategy.class);
    private static int quota = 102400;
    private static Type type = Type.store_and_bounce;
    private static List<OfflineMessageListener> listeners = new CopyOnWriteArrayList<OfflineMessageListener>();
    private OfflineMessageStore messageStore;
    private JID serverAddress;
    private PacketRouter router;

    public OfflineMessageStrategy() {
        super("Offline Message Strategy");
    }

    public int getQuota() {
        return quota;
    }

    public void setQuota(int quota) {
        OfflineMessageStrategy.quota = quota;
        JiveGlobals.setProperty("xmpp.offline.quota", Integer.toString(quota));
    }

    public Type getType() {
        return type;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        OfflineMessageStrategy.type = type;
        JiveGlobals.setProperty("xmpp.offline.type", type.toString());
    }

    public void storeOffline(Message message) {
        if (message != null) {
            JID recipientJID = message.getTo();
            if (recipientJID == null || this.serverAddress.equals((Object)recipientJID) || recipientJID.getNode() == null || message.getExtension("received", "urn:xmpp:carbons:2") != null || !UserManager.getInstance().isRegisteredUser(recipientJID.getNode())) {
                return;
            }
            PrivacyList list = PrivacyListManager.getInstance().getDefaultPrivacyList(recipientJID.getNode());
            if (list != null && list.shouldBlockPacket((Packet)message)) {
                Message result = message.createCopy();
                result.setTo(message.getFrom());
                result.setFrom(message.getTo());
                result.setError(PacketError.Condition.service_unavailable);
                XMPPServer.getInstance().getRoutingTable().routePacket(message.getFrom(), (Packet)result, true);
                return;
            }
            if (recipientJID.getResource() == null) {
                if (message.getType() == Message.Type.headline || message.getType() == Message.Type.error) {
                    return;
                }
                if (message.getType() == Message.Type.groupchat) {
                    this.bounce(message);
                    return;
                }
            } else {
                if (message.getType() == Message.Type.normal || message.getType() == Message.Type.groupchat || message.getType() == Message.Type.headline) {
                    if (type == Type.bounce) {
                        this.bounce(message);
                    }
                    return;
                }
                if (message.getType() == Message.Type.error) {
                    return;
                }
            }
            switch (type) {
                case bounce: {
                    this.bounce(message);
                    break;
                }
                case store: {
                    this.store(message);
                    break;
                }
                case store_and_bounce: {
                    if (this.underQuota(message)) {
                        this.store(message);
                        break;
                    }
                    Log.debug("Unable to store, as user is over storage quota. Bouncing message instead: " + message.toXML());
                    this.bounce(message);
                    break;
                }
                case store_and_drop: {
                    if (this.underQuota(message)) {
                        this.store(message);
                        break;
                    }
                    Log.debug("Unable to store, as user is over storage quota. Silently dropping message: " + message.toXML());
                    break;
                }
            }
        }
    }

    public static void addListener(OfflineMessageListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        listeners.add(listener);
    }

    public static void removeListener(OfflineMessageListener listener) {
        listeners.remove(listener);
    }

    private boolean underQuota(Message message) {
        return quota > this.messageStore.getSize(message.getTo().getNode()) + message.toXML().length();
    }

    private void store(Message message) {
        this.messageStore.addMessage(message);
        if (!listeners.isEmpty()) {
            for (OfflineMessageListener listener : listeners) {
                listener.messageStored(message);
            }
        }
    }

    private void bounce(Message message) {
        if (message.getFrom() == null || message.getFrom().equals((Object)this.serverAddress)) {
            return;
        }
        try {
            Message errorResponse = message.createCopy();
            errorResponse.setError(PacketError.Condition.service_unavailable);
            errorResponse.setFrom(message.getTo());
            errorResponse.setTo(message.getFrom());
            this.router.route(errorResponse);
            if (!listeners.isEmpty()) {
                for (OfflineMessageListener listener : listeners) {
                    listener.messageBounced(message);
                }
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void initialize(XMPPServer server) {
        String type;
        super.initialize(server);
        this.messageStore = server.getOfflineMessageStore();
        this.router = server.getPacketRouter();
        this.serverAddress = new JID(server.getServerInfo().getXMPPDomain());
        JiveGlobals.migrateProperty("xmpp.offline.quota");
        JiveGlobals.migrateProperty("xmpp.offline.type");
        String quota = JiveGlobals.getProperty("xmpp.offline.quota");
        if (quota != null && quota.length() > 0) {
            OfflineMessageStrategy.quota = Integer.parseInt(quota);
        }
        if ((type = JiveGlobals.getProperty("xmpp.offline.type")) != null && type.length() > 0) {
            OfflineMessageStrategy.type = Type.valueOf(type);
        }
    }

    @Override
    public Iterator<String> getFeatures() {
        switch (type) {
            case store: 
            case store_and_bounce: 
            case store_and_drop: {
                return Collections.singleton("msgoffline").iterator();
            }
        }
        return Collections.emptyList().iterator();
    }

    public static enum Type {
        bounce,
        drop,
        store,
        store_and_bounce,
        store_and_drop;

    }
}

