/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlashCrossDomainHandler
extends BasicModule {
    private static final Logger Log = LoggerFactory.getLogger(FlashCrossDomainHandler.class);
    private ServerSocket serverSocket;
    public static String CROSS_DOMAIN_TEXT = "<?xml version=\"1.0\"?><!DOCTYPE cross-domain-policy SYSTEM \"http://www.macromedia.com/xml/dtds/cross-domain-policy.dtd\"><cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"";
    public static String CROSS_DOMAIN_END_TEXT = "\" /></cross-domain-policy>";

    public FlashCrossDomainHandler() {
        super("Flash CrossDomain Handler");
    }

    @Override
    public void start() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FlashCrossDomainHandler.this.startServer();
                }
                catch (Exception e) {
                    Log.error(e.getMessage(), (Throwable)e);
                }
            }
        }, "Flash Cross Domain");
        thread.start();
    }

    @Override
    public void stop() {
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    public int getPort() {
        return this.serverSocket != null ? this.serverSocket.getLocalPort() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServer() throws Exception {
        if (!JiveGlobals.getBooleanProperty("flash.crossdomain.enabled", true)) {
            Log.debug("Flash cross domain listener is disabled");
            return;
        }
        int port = JiveGlobals.getIntProperty("flash.crossdomain.port", 5229);
        try {
            String interfaceName = JiveGlobals.getXMLProperty("network.interface");
            InetAddress bindInterface = null;
            if (interfaceName != null && interfaceName.trim().length() > 0) {
                bindInterface = InetAddress.getByName(interfaceName);
            }
            this.serverSocket = new ServerSocket(port, -1, bindInterface);
            Log.debug("Flash cross domain is listening on " + interfaceName + " on port " + port);
        }
        catch (IOException e) {
            Log.error("Could not listen on port: " + port, (Throwable)e);
            return;
        }
        while (true) {
            Socket clientSocket = null;
            PrintWriter out = null;
            BufferedReader in = null;
            try {
                clientSocket = this.serverSocket.accept();
                clientSocket.setSoTimeout(10000);
                out = new PrintWriter(clientSocket.getOutputStream(), true);
                in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                String request = "";
                request = this.read(in);
                if (!request.contains("<policy-file-request/>") && !request.contains("GET /crossdomain.xml")) continue;
                out.write(CROSS_DOMAIN_TEXT + XMPPServer.getInstance().getConnectionManager().getClientListenerPort() + CROSS_DOMAIN_END_TEXT + "\u0000");
                continue;
            }
            catch (IOException e) {
                if (XMPPServer.getInstance().isShuttingDown()) break;
                Log.error(e.getMessage(), (Throwable)e);
                continue;
            }
            finally {
                if (out != null) {
                    out.flush();
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                if (clientSocket == null) continue;
                clientSocket.close();
                continue;
            }
            break;
        }
    }

    protected String read(BufferedReader in) {
        StringBuilder buffer = new StringBuilder();
        boolean stopReading = false;
        int invalidCodePoints = 0;
        try {
            do {
                int codePoint;
                if ((codePoint = in.read()) == 0 || codePoint == 10 || codePoint == -1) {
                    stopReading = true;
                    continue;
                }
                if (Character.isValidCodePoint(codePoint)) {
                    buffer.appendCodePoint(codePoint);
                    continue;
                }
                ++invalidCodePoints;
            } while (!stopReading && buffer.length() < 200 && invalidCodePoints < 100);
        }
        catch (Exception e) {
            Log.debug("Exception (read): " + e.getMessage());
        }
        return buffer.toString();
    }
}

