/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.openfire.ChannelHandler;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.Packet;

public class Channel<T extends Packet> {
    private static final Logger Log = LoggerFactory.getLogger(Channel.class);
    private String name;
    private ChannelHandler<T> channelHandler;
    ThreadPoolExecutor executor;

    public Channel(String name, ChannelHandler<T> channelHandler) {
        this.name = name;
        this.channelHandler = channelHandler;
        this.executor = new ThreadPoolExecutor(1, 8, 15L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public String getName() {
        return this.name;
    }

    public void add(T packet) {
        Runnable r = new Runnable((Packet)packet){
            final /* synthetic */ Packet val$packet;
            {
                this.val$packet = packet;
            }

            @Override
            public void run() {
                try {
                    Channel.this.channelHandler.process(this.val$packet);
                }
                catch (Exception e) {
                    Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
                    try {
                        ClientSession session = SessionManager.getInstance().getSession(this.val$packet.getFrom());
                        session.close();
                    }
                    catch (Exception e1) {
                        Log.error(e1.getMessage(), (Throwable)e1);
                    }
                }
            }
        };
        this.executor.execute(r);
    }

    public boolean isRunning() {
        return !this.executor.isShutdown();
    }

    public void start() {
    }

    public synchronized void stop() {
        this.executor.shutdown();
    }

    public int getThreadCount() {
        return this.executor.getPoolSize();
    }

    public int getMinThreadCount() {
        return this.executor.getCorePoolSize();
    }

    public void setMinThreadCount(int minThreadCount) {
        this.executor.setCorePoolSize(minThreadCount);
    }

    public int getMaxThreadCount() {
        return this.executor.getMaximumPoolSize();
    }

    public void setMaxThreadCount(int maxThreadCount) {
        this.executor.setMaximumPoolSize(maxThreadCount);
    }

    public int getQueueSize() {
        return this.executor.getQueue().size();
    }
}

