/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.database;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.jivesoftware.database.ConnectionProvider;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedConnectionProvider
implements ConnectionProvider {
    private static final Logger Log = LoggerFactory.getLogger(EmbeddedConnectionProvider.class);
    private Properties settings;
    private String serverURL;
    private String driver = "org.hsqldb.jdbcDriver";
    private String proxoolURL;

    @Override
    public boolean isPooled() {
        return true;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            Class.forName("org.logicalcobwebs.proxool.ProxoolDriver");
            return DriverManager.getConnection(this.proxoolURL, this.settings);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("EmbeddedConnectionProvider: Unable to find driver: " + e);
        }
    }

    @Override
    public void start() {
        File databaseDir = new File(JiveGlobals.getHomeDirectory(), File.separator + "embedded-db");
        if (!databaseDir.exists()) {
            databaseDir.mkdirs();
        }
        try {
            this.serverURL = "jdbc:hsqldb:" + databaseDir.getCanonicalPath() + File.separator + "openfire";
        }
        catch (IOException ioe) {
            Log.error("EmbeddedConnectionProvider: Error starting connection pool: ", (Throwable)ioe);
        }
        this.proxoolURL = "proxool.openfire:" + this.driver + ":" + this.serverURL;
        this.settings = new Properties();
        this.settings.setProperty("proxool.maximum-connection-count", "25");
        this.settings.setProperty("proxool.minimum-connection-count", "3");
        this.settings.setProperty("proxool.maximum-connection-lifetime", Integer.toString(43200000));
        this.settings.setProperty("user", "sa");
        this.settings.setProperty("password", "");
    }

    @Override
    public void restart() {
        this.destroy();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = this.getConnection();
            pstmt = con.prepareStatement("SHUTDOWN");
            pstmt.execute();
        }
        catch (SQLException sqle) {
            try {
                Log.error(sqle.getMessage(), (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
        this.settings = null;
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }
}

