/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.outputchart;

import com.icesoft.faces.component.outputchart.AbstractChart;
import com.icesoft.faces.component.outputchart.OutputChart;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import javax.faces.component.UIComponent;
import org.krysalis.jcharts.axisChart.ScatterPlotAxisChart;
import org.krysalis.jcharts.chartData.AxisChartDataSet;
import org.krysalis.jcharts.chartData.DataSeries;
import org.krysalis.jcharts.chartData.ScatterPlotDataSeries;
import org.krysalis.jcharts.chartData.ScatterPlotDataSet;
import org.krysalis.jcharts.chartData.interfaces.IAxisDataSeries;
import org.krysalis.jcharts.chartData.interfaces.IAxisPlotDataSet;
import org.krysalis.jcharts.chartData.interfaces.IScatterPlotDataSeries;
import org.krysalis.jcharts.chartData.interfaces.IScatterPlotDataSet;
import org.krysalis.jcharts.properties.AreaChartProperties;
import org.krysalis.jcharts.properties.AxisProperties;
import org.krysalis.jcharts.properties.BarChartProperties;
import org.krysalis.jcharts.properties.ChartProperties;
import org.krysalis.jcharts.properties.ChartTypeProperties;
import org.krysalis.jcharts.properties.ClusteredBarChartProperties;
import org.krysalis.jcharts.properties.DataAxisProperties;
import org.krysalis.jcharts.properties.LabelAxisProperties;
import org.krysalis.jcharts.properties.LineChartProperties;
import org.krysalis.jcharts.properties.PointChartProperties;
import org.krysalis.jcharts.properties.ScatterPlotProperties;
import org.krysalis.jcharts.properties.StackedAreaChartProperties;
import org.krysalis.jcharts.properties.StackedBarChartProperties;
import org.krysalis.jcharts.test.TestDataGenerator;
import org.krysalis.jcharts.types.ChartType;

public class AxisChart
extends AbstractChart {
    private Shape[] shapes;
    String[] xaxisLabels = null;
    String[] labels = null;
    private double[][] data = null;

    public AxisChart(UIComponent uiComponent) throws Throwable {
        super(uiComponent);
    }

    protected void buildChart(OutputChart outputChart) throws Throwable {
        this.getData(outputChart.getData());
        if (outputChart.getType().equalsIgnoreCase(OutputChart.AREA_CHART_TYPE)) {
            this.buildAreaChart(outputChart);
        } else if (outputChart.getType().equalsIgnoreCase(OutputChart.AREA_STACKED_CHART_TYPE)) {
            this.buildAreaStackedChart(outputChart);
        } else if (outputChart.getType().equalsIgnoreCase(OutputChart.BAR_CHART_TYPE)) {
            this.buildBarChart(outputChart);
        } else if (outputChart.getType().equalsIgnoreCase(OutputChart.BAR_STACKED_CHART_TYPE)) {
            this.buildBarStackedChart(outputChart);
        } else if (outputChart.getType().equalsIgnoreCase(OutputChart.BAR_CLUSTERED_CHART_TYPE)) {
            this.buildBarClusteredChart(outputChart);
        } else if (outputChart.getType().equalsIgnoreCase(OutputChart.LINE_CHART_TYPE)) {
            this.buildLineChart(outputChart);
        } else if (outputChart.getType().equalsIgnoreCase(OutputChart.POINT_CHART_TYPE)) {
            this.buildPointChart(outputChart);
        } else if (outputChart.getType().equalsIgnoreCase("scatterplot")) {
            this.buildScatterPlotChart(outputChart);
        }
    }

    private void buildAreaChart(OutputChart outputChart) throws Throwable {
        AreaChartProperties areaChartProperties = new AreaChartProperties();
        this.buildAxisChart(ChartType.AREA, (ChartTypeProperties)areaChartProperties, outputChart);
    }

    private void buildAreaStackedChart(OutputChart outputChart) throws Throwable {
        StackedAreaChartProperties areaChartProperties = new StackedAreaChartProperties();
        this.buildAxisChart(ChartType.AREA_STACKED, (ChartTypeProperties)areaChartProperties, outputChart);
    }

    private void buildBarChart(OutputChart outputChart) throws Throwable {
        BarChartProperties barChartProperties = new BarChartProperties();
        this.buildAxisChart(ChartType.BAR, (ChartTypeProperties)barChartProperties, outputChart);
    }

    private void buildBarStackedChart(OutputChart outputChart) throws Throwable {
        StackedBarChartProperties barChartProperties = new StackedBarChartProperties();
        this.buildAxisChart(ChartType.BAR_STACKED, (ChartTypeProperties)barChartProperties, outputChart);
    }

    private void buildBarClusteredChart(OutputChart outputChart) throws Throwable {
        ClusteredBarChartProperties barChartProperties = new ClusteredBarChartProperties();
        this.buildAxisChart(ChartType.BAR_CLUSTERED, (ChartTypeProperties)barChartProperties, outputChart);
    }

    private void buildLineChart(OutputChart outputChart) throws Throwable {
        Stroke[] strokes = new Stroke[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            strokes[i] = LineChartProperties.DEFAULT_LINE_STROKE;
        }
        LineChartProperties lineChartProperties = new LineChartProperties(strokes, this.getShapes(outputChart.getShapes()));
        this.buildAxisChart(ChartType.LINE, (ChartTypeProperties)lineChartProperties, outputChart);
    }

    private void buildPointChart(OutputChart outputChart) throws Throwable {
        Paint[] outlinePaints = TestDataGenerator.getRandomPaints((int)this.data.length);
        boolean[] fillPointFlags = new boolean[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            fillPointFlags[i] = true;
        }
        PointChartProperties pointChartProperties = new PointChartProperties(this.getShapes(outputChart.getShapes()), fillPointFlags, outlinePaints);
        this.buildAxisChart(ChartType.POINT, (ChartTypeProperties)pointChartProperties, outputChart);
    }

    private void buildScatterPlotChart(OutputChart outputChart) throws Throwable {
        Stroke[] strokes = new Stroke[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            strokes[i] = new BasicStroke(0.0f);
        }
        ScatterPlotProperties pointChartProperties = new ScatterPlotProperties(strokes, this.getShapes(outputChart.getShapes()));
        this.buildScatterPlotChart(ChartType.SCATTER_PLOT, pointChartProperties, outputChart);
    }

    private ScatterPlotDataSet createScatterPlotDataSet(OutputChart outputChart, ScatterPlotProperties chartTypeProperties) {
        int index;
        ScatterPlotDataSet scatterPlotDataSet = new ScatterPlotDataSet(chartTypeProperties);
        int maxLength = -1;
        for (index = 0; index < this.data.length; ++index) {
            if (this.data[index].length <= maxLength) continue;
            maxLength = this.data[index].length;
        }
        if (maxLength == 0) {
            maxLength = 2;
        }
        for (index = 0; index < this.data.length; ++index) {
            Point2D.Double[] points = new Point2D.Double[maxLength];
            int length = 0;
            if (this.data[index].length != 0) {
                length = this.data[index].length / 2;
                for (int x = 0; x < this.data[index].length; x += 2) {
                    points[x / 2] = ScatterPlotDataSet.createPoint2DDouble();
                    points[x / 2].setLocation(this.data[index][x], this.data[index][x + 1]);
                }
            }
            for (int i = length; i < maxLength; ++i) {
                points[i] = ScatterPlotDataSet.createPoint2DDouble();
                points[i].setLocation(Double.NaN, Double.NaN);
            }
            scatterPlotDataSet.addDataPoints(points, this.getPaints(outputChart.getColors())[index], this.getAsLabelsArray(outputChart.getLabels())[index]);
        }
        return scatterPlotDataSet;
    }

    void buildScatterPlotChart(ChartType chartType, ScatterPlotProperties chartTypeProperties, OutputChart outputChart) throws Throwable {
        ScatterPlotDataSet scatterPlotDataSet = this.createScatterPlotDataSet(outputChart, chartTypeProperties);
        ScatterPlotDataSeries scatterPlotDataSeries = new ScatterPlotDataSeries((IScatterPlotDataSet)scatterPlotDataSet, outputChart.getXaxisTitle(), outputChart.getYaxisTitle(), outputChart.getChartTitle());
        double[] ranges = this.getAsDoubleArray(outputChart.getXaxisLabels());
        DataAxisProperties xAxisProperties = new DataAxisProperties();
        xAxisProperties.setUserDefinedScale(ranges[0], ranges[1]);
        xAxisProperties.setNumItems((int)ranges[2]);
        xAxisProperties.setRoundToNearest((int)ranges[3]);
        DataAxisProperties yAxisProperties = new DataAxisProperties();
        yAxisProperties.setUserDefinedScale(ranges[4], ranges[5]);
        yAxisProperties.setNumItems((int)ranges[6]);
        yAxisProperties.setRoundToNearest((int)ranges[7]);
        AxisProperties axisProperties = new AxisProperties((LabelAxisProperties)xAxisProperties, (LabelAxisProperties)yAxisProperties);
        this.chart = new ScatterPlotAxisChart((IScatterPlotDataSeries)scatterPlotDataSeries, new ChartProperties(), axisProperties, this.getLegendProperties(outputChart), new Integer(outputChart.getWidth()).intValue(), new Integer(outputChart.getHeight()).intValue());
    }

    void buildAxisChart(ChartType chartType, ChartTypeProperties chartTypeProperties, OutputChart outputChart) throws Throwable {
        DataSeries dataSeries = new DataSeries(this.getAsXaxisLabelsArray(outputChart.getXaxisLabels()), outputChart.getXaxisTitle(), outputChart.getYaxisTitle(), outputChart.getChartTitle());
        AxisChartDataSet axisChartDataSet = new AxisChartDataSet(this.getAs2dDoubleArray(outputChart.getData()), this.getAsLabelsArray(outputChart.getLabels()), this.getPaints(outputChart.getColors()), chartType, chartTypeProperties);
        AxisProperties axisProperties = (chartType.equals(ChartType.BAR) || chartType.equals(ChartType.BAR_CLUSTERED)) && outputChart.isHorizontal() ? new AxisProperties(true) : new AxisProperties();
        dataSeries.addIAxisPlotDataSet((IAxisPlotDataSet)axisChartDataSet);
        this.chart = new org.krysalis.jcharts.axisChart.AxisChart((IAxisDataSeries)dataSeries, new ChartProperties(), axisProperties, this.getLegendProperties(outputChart), new Integer(outputChart.getWidth()).intValue(), new Integer(outputChart.getHeight()).intValue());
    }

    private Shape[] getShapes(Object obj) {
        if (obj == null && (this.shapes == null || this.shapes.length != this.data.length)) {
            this.shapes = this.getGeneratedShapes(this.data.length);
            return this.shapes;
        }
        if (obj == null && this.shapes != null) {
            return this.shapes;
        }
        this.shapes = this.getAsShapeArray(obj);
        return this.shapes;
    }

    public String[] getAsXaxisLabelsArray(Object obj) {
        if (obj == null && this.xaxisLabels == null) {
            this.xaxisLabels = this.getGeneratedLabels("Xlabel", this.data[0].length);
            return this.xaxisLabels;
        }
        if (obj == null && this.xaxisLabels != null) {
            return this.xaxisLabels;
        }
        return this.getAsStringArray(obj);
    }

    public String[] getAsLabelsArray(Object obj) {
        if (obj == null && this.labels == null) {
            this.labels = this.getGeneratedLabels("Label", this.data.length);
            return this.labels;
        }
        if (obj == null && this.labels != null) {
            return this.labels;
        }
        return this.getAsStringArray(obj);
    }

    public double[][] getData(Object obj) {
        if (obj instanceof String && this.data != null && this.data.equals(obj)) {
            return this.data;
        }
        this.data = this.getAs2dDoubleArray(obj);
        return this.data;
    }

    public Paint[] getPaints(Object obj) {
        return this.getPaints(obj, this.data.length);
    }
}

