/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.commandsortheader;

import com.icesoft.faces.component.commandsortheader.CommandSortHeader;
import com.icesoft.faces.component.ext.HtmlDataTable;
import com.icesoft.faces.component.ext.renderkit.CommandLinkRenderer;
import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.context.DOMContext;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CommandSortHeaderRenderer
extends CommandLinkRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, null);
        if (Util.isEnabledOnUserRole(uiComponent)) {
            CommandSortHeader sortHeader = (CommandSortHeader)uiComponent;
            HtmlDataTable dataTable = sortHeader.findParentDataTable();
            Node child = null;
            DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
            Element root = (Element)domContext.getRootNode();
            String headerClass = sortHeader.getStyleClass();
            if (headerClass != null) {
                root.setAttribute("class", headerClass);
            }
            if (sortHeader.getColumnName().equals(dataTable.getSortColumn())) {
                child = root.getFirstChild();
                headerClass = dataTable.isSortAscending() ? headerClass + "Asc" : headerClass + "Desc";
                if (child != null) {
                    if (child.getNodeType() == 1) {
                        child = child.getFirstChild();
                    }
                    String value = child.getNodeValue();
                    Element table = domContext.createElement("table");
                    Element tr = domContext.createElement("tr");
                    table.appendChild(tr);
                    Element textTd = domContext.createElement("td");
                    textTd.appendChild(domContext.createTextNode(value));
                    Element arrowTd = domContext.createElement("td");
                    tr.appendChild(textTd);
                    tr.appendChild(arrowTd);
                    Element arrowDiv = domContext.createElement("div");
                    arrowDiv.setAttribute("class", headerClass);
                    arrowDiv.setAttribute("valign", "middle");
                    arrowTd.appendChild(arrowDiv);
                    child.setNodeValue("");
                    child.getParentNode().appendChild(table);
                }
            }
        }
        super.encodeEnd(facesContext, uiComponent);
    }
}

