/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.ext;

import com.icesoft.faces.component.ext.UIColumns;
import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.component.panelseries.UISeries;
import java.util.Iterator;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseId;

public class HtmlDataTable
extends UISeries {
    public static final String COMPONENT_TYPE = "com.icesoft.faces.HtmlDataTable";
    public static final String RENDERER_TYPE = "com.icesoft.faces.Table";
    private String renderedOnUserRole = null;
    private String sortColumn = null;
    private Boolean sortAscending = null;
    private static final boolean DEFAULT_SORTASCENDING = true;
    private Boolean scrollable = null;
    private String columnWidths = null;
    private String scrollHeight = null;
    private String headerClasses = null;
    private int colNumber = 0;
    String[] headerClassesArray = null;

    public HtmlDataTable() {
        this.setRendererType(RENDERER_TYPE);
    }

    public void setRenderedOnUserRole(String renderedOnUserRole) {
        this.renderedOnUserRole = renderedOnUserRole;
    }

    public String getRenderedOnUserRole() {
        if (this.renderedOnUserRole != null) {
            return this.renderedOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("renderedOnUserRole");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public boolean isRendered() {
        if (!Util.isRenderedOnUserRole((UIComponent)this)) {
            return false;
        }
        return super.isRendered();
    }

    public String getSortColumn() {
        if (this.sortColumn != null) {
            return this.sortColumn;
        }
        ValueBinding vb = this.getValueBinding("sortColumn");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = new Boolean(sortAscending);
        ValueBinding vb = this.getValueBinding("sortAscending");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), (Object)this.sortAscending);
            this.sortAscending = null;
        }
    }

    public void setSortColumn(String sortColumn) {
        this.sortColumn = sortColumn;
        ValueBinding vb = this.getValueBinding("sortColumn");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), (Object)this.sortColumn);
            sortColumn = null;
        }
    }

    public boolean isSortAscending() {
        if (this.sortAscending != null) {
            return this.sortAscending;
        }
        ValueBinding vb = this.getValueBinding("sortAscending");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : true;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[4];
        values[0] = super.saveState(context);
        values[1] = this.renderedOnUserRole;
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.renderedOnUserRole = (String)values[1];
    }

    public String getComponentType() {
        return COMPONENT_TYPE;
    }

    protected void iterate(FacesContext facesContext, PhaseId phase) {
        this.setRowIndex(-1);
        Iterator facets = this.getFacets().keySet().iterator();
        while (facets.hasNext()) {
            UIComponent facet = (UIComponent)this.getFacets().get(facets.next());
            this.processKids(facesContext, phase, facet);
        }
        this.setRowIndex(-1);
        Iterator columns = this.getChildren().iterator();
        while (columns.hasNext()) {
            UIComponent column = (UIComponent)columns.next();
            if (!(column instanceof UIColumn) && !(column instanceof UIColumns) || !column.isRendered()) continue;
            if (column instanceof UIColumn) {
                Iterator columnFacets = column.getFacets().keySet().iterator();
                while (columnFacets.hasNext()) {
                    UIComponent columnFacet = (UIComponent)column.getFacets().get(columnFacets.next());
                    this.processKids(facesContext, phase, columnFacet);
                }
                continue;
            }
            if (!(column instanceof UIColumns)) continue;
            this.processKids(facesContext, phase, column);
        }
        this.setRowIndex(-1);
        int rowsProcessed = 0;
        int currentRowIndex = this.getFirst() - 1;
        int displayedRows = this.getRows();
        while (++currentRowIndex < this.getRowCount() && (displayedRows <= 0 || ++rowsProcessed <= displayedRows)) {
            this.setRowIndex(currentRowIndex);
            if (!this.isRowAvailable()) break;
            Iterator children = this.getChildren().iterator();
            while (children.hasNext()) {
                UIComponent child = (UIComponent)children.next();
                if (!(child instanceof UIColumn) && !(child instanceof UIColumns)) continue;
                if (child instanceof UIColumn) {
                    Iterator granchildren = child.getChildren().iterator();
                    while (granchildren.hasNext()) {
                        UIComponent granchild = (UIComponent)granchildren.next();
                        if (!granchild.isRendered()) continue;
                        this.processKids(facesContext, phase, granchild);
                    }
                    continue;
                }
                if (!(child instanceof UIColumns)) continue;
                this.processKids(facesContext, phase, child);
            }
        }
        this.setRowIndex(-1);
    }

    protected void restoreChildrenState(FacesContext facesContext) {
        Iterator kids = this.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!(kid instanceof UIColumn)) continue;
            this.restoreChildState(facesContext, kid);
        }
    }

    protected void saveChildrenState(FacesContext facesContext) {
        Iterator kids = this.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!(kid instanceof UIColumn)) continue;
            this.saveChildState(facesContext, kid);
        }
    }

    public void processKids(FacesContext context, PhaseId phaseId, UIComponent kid) {
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
            kid.processDecodes(context);
        } else if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
            kid.processValidators(context);
        } else if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            kid.processUpdates(context);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public int getColNumber() {
        return this.colNumber;
    }

    public void setColNumber(int colNumber) {
        this.colNumber = colNumber;
    }

    public Boolean getScrollable() {
        return this.isScrollable();
    }

    public Boolean isScrollable() {
        if (this.scrollable != null) {
            return this.scrollable;
        }
        ValueBinding vb = this.getValueBinding("scrollable");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : Boolean.FALSE;
    }

    public void setScrollable(Boolean scrollable) {
        this.scrollable = scrollable;
    }

    public String getColumnWidths() {
        if (this.columnWidths != null) {
            return this.columnWidths;
        }
        ValueBinding vb = this.getValueBinding("columnWidths");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setColumnWidths(String columnWidths) {
        this.columnWidths = columnWidths;
    }

    public String getScrollHeight() {
        if (this.scrollHeight != null) {
            return this.scrollHeight;
        }
        ValueBinding vb = this.getValueBinding("scrollHeight");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setScrollHeight(String scrollHeight) {
        this.scrollHeight = scrollHeight;
    }

    public void setHeaderClasses(String headerClasses) {
        this.headerClasses = headerClasses;
    }

    public String getHeaderClasses() {
        if (this.headerClasses != null) {
            return this.headerClasses;
        }
        ValueBinding vb = this.getValueBinding("headerClasses");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public String getHeaderClassAtIndex(int index) {
        if (this.headerClassesArray == null) {
            this.headerClassesArray = this.getHeaderClasses().split(",");
        }
        if (this.headerClassesArray.length == 1) {
            return this.headerClassesArray[0];
        }
        try {
            return this.headerClassesArray[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.headerClassesArray[0];
        }
    }

    protected void restoreChild(FacesContext facesContext, UIComponent uiComponent) {
        super.restoreChild(facesContext, uiComponent);
        if (uiComponent instanceof UIData) {
            String clientId = uiComponent.getClientId(facesContext);
            Object value = this.savedChildren.get(clientId);
            ((UIData)uiComponent).setValue(value);
        }
    }

    protected void saveChild(FacesContext facesContext, UIComponent uiComponent) {
        super.saveChild(facesContext, uiComponent);
        if (uiComponent instanceof UIData) {
            String clientId = uiComponent.getClientId(facesContext);
            this.savedChildren.put(clientId, ((UIData)uiComponent).getValue());
        }
    }

    public String getStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, super.getStyleClass(), "iceDatTbl", "styleClass");
    }

    public String getHeaderClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, super.getHeaderClass(), "Hdr", "headerClass");
    }

    public String getFooterClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, super.getFooterClass(), "Ftr", "footerClass");
    }
}

