/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context.effects;

import com.icesoft.faces.application.StartupTime;
import com.icesoft.faces.context.effects.Effect;
import com.icesoft.faces.context.effects.EffectComparator;
import com.icesoft.faces.context.effects.EffectQueue;
import com.icesoft.util.CoreComponentUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.icefaces.util.FocusController;

public class JavascriptContext {
    private static final Random RANDOM = new Random();
    private static final String REQUEST_KEY = "icesoft_javascript_request_key_7698193";
    private static final String EFFECTS_REQUEST_KEY = "icesoft_javascript_effects_request_key_9072451";
    private static final String FOCUS_COMP_KEY = "icesoft_javascript_focus_comp";
    private static final String FOCUS_APP_KEY = "icesoft_javascript_focus_app";
    public static final String LIB_KEY = "icesoft_javascript_required_libs_897241";
    public static final String DYNAMIC_CODE_ID = "dynamic-code";
    public static final String ICE_BRIDGE = "/xmlhttp" + StartupTime.getStartupInc() + "icefaces-d2d.js";
    public static final String ICE_EXTRAS = "/xmlhttp" + StartupTime.getStartupInc() + "icefaces-compat.js";

    public static void includeLib(String libname, FacesContext facesContext) {
        if (facesContext == null) {
            return;
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        if (externalContext == null) {
            return;
        }
        Map sessionMap = externalContext.getSessionMap();
        if (sessionMap == null) {
            return;
        }
        ArrayList<String> libs = (ArrayList<String>)sessionMap.get(LIB_KEY);
        if (libs == null) {
            libs = new ArrayList<String>();
            sessionMap.put(LIB_KEY, libs);
        }
        if (!libs.contains(libname)) {
            libs.add(libname);
        }
    }

    public static String[] getIncludedLibs(FacesContext facesContext) {
        List libs = (List)facesContext.getExternalContext().getSessionMap().get(LIB_KEY);
        String[] result = new String[]{};
        if (libs != null) {
            result = new String[libs.size()];
            libs.toArray(result);
        }
        return result;
    }

    public static void addJavascriptCall(FacesContext facesContext, String call) {
        Map map = facesContext.getExternalContext().getRequestMap();
        JavascriptContext.addJavascriptCall(map, call);
    }

    private static void addJavascriptCall(Map map, String call) {
        String currentValue = (String)map.get(REQUEST_KEY);
        if (currentValue == null) {
            map.put(REQUEST_KEY, call);
        } else {
            map.put(REQUEST_KEY, currentValue + call);
        }
    }

    public static String getJavascriptCalls(FacesContext facesContext) {
        Map map = facesContext.getExternalContext().getRequestMap();
        return JavascriptContext.getJavascriptCalls(map);
    }

    public static String getJavascriptCalls(Map map) {
        JavascriptContext.addtEffectJavascriptCalls(map);
        String code = (String)map.get(REQUEST_KEY);
        map.put(REQUEST_KEY, "");
        code = JavascriptContext.replaceDupes(code == null || "".equals(code) ? "" : code);
        if ("".equals(code)) {
            return "";
        }
        return code + JavascriptContext.randomComment();
    }

    public static String applyEffect(Effect effect, String id, FacesContext context) {
        UIComponent uiComponent = CoreComponentUtils.findComponent(id, (UIComponent)context.getViewRoot());
        if (uiComponent != null) {
            id = uiComponent.getClientId(context);
        }
        String name = JavascriptContext.genFunctionName(id, effect);
        String call = "window['" + name + "'] =  function (){" + "id = '" + id + "';" + effect.toString() + "};";
        JavascriptContext.addJavascriptCall(context, call);
        return name + "();";
    }

    public static void fireEffect(Effect effect, String id, FacesContext context) {
        if (effect == null || effect.isFired()) {
            return;
        }
        effect.setFired(true);
        UIViewRoot viewRoot = context.getViewRoot();
        try {
            UIComponent uiComponent = CoreComponentUtils.findComponent(id, (UIComponent)context.getViewRoot());
            if (uiComponent != null) {
                id = uiComponent.getClientId(context);
            }
        }
        catch (Exception e) {
            System.err.println("View Root is [" + viewRoot.getClass().getName() + "]");
            e.printStackTrace();
        }
        effect.setId(id);
        JavascriptContext.addEffect(effect, context);
    }

    public static void fireEffect(Effect effect, UIComponent component) {
        if (effect == null || effect.isFired()) {
            return;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        JavascriptContext.fireEffect(effect, component, facesContext);
    }

    public static void fireEffect(Effect effect, UIComponent component, FacesContext facesContext) {
        if (effect == null || effect.isFired()) {
            return;
        }
        String id = component.getClientId(facesContext);
        JavascriptContext.fireEffect(effect, id, facesContext);
    }

    public static void fireEffect(UIComponent uiComponent, FacesContext facesContext) {
        Effect effect = (Effect)uiComponent.getAttributes().get("effect");
        if (effect != null) {
            JavascriptContext.fireEffect(effect, uiComponent, facesContext);
        }
    }

    public static String getEffectFunctionForEvent(UIComponent uiComponent, String event, String id, FacesContext facesContext) {
        String result = null;
        Effect fx = JavascriptContext.getEffectForEvent(uiComponent, event);
        if (fx != null) {
            result = JavascriptContext.applyEffect(fx, id, facesContext);
        }
        return result;
    }

    private static Effect getEffectForEvent(UIComponent uiComponent, String event) {
        Effect result = null;
        Object o = uiComponent.getAttributes().get(event);
        if (o != null && o instanceof Effect) {
            result = (Effect)o;
        }
        return result;
    }

    private static String genFunctionName(String id, Effect effect) {
        StringBuffer sb = new StringBuffer("iceEffect");
        char[] ca = id.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            char c = ca[i];
            if (c > '@' && c < '[' || c > '`' && c < '{' || c > '/' && c < ':') {
                sb.append(ca[i]);
                continue;
            }
            sb.append('_');
        }
        sb.append(effect.hashCode());
        return sb.toString();
    }

    private static String replaceDupes(String s) {
        if (s.indexOf(";;") == -1) {
            return s;
        }
        s = s.replaceAll(";;", ";");
        return s;
    }

    public static void focus(FacesContext context, String id) {
        FocusController.setFocus((FacesContext)context, (String)id);
    }

    public static void applicationFocus(FacesContext facesContext, String id) {
        FocusController.setFocus((FacesContext)facesContext, (String)id);
    }

    private static void addEffect(Effect effect, FacesContext facesContext) {
        Map map = facesContext.getExternalContext().getRequestMap();
        ArrayList<Effect> list = (ArrayList<Effect>)map.get(EFFECTS_REQUEST_KEY);
        if (list == null) {
            list = new ArrayList<Effect>();
            map.put(EFFECTS_REQUEST_KEY, list);
        }
        list.add(effect);
    }

    private static void addtEffectJavascriptCalls(Map map) {
        String call;
        List list = (ArrayList)map.get(EFFECTS_REQUEST_KEY);
        if (list == null) {
            return;
        }
        HashMap sequencedEffects = new HashMap();
        for (Effect effect : list) {
            if (effect.getSequence() == null && !(effect instanceof EffectQueue)) {
                call = "id = '" + effect.getId() + "';" + effect.toString();
                JavascriptContext.addJavascriptCall(map, call);
                continue;
            }
            JavascriptContext.extractEffectSequence(effect, sequencedEffects);
        }
        if (sequencedEffects.size() > 0) {
            Iterator<Object> iter = sequencedEffects.values().iterator();
            int sequence = 0;
            while (iter.hasNext()) {
                list = (List)iter.next();
                Collections.sort(list, new EffectComparator());
                call = JavascriptContext.buildSequenceEffectCall(list, sequence);
                JavascriptContext.addJavascriptCall(map, call);
                ++sequence;
            }
        }
        map.remove(EFFECTS_REQUEST_KEY);
    }

    private static String buildSequenceEffectCall(List list, int sequence) {
        StringBuffer sb = new StringBuffer();
        Iterator effectIter = list.iterator();
        int effect = 0;
        String lastCall = null;
        while (effectIter.hasNext()) {
            Effect fx = (Effect)effectIter.next();
            String var = JavascriptContext.getVariableName(sequence, effect);
            lastCall = "var " + var + " = '" + fx.getId() + "';" + fx.toString(var, lastCall);
            ++effect;
        }
        return lastCall;
    }

    private static void extractEffectSequence(Effect effect, Map sequencedEffects) {
        String seqName = effect.getSequence();
        ArrayList<Effect> seq = (ArrayList<Effect>)sequencedEffects.get(seqName);
        if (seq == null) {
            seq = new ArrayList<Effect>();
            sequencedEffects.put(seqName, seq);
        }
        if (effect instanceof EffectQueue) {
            List eqList = ((EffectQueue)effect).getEffects();
            Iterator eqIter = eqList.iterator();
            int seqId = 0;
            while (eqIter.hasNext()) {
                Effect fx = (Effect)eqIter.next();
                fx.setSequence(seqName);
                fx.setSequenceId(seqId);
                fx.setId(effect.getId());
                seq.add(fx);
                ++seqId;
            }
        } else {
            seq.add(effect);
        }
    }

    private static String getVariableName(int sequence, int effect) {
        return "s" + sequence + "e" + effect;
    }

    private static String randomComment() {
        return "//" + RANDOM.nextInt();
    }
}

