/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.panelborder;

import com.icesoft.faces.component.ExtendedAttributeConstants;
import com.icesoft.faces.component.panelborder.PanelBorder;
import com.icesoft.faces.component.util.CustomComponentUtils;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;

public class PanelBorderRenderer
extends DomBasicRenderer {
    public static final String DEFAULT_LAYOUT = "default";
    public static final String REVERSE_W_E = "horizontal reverse";
    public static final String REVERSE_N_S = "vertical reverse";
    public static final String CENTER_ONLY = "center only";
    public static final String HIDE_N = "hide north";
    public static final String HIDE_E = "hide east";
    public static final String HIDE_S = "hide south";
    public static final String HIDE_W = "hide west";
    private static final String[] PASSTHRU_EXCLUDE = new String[]{"style"};
    private static final String[] PASSTHRU = ExtendedAttributeConstants.getAttributes(1, PASSTHRU_EXCLUDE);

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        super.encodeChildren(facesContext, uiComponent);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Element table;
        PanelBorderRenderer.validateParameters(facesContext, uiComponent, PanelBorder.class);
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        PanelBorder borderLayout = (PanelBorder)uiComponent;
        List layout = borderLayout.getLayoutAsList();
        String clientId = uiComponent.getClientId(facesContext);
        if (!domContext.isInitialized()) {
            table = domContext.createRootElement("table");
            PanelBorderRenderer.setRootElementId(facesContext, table, uiComponent);
            table.setAttribute("name", clientId);
        }
        table = (Element)domContext.getRootNode();
        PassThruAttributeRenderer.renderHtmlAttributes(facesContext, uiComponent, PASSTHRU);
        table.setAttribute("class", borderLayout.getStyleClass());
        String style = borderLayout.getStyle();
        if (style != null && style.length() > 0) {
            table.setAttribute("style", style);
        } else {
            table.removeAttribute("style");
        }
        DOMContext.removeChildren(table);
        this.renderPanel(facesContext, layout, table, borderLayout, domContext);
        if (borderLayout.getChildCount() > 0) {
            throw new RuntimeException("PanelBorder must not have children, only facets allowed!");
        }
        domContext.stepOver();
    }

    private void renderPanel(FacesContext facesContext, List facets, Element table, PanelBorder borderLayout, DOMContext domContext) throws IOException {
        String order = borderLayout.getLayout();
        if (order.equalsIgnoreCase(REVERSE_N_S)) {
            this.renderSouth(facesContext, domContext, borderLayout, facets, table);
            this.renderEastWestCenter(facesContext, domContext, borderLayout, facets, table);
            this.renderNorth(facesContext, domContext, borderLayout, facets, table);
        } else {
            this.renderNorth(facesContext, domContext, borderLayout, facets, table);
            this.renderEastWestCenter(facesContext, domContext, borderLayout, facets, table);
            this.renderSouth(facesContext, domContext, borderLayout, facets, table);
        }
    }

    private void renderEastWestCenter(FacesContext facesContext, DOMContext domContext, PanelBorder borderLayout, List facets, Element table) throws IOException {
        if (borderLayout.getWest() != null || borderLayout.getCenter() != null || borderLayout.getEast() != null) {
            Element tr = domContext.createElement("tr");
            table.appendChild(tr);
            String order = borderLayout.getLayout();
            if (order.equalsIgnoreCase(REVERSE_W_E)) {
                this.renderEast(facesContext, domContext, borderLayout, facets, tr);
                this.renderCenter(facesContext, domContext, borderLayout, facets, tr);
                this.renderWest(facesContext, domContext, borderLayout, facets, tr);
            } else {
                this.renderWest(facesContext, domContext, borderLayout, facets, tr);
                this.renderCenter(facesContext, domContext, borderLayout, facets, tr);
                this.renderEast(facesContext, domContext, borderLayout, facets, tr);
            }
        }
    }

    private void renderWest(FacesContext facesContext, DOMContext domContext, PanelBorder borderLayout, List facets, Element tr) throws IOException {
        if (facets.contains("west")) {
            this.renderTableCells(facesContext, borderLayout, tr, "west", domContext);
        }
    }

    private void renderCenter(FacesContext facesContext, DOMContext domContext, PanelBorder borderLayout, List facets, Element tr) throws IOException {
        if (facets.contains("center")) {
            this.renderTableCells(facesContext, borderLayout, tr, "center", domContext);
        }
    }

    private void renderEast(FacesContext facesContext, DOMContext domContext, PanelBorder borderLayout, List facets, Element tr) throws IOException {
        if (facets.contains("east")) {
            this.renderTableCells(facesContext, borderLayout, tr, "east", domContext);
        }
    }

    private void renderNorth(FacesContext facesContext, DOMContext domContext, PanelBorder borderLayout, List facets, Element table) throws IOException {
        if (borderLayout.getNorth() != null && facets.contains("north")) {
            Element tr = domContext.createElement("tr");
            table.appendChild(tr);
            this.renderTableCells(facesContext, borderLayout, tr, "north", domContext);
        }
    }

    private void renderSouth(FacesContext facesContext, DOMContext domContext, PanelBorder borderLayout, List facets, Element table) throws IOException {
        if (borderLayout.getSouth() != null && facets.contains("south")) {
            Element tr = domContext.createElement("tr");
            table.appendChild(tr);
            this.renderTableCells(facesContext, borderLayout, tr, "south", domContext);
        }
    }

    private Element getTD(FacesContext facesContext, PanelBorder borderLayout, DOMContext domContext, Element tr) throws IOException {
        Element td = domContext.createElement("td");
        tr.appendChild(td);
        domContext.setCursorParent(td);
        return td;
    }

    private void renderTableCells(FacesContext facesContext, PanelBorder borderLayout, Element tr, String facet, DOMContext domContext) throws IOException {
        int width;
        UIComponent north = borderLayout.getNorth();
        UIComponent west = borderLayout.getWest();
        UIComponent east = borderLayout.getEast();
        UIComponent center = borderLayout.getCenter();
        UIComponent south = borderLayout.getSouth();
        if (facet.equals("north") && north != null) {
            width = 0;
            if (west != null) {
                ++width;
            }
            if (east != null) {
                ++width;
            }
            if (center != null) {
                ++width;
            }
            this.renderTableCell(facesContext, north, this.getTD(facesContext, borderLayout, domContext, tr), width == 0 ? 1 : width, borderLayout.getNorthClass(), null, borderLayout);
        }
        if (facet.equals("west") && west != null) {
            this.renderTableCell(facesContext, west, this.getTD(facesContext, borderLayout, domContext, tr), 1, borderLayout.getWestClass(), null, borderLayout);
        }
        if (facet.equals("east") && east != null) {
            this.renderTableCell(facesContext, east, this.getTD(facesContext, borderLayout, domContext, tr), 1, borderLayout.getEastClass(), null, borderLayout);
        }
        if (facet.equals("center") && center != null) {
            this.renderTableCell(facesContext, center, this.getTD(facesContext, borderLayout, domContext, tr), 1, borderLayout.getCenterClass(), null, borderLayout);
        }
        if (facet.equals("south") && south != null) {
            width = 0;
            if (west != null) {
                ++width;
            }
            if (east != null) {
                ++width;
            }
            if (center != null) {
                ++width;
            }
            this.renderTableCell(facesContext, south, this.getTD(facesContext, borderLayout, domContext, tr), width == 0 ? 1 : width, borderLayout.getSouthClass(), null, borderLayout);
        }
    }

    private void renderTableCell(FacesContext facesContext, UIComponent component, Element td, int colspan, String styleClass, String style, PanelBorder panelBorder) throws IOException {
        if (colspan > 0) {
            td.setAttribute("colspan", Integer.toString(colspan));
        } else {
            td.removeAttribute("colspan");
        }
        if (styleClass != null && styleClass.length() > 0) {
            td.setAttribute("class", styleClass);
        } else {
            td.removeAttribute("class");
        }
        if (style != null && style.length() > 0) {
            td.setAttribute("style", style);
        } else {
            td.removeAttribute("style");
        }
        DOMContext domContext = DOMContext.getDOMContext(facesContext, (UIComponent)panelBorder);
        CustomComponentUtils.renderChild(facesContext, component);
    }
}

