/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.traces.impl;

import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class OpenTelemetryProperties
implements ConfigProperties {
    private final Map<String, String> config;

    @SafeVarargs
    OpenTelemetryProperties(Map<String, String> ... arrayOfProperties) {
        HashMap<String, String> config = new HashMap<String, String>();
        for (Map<String, String> props : arrayOfProperties) {
            props.forEach((key, value) -> config.put(key.toLowerCase(Locale.ROOT).replace('-', '.'), (String)value));
        }
        this.config = config;
    }

    @Nullable
    public String getString(String name) {
        return this.config.get(name);
    }

    @Nullable
    public Boolean getBoolean(String name) {
        String value = this.config.get(name);
        if (value == null || value.isEmpty()) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    @Nullable
    public Integer getInt(String name) {
        String value = this.config.get(name);
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException ex) {
            throw OpenTelemetryProperties.newInvalidPropertyException(name, value, "integer", ex);
        }
    }

    @Nullable
    public Long getLong(String name) {
        String value = this.config.get(name);
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException ex) {
            throw OpenTelemetryProperties.newInvalidPropertyException(name, value, "long", ex);
        }
    }

    @Nullable
    public Double getDouble(String name) {
        String value = this.config.get(name);
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException ex) {
            throw OpenTelemetryProperties.newInvalidPropertyException(name, value, "double", ex);
        }
    }

    @Nullable
    public Duration getDuration(String name) {
        String value = this.config.get(name);
        if (value == null || value.isEmpty()) {
            return null;
        }
        String unitString = OpenTelemetryProperties.getUnitString(value);
        String numberString = value.substring(0, value.length() - unitString.length());
        try {
            long rawNumber = Long.parseLong(numberString.trim());
            TimeUnit unit = OpenTelemetryProperties.getDurationUnit(unitString.trim()).orElseThrow(() -> new ConfigurationException("Invalid duration property " + name + "=" + value + ". Invalid duration unit."));
            return Duration.ofMillis(TimeUnit.MILLISECONDS.convert(rawNumber, unit));
        }
        catch (NumberFormatException ex) {
            ConfigurationException e = new ConfigurationException("Invalid duration property " + name + "=" + value + ". Expected number, found: " + numberString);
            e.addSuppressed((Throwable)ex);
            throw e;
        }
    }

    public List<String> getList(String name) {
        String value = this.config.get(name);
        if (value == null) {
            return Collections.emptyList();
        }
        return OpenTelemetryProperties.filterBlanksAndNulls(value.split(","));
    }

    public Map<String, String> getMap(String name) {
        return this.getList(name).stream().map(keyValuePair -> OpenTelemetryProperties.filterBlanksAndNulls(keyValuePair.split("=", 2))).map(splitKeyValuePairs -> {
            if (splitKeyValuePairs.size() != 2) {
                throw new ConfigurationException("Invalid map property: " + name + "=" + this.config.get(name));
            }
            return new AbstractMap.SimpleImmutableEntry<String, String>((String)splitKeyValuePairs.get(0), (String)splitKeyValuePairs.get(1));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (first, next) -> next, LinkedHashMap::new));
    }

    private static ConfigurationException newInvalidPropertyException(String name, String value, String type, Exception cause) {
        ConfigurationException e = new ConfigurationException("Invalid value for property " + name + "=" + value + ". Must be a " + type + ".");
        e.addSuppressed((Throwable)cause);
        throw e;
    }

    private static List<String> filterBlanksAndNulls(String[] values) {
        return Arrays.stream(values).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private static Optional<TimeUnit> getDurationUnit(String unitString) {
        switch (unitString) {
            case "": 
            case "ms": {
                return Optional.of(TimeUnit.MILLISECONDS);
            }
            case "s": {
                return Optional.of(TimeUnit.SECONDS);
            }
            case "m": {
                return Optional.of(TimeUnit.MINUTES);
            }
            case "h": {
                return Optional.of(TimeUnit.HOURS);
            }
            case "d": {
                return Optional.of(TimeUnit.DAYS);
            }
        }
        return Optional.empty();
    }

    private static String getUnitString(String rawValue) {
        char c;
        int lastDigitIndex;
        for (lastDigitIndex = rawValue.length() - 1; lastDigitIndex >= 0 && !Character.isDigit(c = rawValue.charAt(lastDigitIndex)); --lastDigitIndex) {
        }
        return rawValue.substring(lastDigitIndex + 1);
    }
}

