/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim.impl;

import com.google.protobuf.ByteString;
import org.hyperledger.fabric.protos.ledger.queryresult.KV;
import org.hyperledger.fabric.shim.ledger.KeyValue;

class KeyValueImpl
implements KeyValue {
    private final String key;
    private final ByteString value;

    KeyValueImpl(KV kv) {
        this.key = kv.getKey();
        this.value = kv.getValue();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public byte[] getValue() {
        return this.value.toByteArray();
    }

    @Override
    public String getStringValue() {
        return this.value.toStringUtf8();
    }

    public int hashCode() {
        int prime = 31;
        int result = this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        KeyValueImpl that = (KeyValueImpl)other;
        return this.key.equals(that.key) && this.value.equals((Object)that.value);
    }
}

