/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.metrics;

import java.util.Properties;
import java.util.logging.Logger;
import org.hyperledger.fabric.metrics.MetricsProvider;
import org.hyperledger.fabric.metrics.impl.DefaultProvider;
import org.hyperledger.fabric.metrics.impl.NullProvider;

public final class Metrics {
    private static final String CHAINCODE_METRICS_ENABLED = "CHAINCODE_METRICS_ENABLED";
    private static final String CHAINCODE_METRICS_PROVIDER = "CHAINCODE_METRICS_PROVIDER";
    private static Logger logger = Logger.getLogger(Metrics.class.getName());
    private static MetricsProvider provider;

    private Metrics() {
    }

    public static MetricsProvider initialize(Properties props) {
        if (Boolean.parseBoolean((String)props.get(CHAINCODE_METRICS_ENABLED))) {
            try {
                logger.info("Metrics enabled");
                if (props.containsKey(CHAINCODE_METRICS_PROVIDER)) {
                    String providerClass = (String)props.get(CHAINCODE_METRICS_PROVIDER);
                    Class<?> clazz = Class.forName(providerClass);
                    provider = (MetricsProvider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                logger.info("Using default metrics provider (logs to org.hyperledger.Performance)");
                provider = new DefaultProvider();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to start metrics", e);
            }
        } else {
            logger.info("Metrics disabled");
            provider = new NullProvider();
        }
        provider.initialize(props);
        return provider;
    }

    public static MetricsProvider getProvider() {
        if (provider == null) {
            throw new IllegalStateException("No provider set, this should have been set");
        }
        return provider;
    }
}

