/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.contract.metadata;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.hyperledger.fabric.Logger;
import org.hyperledger.fabric.contract.ContractRuntimeException;
import org.hyperledger.fabric.contract.metadata.MetadataBuilder;
import org.hyperledger.fabric.contract.routing.TypeRegistry;
import org.json.JSONObject;

public final class TypeSchema
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(TypeSchema.class.getName());
    private static final String SCHEMA_PROP = "schema";
    private static final String TYPE_PROP = "type";
    private static final String ITEMS_PROP = "items";
    private static final String FORMAT_PROP = "format";
    private static final String INTEGER_TYPE = "integer";

    private Object putInternal(String key, Object value) {
        if (value != null && !value.toString().isEmpty()) {
            return this.put(key, value);
        }
        return null;
    }

    String putIfNotNull(String key, String value) {
        return (String)this.putInternal(key, value);
    }

    String[] putIfNotNull(String key, String[] value) {
        return (String[])this.putInternal(key, value);
    }

    TypeSchema putIfNotNull(String key, TypeSchema value) {
        return (TypeSchema)this.putInternal(key, value);
    }

    TypeSchema[] putIfNotNull(String key, TypeSchema[] value) {
        return (TypeSchema[])this.putInternal(key, value);
    }

    public String getType() {
        if (this.containsKey(SCHEMA_PROP)) {
            Map intermediateMap = (Map)this.get(SCHEMA_PROP);
            return (String)intermediateMap.get(TYPE_PROP);
        }
        return (String)this.get(TYPE_PROP);
    }

    public TypeSchema getItems() {
        if (this.containsKey(SCHEMA_PROP)) {
            Map intermediateMap = (Map)this.get(SCHEMA_PROP);
            return (TypeSchema)intermediateMap.get(ITEMS_PROP);
        }
        return (TypeSchema)this.get(ITEMS_PROP);
    }

    public String getRef() {
        if (this.containsKey(SCHEMA_PROP)) {
            Map intermediateMap = (Map)this.get(SCHEMA_PROP);
            return (String)intermediateMap.get("$ref");
        }
        return (String)this.get("$ref");
    }

    public String getFormat() {
        if (this.containsKey(SCHEMA_PROP)) {
            Map intermediateMap = (Map)this.get(SCHEMA_PROP);
            return (String)intermediateMap.get(FORMAT_PROP);
        }
        return (String)this.get(FORMAT_PROP);
    }

    public Class<?> getTypeClass(TypeRegistry typeRegistry) {
        String type;
        switch (type = Optional.ofNullable(this.getType()).orElse("object")) {
            case "object": {
                return this.getObjectClass(typeRegistry);
            }
            case "string": {
                return this.getStringClass();
            }
            case "integer": {
                return this.getIntegerClass();
            }
            case "number": {
                return this.getNumberClass();
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "array": {
                return this.getArrayClass(typeRegistry);
            }
        }
        return null;
    }

    private Class<?> getArrayClass(TypeRegistry typeRegistry) {
        TypeSchema typdef = this.getItems();
        Class<?> arrayType = typdef.getTypeClass(typeRegistry);
        return Array.newInstance(arrayType, 0).getClass();
    }

    private Class<?> getNumberClass() {
        switch (this.getFormat()) {
            case "double": {
                return Double.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
        }
        throw new IllegalArgumentException("Unknown format for number of " + this.getFormat());
    }

    private Class<?> getIntegerClass() {
        switch (this.getFormat()) {
            case "int8": {
                return Byte.TYPE;
            }
            case "int16": {
                return Short.TYPE;
            }
            case "int32": {
                return Integer.TYPE;
            }
            case "int64": {
                return Long.TYPE;
            }
        }
        throw new IllegalArgumentException("Unknown format for integer of " + this.getFormat());
    }

    private Class<?> getStringClass() {
        if ("uint16".equals(this.getFormat())) {
            return Character.TYPE;
        }
        return String.class;
    }

    private Class<?> getObjectClass(TypeRegistry typeRegistry) {
        String ref = this.getRef();
        String format = ref.substring(ref.lastIndexOf(47) + 1);
        return typeRegistry.getDataType(format).getTypeClass();
    }

    public static TypeSchema typeConvert(Class<?> clz) {
        TypeSchema result;
        String className = clz.getTypeName();
        if ("void".equals(className)) {
            return null;
        }
        TypeSchema schema = result = new TypeSchema();
        if (clz.isArray()) {
            result.put(TYPE_PROP, "array");
            schema = new TypeSchema();
            Class<?> componentClass = clz.getComponentType();
            className = componentClass.getTypeName();
            if (componentClass.isArray()) {
                result.put(ITEMS_PROP, TypeSchema.typeConvert(componentClass));
            } else {
                result.put(ITEMS_PROP, schema);
            }
        }
        TypeSchema.updateSchemaForClass(schema, className);
        return result;
    }

    private static void updateSchemaForClass(TypeSchema schema, String className) {
        switch (className) {
            case "java.lang.String": {
                schema.put(TYPE_PROP, "string");
                return;
            }
            case "char": 
            case "java.lang.Character": {
                schema.put(TYPE_PROP, "string");
                schema.put(FORMAT_PROP, "uint16");
                return;
            }
            case "byte": 
            case "java.lang.Byte": {
                schema.put(TYPE_PROP, INTEGER_TYPE);
                schema.put(FORMAT_PROP, "int8");
                return;
            }
            case "short": 
            case "java.lang.Short": {
                schema.put(TYPE_PROP, INTEGER_TYPE);
                schema.put(FORMAT_PROP, "int16");
                return;
            }
            case "int": 
            case "java.lang.Integer": {
                schema.put(TYPE_PROP, INTEGER_TYPE);
                schema.put(FORMAT_PROP, "int32");
                return;
            }
            case "long": 
            case "java.lang.Long": {
                schema.put(TYPE_PROP, INTEGER_TYPE);
                schema.put(FORMAT_PROP, "int64");
                return;
            }
            case "double": 
            case "java.lang.Double": {
                schema.put(TYPE_PROP, "number");
                schema.put(FORMAT_PROP, "double");
                return;
            }
            case "float": 
            case "java.lang.Float": {
                schema.put(TYPE_PROP, "number");
                schema.put(FORMAT_PROP, "float");
                return;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                schema.put(TYPE_PROP, "boolean");
                return;
            }
        }
        schema.put("$ref", "#/components/schemas/" + className.substring(className.lastIndexOf(46) + 1));
    }

    public void validate(JSONObject obj) {
        JSONObject toValidate = new JSONObject();
        toValidate.put("prop", (Object)obj);
        JSONObject schemaJSON = this.containsKey(SCHEMA_PROP) ? new JSONObject((Map)this.get(SCHEMA_PROP)) : new JSONObject((Map)this);
        JSONObject rawSchema = new JSONObject();
        rawSchema.put("properties", (Object)new JSONObject().put("prop", (Object)schemaJSON));
        rawSchema.put("components", (Object)new JSONObject().put("schemas", MetadataBuilder.getComponents()));
        Schema schema = SchemaLoader.load((JSONObject)rawSchema);
        try {
            schema.validate((Object)toValidate);
        }
        catch (ValidationException e) {
            StringBuilder sb = new StringBuilder("Validation Errors::");
            e.getCausingExceptions().stream().map(ValidationException::getMessage).forEach(sb::append);
            String message = sb.toString();
            LOGGER.info(message);
            throw new ContractRuntimeException(message, e);
        }
    }
}

