/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim.ext.sbe.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.common.MSPPrincipal;
import org.hyperledger.fabric.protos.common.MSPRole;
import org.hyperledger.fabric.protos.common.SignaturePolicy;
import org.hyperledger.fabric.protos.common.SignaturePolicyEnvelope;
import org.hyperledger.fabric.shim.ext.sbe.StateBasedEndorsement;
import org.hyperledger.fabric.shim.ext.sbe.impl.StateBasedEndorsementUtils;

public final class StateBasedEndorsementImpl
implements StateBasedEndorsement {
    private static Log logger = LogFactory.getLog(StateBasedEndorsementImpl.class);
    private final Map<String, MSPRole.MSPRoleType> orgs = new HashMap<String, MSPRole.MSPRoleType>();

    StateBasedEndorsementImpl(byte[] ep) {
        byte[] sbe = ep == null ? new byte[]{} : ep;
        try {
            SignaturePolicyEnvelope spe = SignaturePolicyEnvelope.parseFrom((byte[])sbe);
            this.setMSPIDsFromSP(spe);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("error unmarshalling endorsement policy bytes", e);
        }
    }

    @Override
    public byte[] policy() {
        SignaturePolicyEnvelope spe = this.policyFromMSPIDs();
        return spe.toByteArray();
    }

    @Override
    public void addOrgs(StateBasedEndorsement.RoleType role, String ... organizations) {
        MSPRole.MSPRoleType mspRole = StateBasedEndorsement.RoleType.RoleTypeMember.equals((Object)role) ? MSPRole.MSPRoleType.MEMBER : MSPRole.MSPRoleType.PEER;
        for (String neworg : organizations) {
            this.orgs.put(neworg, mspRole);
        }
    }

    @Override
    public void delOrgs(String ... organizations) {
        for (String delorg : organizations) {
            this.orgs.remove(delorg);
        }
    }

    @Override
    public List<String> listOrgs() {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(this.orgs.keySet());
        return res;
    }

    private void setMSPIDsFromSP(SignaturePolicyEnvelope spe) {
        spe.getIdentitiesList().stream().filter(identity -> MSPPrincipal.Classification.ROLE.equals((Object)identity.getPrincipalClassification())).forEach(this::addOrg);
    }

    private void addOrg(MSPPrincipal identity) {
        try {
            MSPRole mspRole = MSPRole.parseFrom((ByteString)identity.getPrincipal());
            this.orgs.put(mspRole.getMspIdentifier(), mspRole.getRole());
        }
        catch (InvalidProtocolBufferException e) {
            logger.warn((Object)"error unmarshalling msp principal");
            throw new IllegalArgumentException("error unmarshalling msp principal", e);
        }
    }

    private SignaturePolicyEnvelope policyFromMSPIDs() {
        List<String> mspids = this.listOrgs();
        mspids.sort(Comparator.naturalOrder());
        ArrayList<MSPPrincipal> principals = new ArrayList<MSPPrincipal>();
        ArrayList<SignaturePolicy> sigpolicy = new ArrayList<SignaturePolicy>();
        for (int i = 0; i < mspids.size(); ++i) {
            String mspid = mspids.get(i);
            principals.add(MSPPrincipal.newBuilder().setPrincipalClassification(MSPPrincipal.Classification.ROLE).setPrincipal(MSPRole.newBuilder().setMspIdentifier(mspid).setRole(this.orgs.get(mspid)).build().toByteString()).build());
            sigpolicy.add(StateBasedEndorsementUtils.signedBy(i));
        }
        return SignaturePolicyEnvelope.newBuilder().setVersion(0).setRule(StateBasedEndorsementUtils.nOutOf(mspids.size(), sigpolicy)).addAllIdentities(principals).build();
    }
}

