/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim;

import java.net.SocketAddress;

public final class ChaincodeServerProperties {
    private SocketAddress serverAddress;
    private int maxInboundMetadataSize = 0x6400000;
    private int maxInboundMessageSize = 0x6400000;
    private int maxConnectionAgeSeconds = 5;
    private int keepAliveTimeoutSeconds = 20;
    private int permitKeepAliveTimeMinutes = 1;
    private int keepAliveTimeMinutes = 1;
    private boolean permitKeepAliveWithoutCalls = true;
    private String keyPassword;
    private String keyCertChainFile;
    private String keyFile;
    private String trustCertCollectionFile;
    private boolean tlsEnabled = false;

    public ChaincodeServerProperties() {
    }

    public ChaincodeServerProperties(int portChaincodeServer, int maxInboundMetadataSize, int maxInboundMessageSize, int maxConnectionAgeSeconds, int keepAliveTimeoutSeconds, int permitKeepAliveTimeMinutes, int keepAliveTimeMinutes, boolean permitKeepAliveWithoutCalls) {
        this.serverAddress = null;
        this.maxInboundMetadataSize = maxInboundMetadataSize;
        this.maxInboundMessageSize = maxInboundMessageSize;
        this.maxConnectionAgeSeconds = maxConnectionAgeSeconds;
        this.keepAliveTimeoutSeconds = keepAliveTimeoutSeconds;
        this.permitKeepAliveTimeMinutes = permitKeepAliveTimeMinutes;
        this.keepAliveTimeMinutes = keepAliveTimeMinutes;
        this.permitKeepAliveWithoutCalls = permitKeepAliveWithoutCalls;
    }

    public int getMaxInboundMetadataSize() {
        return this.maxInboundMetadataSize;
    }

    public void setMaxInboundMetadataSize(int maxInboundMetadataSize) {
        this.maxInboundMetadataSize = maxInboundMetadataSize;
    }

    public int getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public void setMaxInboundMessageSize(int maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    public int getMaxConnectionAgeSeconds() {
        return this.maxConnectionAgeSeconds;
    }

    public void setMaxConnectionAgeSeconds(int maxConnectionAgeSeconds) {
        this.maxConnectionAgeSeconds = maxConnectionAgeSeconds;
    }

    public int getKeepAliveTimeoutSeconds() {
        return this.keepAliveTimeoutSeconds;
    }

    public void setKeepAliveTimeoutSeconds(int keepAliveTimeoutSeconds) {
        this.keepAliveTimeoutSeconds = keepAliveTimeoutSeconds;
    }

    public int getPermitKeepAliveTimeMinutes() {
        return this.permitKeepAliveTimeMinutes;
    }

    public void setPermitKeepAliveTimeMinutes(int permitKeepAliveTimeMinutes) {
        this.permitKeepAliveTimeMinutes = permitKeepAliveTimeMinutes;
    }

    public int getKeepAliveTimeMinutes() {
        return this.keepAliveTimeMinutes;
    }

    public void setKeepAliveTimeMinutes(int keepAliveTimeMinutes) {
        this.keepAliveTimeMinutes = keepAliveTimeMinutes;
    }

    public boolean getPermitKeepAliveWithoutCalls() {
        return this.permitKeepAliveWithoutCalls;
    }

    public SocketAddress getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(SocketAddress address) {
        this.serverAddress = address;
    }

    public boolean isPermitKeepAliveWithoutCalls() {
        return this.permitKeepAliveWithoutCalls;
    }

    public void setPermitKeepAliveWithoutCalls(boolean permitKeepAliveWithoutCalls) {
        this.permitKeepAliveWithoutCalls = permitKeepAliveWithoutCalls;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getKeyCertChainFile() {
        return this.keyCertChainFile;
    }

    public void setKeyCertChainFile(String keyCertChainFile) {
        this.keyCertChainFile = keyCertChainFile;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public void setKeyFile(String keyFile) {
        this.keyFile = keyFile;
    }

    public String getTrustCertCollectionFile() {
        return this.trustCertCollectionFile;
    }

    public void setTrustCertCollectionFile(String trustCertCollectionFile) {
        this.trustCertCollectionFile = trustCertCollectionFile;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public void setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
    }

    public void validate() {
        if (this.getServerAddress() == null) {
            throw new IllegalArgumentException("chaincodeServerProperties.getServerAddress() must be set");
        }
        if (this.getKeepAliveTimeMinutes() <= 0) {
            throw new IllegalArgumentException("chaincodeServerProperties.getKeepAliveTimeMinutes() must be more then 0");
        }
        if (this.getKeepAliveTimeoutSeconds() <= 0) {
            throw new IllegalArgumentException("chaincodeServerProperties.getKeepAliveTimeoutSeconds() must be more then 0");
        }
        if (this.getPermitKeepAliveTimeMinutes() <= 0) {
            throw new IllegalArgumentException("chaincodeServerProperties.getPermitKeepAliveTimeMinutes() must be more then 0");
        }
        if (this.getMaxConnectionAgeSeconds() <= 0) {
            throw new IllegalArgumentException("chaincodeServerProperties.getMaxConnectionAgeSeconds() must be more then 0");
        }
        if (this.getMaxInboundMetadataSize() <= 0) {
            throw new IllegalArgumentException("chaincodeServerProperties.getMaxInboundMetadataSize() must be more then 0");
        }
        if (this.getMaxInboundMessageSize() <= 0) {
            throw new IllegalArgumentException("chaincodeServerProperties.getMaxInboundMessageSize() must be more then 0");
        }
        if (this.isTlsEnabled() && (this.getKeyCertChainFile() == null || this.getKeyCertChainFile().isEmpty() || this.getKeyFile() == null || this.getKeyFile().isEmpty())) {
            throw new IllegalArgumentException("if chaincodeServerProperties.isTlsEnabled() must be more specified chaincodeServerProperties.getKeyCertChainFile() and chaincodeServerProperties.getKeyFile() with optional chaincodeServerProperties.getKeyPassword()");
        }
    }
}

