/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh;

import hudson.model.Describable;
import hudson.model.Hudson;
import java.util.ArrayList;
import jenkins.plugins.publish_over.BapPublisher;
import jenkins.plugins.publish_over.Credentials;
import jenkins.plugins.publish_over.PublisherLabel;
import jenkins.plugins.publish_over.Retry;
import jenkins.plugins.publish_over_ssh.BapSshCredentials;
import jenkins.plugins.publish_over_ssh.BapSshPublisherLabel;
import jenkins.plugins.publish_over_ssh.BapSshRetry;
import jenkins.plugins.publish_over_ssh.BapSshTransfer;
import jenkins.plugins.publish_over_ssh.descriptor.BapSshPublisherDescriptor;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BapSshPublisher
extends BapPublisher<BapSshTransfer>
implements Describable<BapSshPublisher> {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public BapSshPublisher(String configName, boolean verbose, ArrayList<BapSshTransfer> transfers, boolean useWorkspaceInPromotion, boolean usePromotionTimestamp, BapSshRetry sshRetry, BapSshPublisherLabel sshLabel, BapSshCredentials sshCredentials) {
        super(configName, verbose, transfers, useWorkspaceInPromotion, usePromotionTimestamp, (Retry)sshRetry, (PublisherLabel)sshLabel, (Credentials)sshCredentials);
    }

    public final boolean isSftpRequired() {
        for (BapSshTransfer transfer : this.getTransfers()) {
            if (!transfer.hasConfiguredSourceFiles()) continue;
            return true;
        }
        return false;
    }

    public BapSshRetry getSshRetry() {
        return (BapSshRetry)super.getRetry();
    }

    public BapSshPublisherLabel getSshLabel() {
        return (BapSshPublisherLabel)super.getLabel();
    }

    public BapSshCredentials getSshCredentials() {
        return (BapSshCredentials)this.getCredentials();
    }

    public BapSshPublisherDescriptor getDescriptor() {
        return (BapSshPublisherDescriptor)Hudson.getInstance().getDescriptorByType(BapSshPublisherDescriptor.class);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || ((Object)((Object)this)).getClass() != that.getClass()) {
            return false;
        }
        return this.addToEquals(new EqualsBuilder(), (BapSshPublisher)((Object)that)).isEquals();
    }

    public int hashCode() {
        return this.addToHashCode(new HashCodeBuilder()).toHashCode();
    }

    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).toString();
    }
}

