/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.browsers.QueryBuilder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ViewGitWeb
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    private final URL url;
    private final String projectName;

    @DataBoundConstructor
    public ViewGitWeb(String url, String projectName) throws MalformedURLException {
        this.url = ViewGitWeb.normalizeToEndWithSlash((URL)new URL(url));
        this.projectName = projectName;
    }

    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType() == EditType.EDIT) {
            String spec = this.buildCommitDiffSpec(path);
            return new URL(this.url, this.url.getPath() + spec);
        }
        return null;
    }

    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType() == EditType.DELETE) {
            String spec = this.buildCommitDiffSpec(path);
            return new URL(this.url, this.url.getPath() + spec);
        }
        String spec = this.param().add("p=" + this.projectName).add("a=viewblob").add("h=" + path.getDst()).add("f=" + path.getPath()).toString();
        return new URL(this.url, this.url.getPath() + spec);
    }

    private String buildCommitDiffSpec(GitChangeSet.Path path) throws UnsupportedEncodingException {
        return this.param().add("p=" + this.projectName).add("a=commitdiff").add("h=" + path.getChangeSet().getId()).toString() + "#" + URLEncoder.encode(path.getPath(), "UTF-8").toString();
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        return new URL(this.url, this.url.getPath() + this.param().add("p=" + this.projectName).add("a=commit").add("h=" + changeSet.getId()).toString());
    }

    private QueryBuilder param() {
        return new QueryBuilder(this.url.getQuery());
    }

    public URL getUrl() {
        return this.url;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ViewGitWeb that = (ViewGitWeb)((Object)o);
        return new EqualsBuilder().append((Object)this.url, (Object)that.url).append((Object)this.projectName, (Object)that.projectName).isEquals();
    }

    public int hashCode() {
        return this.url != null ? this.url.hashCode() : 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class ViewGitWebDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "viewgit";
        }

        public ViewGitWeb newInstance(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            return (ViewGitWeb)((Object)req.bindParameters(ViewGitWeb.class, "viewgit."));
        }

        public FormValidation doCheckUrl(@QueryParameter(fixEmpty=true) String url) throws IOException, ServletException {
            return new GitRepositoryBrowser.GitUrlChecker(url, "ViewGit").check();
        }
    }
}

