/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ODCS
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    private final URL url;

    @DataBoundConstructor
    public ODCS(String url) throws MalformedURLException {
        if (url != null && !url.endsWith("/")) {
            url = url + "/";
        }
        this.url = new URL(url);
    }

    public URL getUrl() {
        return this.url;
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        String changeSetURLString = String.format("%s/commit/%s", this.urlAsStringWithoutSlash(), changeSet.getId().toString());
        return new URL(changeSetURLString);
    }

    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        String changeSetURLString = String.format("%s/commit/%s?oi=%s", this.urlAsStringWithoutSlash(), changeSet.getId().toString(), path.getPath());
        return new URL(changeSetURLString);
    }

    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType().equals(EditType.DELETE)) {
            return this.getDiffLink(path);
        }
        String changeSetURLString = String.format("%s/blob/%s?revision=%s", this.urlAsStringWithoutSlash(), path.getPath(), path.getChangeSet().getId());
        return new URL(changeSetURLString);
    }

    private String urlAsStringWithoutSlash() {
        String urlString = this.url.toString();
        while (urlString.endsWith("/")) {
            urlString = urlString.substring(0, urlString.length() - 1);
        }
        return urlString;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class ODCSDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "ODCS";
        }

        public ODCS newInstance(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            return (ODCS)((Object)req.bindJSON(ODCS.class, jsonObject));
        }
    }
}

