/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Messages;
import hudson.plugins.git.Revision;
import hudson.plugins.git.Tag;
import hudson.remoting.VirtualChannel;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitAPI
implements IGitAPI {
    private static final Logger LOGGER = Logger.getLogger(GitAPI.class.getName());
    private Launcher launcher;
    private FilePath workspace;
    private TaskListener listener;
    private String gitExe;
    private EnvVars environment;
    private Git jGitDelegate;
    private PersonIdent author;
    private PersonIdent committer;

    public GitAPI(String gitExe, FilePath workspace, TaskListener listener, EnvVars environment) {
        this.workspace = workspace;
        this.listener = listener;
        this.gitExe = gitExe;
        this.environment = environment;
        this.launcher = new Launcher.LocalLauncher(GitSCM.VERBOSE ? listener : TaskListener.NULL);
        if (this.hasGitRepo()) {
            try {
                File gitDir = RepositoryCache.FileKey.resolve((File)new File(workspace.getRemote()), (FS)FS.DETECTED);
                this.setDelegate(Git.wrap((Repository)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(gitDir)).build()));
            }
            catch (IOException e) {
                e.printStackTrace(listener.getLogger());
            }
        }
    }

    @Override
    public void close() {
        if (this.jGitDelegate != null) {
            this.jGitDelegate.close();
            this.jGitDelegate = null;
        }
    }

    private void setDelegate(Git delegate) {
        this.close();
        this.jGitDelegate = delegate;
    }

    protected PersonIdent getAuthor() {
        return this.author;
    }

    protected PersonIdent getCommitter() {
        return this.committer;
    }

    @Override
    public String getGitExe() {
        return this.gitExe;
    }

    @Override
    public EnvVars getEnvironment() {
        return this.environment;
    }

    @Override
    public void init() throws GitException {
        if (this.hasGitRepo()) {
            throw new GitException(Messages.GitAPI_Repository_FailedInitTwiceMsg());
        }
        try {
            this.setDelegate(Git.init().setDirectory(new File(this.workspace.getRemote())).call());
        }
        catch (GitAPIException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    public boolean hasGitRepo() throws GitException {
        return this.hasGitRepo(".git");
    }

    public boolean hasGitRepo(String gitDir) throws GitException {
        if (this.workspace == null) {
            return false;
        }
        try {
            FilePath dotGit = this.workspace.child(gitDir);
            return dotGit.exists();
        }
        catch (SecurityException ex) {
            throw new GitException(Messages.GitAPI_Repository_SecurityFailureCheckMsg(), ex);
        }
        catch (Exception e) {
            throw new GitException(Messages.GitAPI_Repository_FailedCheckMsg(), e);
        }
    }

    @Override
    public boolean hasGitModules() throws GitException {
        try {
            FilePath dotGit = this.workspace.child(".gitmodules");
            return dotGit.exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .gitmodules. Are you sure you have correct permissions?", ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .gitmodules", e);
        }
    }

    @Override
    public List<IndexEntry> getSubmodules(String treeIsh) throws GitException {
        List<IndexEntry> submodules = this.lsTree(treeIsh);
        Iterator<IndexEntry> it = submodules.iterator();
        while (it.hasNext()) {
            if (it.next().getMode().equals("160000")) continue;
            it.remove();
        }
        return submodules;
    }

    @Override
    public boolean hasGitModules(String treeIsh) throws GitException {
        return this.hasGitModules() && !this.getSubmodules(treeIsh).isEmpty();
    }

    @Override
    public void fetch(String repository, String refspec) throws GitException {
        this.listener.getLogger().println("Fetching upstream changes" + (repository != null ? " from " + repository : ""));
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"fetch", "-t"});
        if (repository != null) {
            args.add(repository);
            if (refspec != null) {
                args.add(refspec);
            }
        }
        this.launchCommand(args);
    }

    @Override
    public void fetch() throws GitException {
        this.fetch(null, null);
    }

    @Override
    public void clone(final RemoteConfig remoteConfig) throws GitException {
        this.listener.getLogger().println(Messages.GitAPI_Repository_CloningRepositoryMsg(remoteConfig.getName()));
        try {
            this.workspace.deleteRecursive();
        }
        catch (Exception ex) {
            ex.printStackTrace(this.listener.error(Messages.GitAPI_Workspace_FailedCleanupMsg()));
            throw new GitException(Messages.GitAPI_Workspace_FailedDeleteMsg(), ex);
        }
        final URIish source = (URIish)remoteConfig.getURIs().get(0);
        try {
            this.workspace.act((FilePath.FileCallable)new FilePath.FileCallable<String>(){
                private static final long serialVersionUID = 1L;

                public String invoke(File workspace, VirtualChannel channel) throws IOException {
                    try {
                        GitAPI.this.setDelegate(Git.cloneRepository().setDirectory(workspace.getAbsoluteFile()).setURI(source.toPrivateString()).setRemote(remoteConfig.getName()).call());
                    }
                    catch (Exception ex) {
                        throw new GitException(ex);
                    }
                    return Messages.GitAPI_Repository_CloneSuccessMsg(source.toPrivateString(), workspace.getAbsolutePath());
                }
            });
        }
        catch (Exception e) {
            throw new GitException(Messages.GitAPI_Repository_FailedCloneMsg(source), e);
        }
    }

    @Override
    public void clean() throws GitException {
        this.verifyGitRepository();
        try {
            this.jGitDelegate.clean().setCleanDirectories(true).call();
        }
        catch (Exception ex) {
            throw new GitException(ex);
        }
    }

    @Override
    public ObjectId revParse(String revName) throws GitException {
        String result = this.launchCommand("rev-parse", revName);
        return ObjectId.fromString((String)this.firstLine(result).trim());
    }

    @Override
    public String describe(String commitIsh) throws GitException {
        String result = this.launchCommand("describe", "--tags", commitIsh);
        return this.firstLine(result).trim();
    }

    @Override
    public void prune(RemoteConfig repository) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"remote", "prune", repository.getName()});
        this.launchCommand(args);
    }

    private String firstLine(String result) {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(result));
        try {
            line = reader.readLine();
            if (line == null) {
                return null;
            }
            if (reader.readLine() != null) {
                throw new GitException("Result has multiple lines");
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing result", e);
        }
        return line;
    }

    @Override
    public void changelog(String revFrom, String revTo, OutputStream outputStream) throws GitException {
        this.whatchanged(revFrom, revTo, outputStream, "--no-abbrev", "-M", "--pretty=raw");
    }

    private void whatchanged(String revFrom, String revTo, OutputStream outputStream, String ... extraargs) throws GitException {
        String revSpec = revFrom + ".." + revTo;
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{this.getGitExe(), "whatchanged"});
        args.add(extraargs);
        args.add(revSpec);
        try {
            if (this.launcher.launch().cmds(args).envs((Map)this.environment).stdout(outputStream).pwd(this.workspace).join() != 0) {
                throw new GitException("Error launching git whatchanged");
            }
        }
        catch (Exception e) {
            throw new GitException("Error performing git whatchanged", e);
        }
    }

    @Override
    public List<String> showRevision(Revision r) throws GitException {
        String revName = r.getSha1String();
        String result = "";
        if (revName != null) {
            result = this.launchCommand("show", "--no-abbrev", "--format=raw", "-M", "--raw", revName);
        }
        ArrayList<String> revShow = new ArrayList<String>();
        if (result != null) {
            revShow = new ArrayList<String>(Arrays.asList(result.split("\\n")));
        }
        return revShow;
    }

    @Override
    public void merge(String revSpec) throws GitException {
        try {
            this.launchCommand("merge", revSpec);
        }
        catch (GitException e) {
            throw new GitException("Could not merge " + revSpec, e);
        }
    }

    @Override
    public void submoduleInit() throws GitException {
        this.launchCommand("submodule", "init");
    }

    @Override
    public void submoduleSync() throws GitException {
        this.launchCommand("submodule", "sync");
    }

    @Override
    public void submoduleUpdate(boolean recursive) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"submodule", "update"});
        if (recursive) {
            args.add(new String[]{"--init", "--recursive"});
        }
        this.launchCommand(args);
    }

    @Override
    public void submoduleClean(boolean recursive) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"submodule", "foreach"});
        if (recursive) {
            args.add("--recursive");
        }
        args.add("git clean -fdx");
        this.launchCommand(args);
    }

    @Override
    public String getSubmoduleUrl(String name) throws GitException {
        String result = this.launchCommand("config", "--get", "submodule." + name + ".url");
        return this.firstLine(result).trim();
    }

    @Override
    public void setSubmoduleUrl(String name, String url) throws GitException {
        this.launchCommand("config", "submodule." + name + ".url", url);
    }

    @Override
    public String getRemoteUrl(String name) throws GitException {
        String result = this.launchCommand("config", "--get", "remote." + name + ".url");
        return this.firstLine(result).trim();
    }

    @Override
    public void setRemoteUrl(String name, String url) throws GitException {
        this.launchCommand("config", "remote." + name + ".url", url);
    }

    @Override
    public String getRemoteUrl(String name, String GIT_DIR) throws GitException {
        String result = this.launchCommand("--git-dir=" + GIT_DIR, "config", "--get", "remote." + name + ".url");
        return this.firstLine(result).trim();
    }

    @Override
    public void setRemoteUrl(String name, String url, String GIT_DIR) throws GitException {
        this.launchCommand("--git-dir=" + GIT_DIR, "config", "remote." + name + ".url", url);
    }

    @Override
    public String getDefaultRemote(String _default_) throws GitException {
        BufferedReader rdr = new BufferedReader(new StringReader(this.launchCommand("remote")));
        ArrayList<String> remotes = new ArrayList<String>();
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                remotes.add(line);
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing remotes", e);
        }
        if (remotes.contains(_default_)) {
            return _default_;
        }
        if (remotes.size() >= 1) {
            return (String)remotes.get(0);
        }
        throw new GitException("No remotes found!");
    }

    public String getDefaultRemote() throws GitException {
        return this.getDefaultRemote("origin");
    }

    @Override
    public boolean isBareRepository() throws GitException {
        return this.isBareRepository("");
    }

    @Override
    public boolean isBareRepository(String GIT_DIR) throws GitException {
        String ret;
        if ("".equals(GIT_DIR)) {
            ret = this.launchCommand("rev-parse", "--is-bare-repository");
        } else {
            String gitDir = "--git-dir=" + GIT_DIR;
            ret = this.launchCommand(gitDir, "rev-parse", "--is-bare-repository");
        }
        return !"false".equals(this.firstLine(ret).trim());
    }

    private String pathJoin(String a, String b) {
        return new File(a, b).toString();
    }

    @Override
    public void fixSubmoduleUrls(String remote, TaskListener listener) throws GitException {
        URI origin;
        boolean is_bare = true;
        try {
            String url = this.getRemoteUrl(remote);
            String gitEnd = this.pathJoin("", ".git");
            if (url.endsWith(gitEnd)) {
                url = url.substring(0, url.length() - gitEnd.length());
                is_bare = false;
            }
            origin = new URI(url);
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace(listener.error("Could not parse the URI. Exiting ..."));
            return;
        }
        catch (Exception e) {
            throw new GitException("Could determine remote.origin.url", e);
        }
        if (origin.getScheme() == null || "file".equalsIgnoreCase(origin.getScheme()) && (origin.getHost() == null || "".equals(origin.getHost()))) {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(origin.getPath());
            paths.add(this.pathJoin(origin.getPath(), ".git"));
            for (String path : paths) {
                try {
                    is_bare = this.isBareRepository(path);
                    break;
                }
                catch (GitException e) {
                    LOGGER.log(Level.FINEST, "Exception occurred while detecting repository type by path: " + path);
                }
            }
        }
        if (!is_bare) {
            try {
                List<IndexEntry> submodules = this.getSubmodules("HEAD");
                for (IndexEntry submodule : submodules) {
                    String sUrl = this.pathJoin(origin.getPath(), submodule.getFile());
                    this.setSubmoduleUrl(submodule.getFile(), sUrl);
                    String subGitDir = this.pathJoin(submodule.getFile(), ".git");
                    if (!this.hasGitRepo(subGitDir) || "".equals(this.getRemoteUrl("origin", subGitDir))) continue;
                    this.setRemoteUrl("origin", sUrl, subGitDir);
                }
            }
            catch (GitException ex) {
                listener.getLogger().println(ex.getLocalizedMessage());
                LOGGER.log(Level.FINEST, "Exception occurred while working with git repo.");
            }
        } else {
            listener.getLogger().println("The origin is non-bare.");
            LOGGER.log(Level.FINER, "The origin is non-bare.");
        }
    }

    @Override
    public void setupSubmoduleUrls(Revision rev, TaskListener listener) throws GitException {
        String remote = null;
        for (Branch br : rev.getBranches()) {
            int slash;
            String b = br.getName();
            if (b != null && (slash = b.indexOf(47)) != -1) {
                remote = this.getDefaultRemote(b.substring(0, slash));
            }
            if (remote == null) continue;
            break;
        }
        if (remote == null) {
            remote = this.getDefaultRemote();
        }
        if (remote != null) {
            this.setupSubmoduleUrls(remote, listener);
        }
    }

    @Override
    public void setupSubmoduleUrls(String remote, TaskListener listener) throws GitException {
        this.submoduleInit();
        this.submoduleSync();
        this.fixSubmoduleUrls(remote, listener);
    }

    @Override
    public void tag(String tagName, String comment) throws GitException {
        tagName = tagName.replace(' ', '_');
        try {
            this.launchCommand("tag", "-a", "-f", "-m", comment, tagName);
        }
        catch (GitException e) {
            throw new GitException("Could not apply tag " + tagName, e);
        }
    }

    public String launchCommand(ArgumentListBuilder args) throws GitException {
        return this.launchCommandIn(args, this.workspace);
    }

    public String launchCommand(String ... args) throws GitException {
        return this.launchCommand(new ArgumentListBuilder(args));
    }

    private String launchCommandIn(ArgumentListBuilder args, FilePath workDir) throws GitException {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        try {
            args.prepend(new String[]{this.getGitExe()});
            int status = this.launcher.launch().cmds(args.toCommandArray()).envs((Map)this.environment).stdout((OutputStream)fos).pwd(workDir).join();
            String result = fos.toString();
            if (status != 0) {
                throw new GitException("Command \"" + StringUtils.join((Object[])args.toCommandArray(), (String)" ") + "\" returned status code " + status + ": " + result);
            }
            return result;
        }
        catch (Exception e) {
            throw new GitException("Error performing command: " + StringUtils.join((Object[])args.toCommandArray(), (String)" ") + "\n" + e.getMessage(), e);
        }
    }

    @Override
    public void push(RemoteConfig repository, String refspec) throws GitException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"push", ((URIish)repository.getURIs().get(0)).toPrivateString()});
        if (refspec != null) {
            args.add(refspec);
        }
        this.launchCommand(args);
    }

    private List<Branch> parseBranches(String fos) throws GitException {
        ArrayList<Branch> tags = new ArrayList<Branch>();
        BufferedReader rdr = new BufferedReader(new StringReader(fos));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                if ((line = line.substring(2)).startsWith("(") || line.indexOf(" -> ") != -1) continue;
                tags.add(new Branch(line, this.revParse(line)));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing branches", e);
        }
        return tags;
    }

    @Override
    public List<Branch> getBranches() throws GitException {
        List refList;
        this.verifyGitRepository();
        try {
            refList = this.jGitDelegate.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
        }
        catch (GitAPIException ex) {
            throw new GitException(ex);
        }
        return this.parseRefList(refList);
    }

    @Override
    public List<Branch> getRemoteBranches() throws GitException, IOException {
        List refList;
        this.verifyGitRepository();
        try {
            refList = this.jGitDelegate.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
        }
        catch (GitAPIException ex) {
            throw new GitException(ex);
        }
        return this.parseRefList(refList);
    }

    @Override
    public List<Branch> getBranchesContaining(String revspec) throws GitException {
        return this.parseBranches(this.launchCommand("branch", "-a", "--contains", revspec));
    }

    @Override
    public void checkout(String commitish) throws GitException {
        this.checkoutBranch(null, commitish);
    }

    @Override
    public void checkoutBranch(String branch, String commitish) throws GitException {
        this.verifyGitRepository();
        try {
            this.launchCommand("checkout", "-f", commitish);
            if (null != branch) {
                this.jGitDelegate.checkout().setForce(true).setStartPoint(commitish).setName(branch).setCreateBranch(true).call();
            }
        }
        catch (GitAPIException e) {
            throw new GitException(Messages.GitAPI_Branch_CheckoutErrorMsg(branch, commitish), e);
        }
    }

    @Override
    public boolean tagExists(String tagName) throws GitException {
        tagName = tagName.replace(' ', '_');
        return this.launchCommand("tag", "-l", tagName).trim().equals(tagName);
    }

    @Override
    public void deleteBranch(String name) throws GitException {
        this.verifyGitRepository();
        try {
            this.jGitDelegate.branchDelete().setBranchNames(new String[]{name}).call();
        }
        catch (GitAPIException e) {
            throw new GitException(Messages.GitAPI_Branch_DeleteErrorMsg(name), e);
        }
    }

    @Override
    public void deleteTag(String tagName) throws GitException {
        tagName = tagName.replace(' ', '_');
        try {
            this.launchCommand("tag", "-d", tagName);
        }
        catch (GitException e) {
            throw new GitException("Could not delete tag " + tagName, e);
        }
    }

    @Override
    public List<IndexEntry> lsTree(String treeIsh) throws GitException {
        ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
        String result = this.launchCommand("ls-tree", treeIsh);
        BufferedReader rdr = new BufferedReader(new StringReader(result));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                String[] entry = line.split("\\s+");
                entries.add(new IndexEntry(entry[0], entry[1], entry[2], entry[3]));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing ls tree", e);
        }
        return entries;
    }

    @Override
    public List<ObjectId> revListAll() throws GitException {
        return this.revList("--all");
    }

    @Override
    public List<ObjectId> revListBranch(String branchId) throws GitException {
        return this.revList(branchId);
    }

    public List<ObjectId> revList(String ... extraArgs) throws GitException {
        ArrayList<ObjectId> entries = new ArrayList<ObjectId>();
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"rev-list"});
        args.add(extraArgs);
        String result = this.launchCommand(args);
        BufferedReader rdr = new BufferedReader(new StringReader(result));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                entries.add(ObjectId.fromString((String)line));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing rev list", e);
        }
        return entries;
    }

    @Override
    public boolean isCommitInRepo(String sha1) {
        RevWalk revWalk = new RevWalk(this.jGitDelegate.getRepository());
        try {
            revWalk.parseCommit((AnyObjectId)ObjectId.fromString((String)sha1));
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void add(String filePattern) throws GitException {
        this.verifyGitRepository();
        try {
            this.jGitDelegate.add().addFilepattern(filePattern).call();
        }
        catch (Exception ex) {
            throw new GitException(ex);
        }
    }

    @Override
    public void branch(String name) throws GitException {
        this.verifyGitRepository();
        try {
            this.jGitDelegate.branchCreate().setName(name).call();
        }
        catch (GitAPIException e) {
            throw new GitException(Messages.GitAPI_Branch_CreateErrorMsg(name), e);
        }
    }

    @Override
    public void commit(String message) throws GitException {
        this.verifyGitRepository();
        this.parseEnvVars(this.getEnvironment());
        try {
            this.jGitDelegate.commit().setMessage(message).setAuthor(this.getAuthor()).setCommitter(this.getCommitter()).call();
        }
        catch (Exception e) {
            throw new GitException(Messages.GitAPI_Commit_FailedMsg(message), e);
        }
    }

    @Override
    public void commit(File f) throws GitException {
        try {
            this.launchCommand("commit", "-F", f.getAbsolutePath());
        }
        catch (GitException e) {
            throw new GitException("Cannot commit " + f, e);
        }
    }

    @Override
    public void fetch(RemoteConfig remoteRepository) throws GitException {
        this.fetch(((URIish)remoteRepository.getURIs().get(0)).toPrivateString(), ((RefSpec)remoteRepository.getFetchRefSpecs().get(0)).toString());
    }

    @Override
    public ObjectId mergeBase(ObjectId id1, ObjectId id2) {
        try {
            String result;
            try {
                result = this.launchCommand("merge-base", id1.name(), id2.name());
            }
            catch (GitException ge) {
                ge.printStackTrace();
                return null;
            }
            BufferedReader rdr = new BufferedReader(new StringReader(result));
            String line = rdr.readLine();
            if (line != null) {
                return ObjectId.fromString((String)line);
            }
        }
        catch (Exception e) {
            throw new GitException("Error parsing merge base", e);
        }
        return null;
    }

    @Override
    public String getAllLogEntries(String branch) {
        return this.launchCommand("log", "--all", "--pretty=format:'%H#%ct'", branch);
    }

    protected Repository getRepository() throws IOException {
        this.verifyGitRepository();
        return this.jGitDelegate.getRepository();
    }

    @Override
    public List<Tag> getTagsOnCommit(String revName) throws GitException, IOException {
        Repository db = this.getRepository();
        ObjectId commit = db.resolve(revName);
        ArrayList<Tag> result = new ArrayList<Tag>();
        if (null != commit) {
            for (Map.Entry tag : db.getTags().entrySet()) {
                Ref ref = (Ref)tag.getValue();
                if (!ref.getObjectId().equals((AnyObjectId)commit)) continue;
                result.add(new Tag((String)tag.getKey(), ref.getObjectId()));
            }
        }
        return result;
    }

    @Override
    public Set<String> getTagNames(String tagPattern) throws GitException {
        try {
            String tag;
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(new String[]{"tag", "-l", tagPattern});
            String result = this.launchCommandIn(args, this.workspace);
            HashSet<String> tags = new HashSet<String>();
            BufferedReader rdr = new BufferedReader(new StringReader(result));
            while ((tag = rdr.readLine()) != null) {
                tags.add(tag);
            }
            return tags;
        }
        catch (Exception e) {
            throw new GitException("Error retrieving tag names", e);
        }
    }

    private void verifyGitRepository() {
        if (!this.hasGitRepo() || null == this.jGitDelegate) {
            throw new GitException(Messages.GitAPI_Repository_InvalidStateMsg());
        }
    }

    protected List<Branch> parseRefList(List<Ref> refList) {
        ArrayList<Branch> result = new ArrayList<Branch>();
        if (CollectionUtils.isNotEmpty(refList)) {
            for (Ref ref : refList) {
                Branch buildBranch = new Branch(ref);
                result.add(buildBranch);
                this.listener.getLogger().println(Messages.GitAPI_Branch_BranchInRepoMsg(buildBranch.getName()));
            }
        }
        return result;
    }

    protected void parseEnvVars(EnvVars envVars) {
        this.author = this.buildPersonIdent(envVars, "GIT_AUTHOR_NAME", "GIT_AUTHOR_EMAIL");
        this.committer = this.buildPersonIdent(envVars, "GIT_COMMITTER_NAME", "GIT_COMMITTER_EMAIL");
    }

    private PersonIdent buildPersonIdent(EnvVars envVars, String nameEnvKey, String emailEnvKey) {
        PersonIdent result = null;
        if (null != envVars) {
            String name = (String)envVars.get((Object)nameEnvKey);
            String email = (String)envVars.get((Object)emailEnvKey);
            if (StringUtils.isNotBlank((String)name) && StringUtils.isNotBlank((String)email)) {
                result = new PersonIdent(name, email);
            }
        }
        return result;
    }

    @Override
    public String getHeadRev(String remoteRepoUrl, String branch) throws GitException {
        String[] branchExploded = branch.split("/");
        branch = branchExploded[branchExploded.length - 1];
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"ls-remote"});
        args.add("-h");
        args.add(remoteRepoUrl);
        args.add(branch);
        String result = this.launchCommand(args);
        String[] results = result.split("\n");
        if (results.length > 0) {
            result = results[results.length - 1];
        }
        return result.length() >= 40 ? result.substring(0, 40) : "";
    }
}

