/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.EnvVars;
import hudson.tasks.Mailer;
import hudson.util.FormValidation;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailRecepientUtils {
    public static final String COMMA_SEPARATED_SPLIT_REGEXP = "[,\\s]+";

    public Set<InternetAddress> convertRecipientString(String recipientList, EnvVars envVars, boolean skipInvalid) throws AddressException {
        LinkedHashSet<InternetAddress> internetAddresses = new LinkedHashSet<InternetAddress>();
        if (StringUtils.isBlank((String)recipientList)) {
            return internetAddresses;
        }
        String expandedRecipientList = envVars.expand(recipientList);
        String[] addresses = StringUtils.trim((String)expandedRecipientList).split(COMMA_SEPARATED_SPLIT_REGEXP);
        String ds = Mailer.descriptor().getDefaultSuffix();
        for (String address : addresses) {
            if (!StringUtils.contains((String)address, (String)"@") && ds != null) {
                address = address + ds;
            }
            try {
                InternetAddress internetAddress = new InternetAddress(address);
                internetAddresses.add(internetAddress);
            }
            catch (AddressException e) {
                if (skipInvalid) continue;
                throw e;
            }
        }
        return internetAddresses;
    }

    public FormValidation validateFormRecipientList(String recipientList) {
        try {
            this.convertRecipientString(recipientList, new EnvVars(), false);
            return FormValidation.ok();
        }
        catch (AddressException e) {
            return FormValidation.error((String)(e.getMessage() + ": \"" + e.getRef() + "\""));
        }
    }
}

