/*
 * Decompiled with CFR 0.152.
 */
package de.theit.jenkins.crowd;

import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.user.User;
import de.theit.jenkins.crowd.CrowdAuthenticationToken;
import de.theit.jenkins.crowd.CrowdConfigurationService;
import de.theit.jenkins.crowd.ErrorMessages;
import hudson.security.SecurityRealm;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.authentication.RememberMeServices;

public class CrowdRememberMeServices
implements RememberMeServices {
    private static final Logger LOG = Logger.getLogger(CrowdRememberMeServices.class.getName());
    private CrowdConfigurationService configuration;

    public CrowdRememberMeServices(CrowdConfigurationService pConfiguration) {
        this.configuration = pConfiguration;
    }

    public Authentication autoLogin(HttpServletRequest request, HttpServletResponse response) {
        String ssoToken;
        CrowdAuthenticationToken result = null;
        List validationFactors = this.configuration.tokenHelper.getValidationFactorExtractor().getValidationFactors(request);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Checking whether a SSO token is available...");
        }
        if (null != (ssoToken = this.configuration.tokenHelper.getCrowdToken(request, this.configuration.clientProperties.getCookieTokenKey()))) {
            try {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("SSO token available => check whether it is still valid...");
                }
                this.configuration.crowdClient.validateSSOAuthentication(ssoToken, validationFactors);
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Retrieving SSO user...");
                }
                User user = this.configuration.crowdClient.findUserFromSSOToken(ssoToken);
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Validating group membership of user...");
                }
                if (this.configuration.isGroupMember(user.getName())) {
                    ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
                    authorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
                    authorities.addAll(this.configuration.getAuthoritiesForUser(user.getName()));
                    result = new CrowdAuthenticationToken(user.getName(), null, authorities, ssoToken, user.getDisplayName());
                }
            }
            catch (InvalidTokenException ex) {
            }
            catch (ApplicationPermissionException ex) {
                LOG.warning(ErrorMessages.applicationPermission());
            }
            catch (InvalidAuthenticationException ex) {
                LOG.warning(ErrorMessages.invalidAuthentication());
            }
            catch (OperationFailedException ex) {
                LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
            }
        }
        return result;
    }

    public void loginFail(HttpServletRequest request, HttpServletResponse response) {
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Login failed");
            }
            this.configuration.crowdHttpAuthenticator.logout(request, response);
        }
        catch (ApplicationPermissionException ex) {
            LOG.warning(ErrorMessages.applicationPermission());
        }
        catch (InvalidAuthenticationException ex) {
            LOG.warning(ErrorMessages.invalidAuthentication());
        }
        catch (OperationFailedException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
        }
    }

    public void loginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        if (!(successfulAuthentication instanceof CrowdAuthenticationToken)) {
            return;
        }
        CrowdAuthenticationToken crowdAuthenticationToken = (CrowdAuthenticationToken)successfulAuthentication;
        List validationFactors = this.configuration.tokenHelper.getValidationFactorExtractor().getValidationFactors(request);
        String ssoToken = crowdAuthenticationToken.getSSOToken();
        try {
            if (null == ssoToken) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("SSO token not yet available => authenticate user...");
                }
                this.configuration.crowdHttpAuthenticator.authenticate(request, response, crowdAuthenticationToken.getPrincipal(), crowdAuthenticationToken.getCredentials());
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Retrieve SSO token...");
                }
                ssoToken = this.configuration.tokenHelper.getCrowdToken(request, this.configuration.clientProperties.getCookieTokenKey());
            }
            if (null == ssoToken) {
                this.loginFail(request, response);
                return;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Validate the SSO authentication...");
            }
            this.configuration.crowdClient.validateSSOAuthentication(ssoToken, validationFactors);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Successfully authenticated via SSO");
            }
        }
        catch (InvalidTokenException ex) {
        }
        catch (ApplicationPermissionException ex) {
            LOG.warning(ErrorMessages.applicationPermission());
        }
        catch (InvalidAuthenticationException ex) {
            LOG.warning(ErrorMessages.invalidAuthentication());
        }
        catch (ExpiredCredentialException ex) {
            LOG.warning(ErrorMessages.expiredCredentials(crowdAuthenticationToken.getPrincipal()));
        }
        catch (InactiveAccountException ex) {
            LOG.warning(ErrorMessages.accountExpired(crowdAuthenticationToken.getPrincipal()));
        }
        catch (ApplicationAccessDeniedException ex) {
            LOG.warning(ErrorMessages.applicationAccessDenied(crowdAuthenticationToken.getPrincipal()));
        }
        catch (OperationFailedException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) {
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Logout user and close SSO session");
            }
            this.configuration.crowdHttpAuthenticator.logout(request, response);
        }
        catch (ApplicationPermissionException ex) {
            LOG.warning(ErrorMessages.applicationPermission());
        }
        catch (InvalidAuthenticationException ex) {
            LOG.warning(ErrorMessages.invalidAuthentication());
        }
        catch (OperationFailedException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
        }
    }
}

