/*
 * Decompiled with CFR 0.152.
 */
package de.theit.jenkins.crowd;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.user.User;
import de.theit.jenkins.crowd.CrowdAuthenticationToken;
import de.theit.jenkins.crowd.CrowdConfigurationService;
import de.theit.jenkins.crowd.ErrorMessages;
import hudson.security.SecurityRealm;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;

public class CrowdAuthenticationManager
implements AuthenticationManager {
    private static final Logger LOG = Logger.getLogger(CrowdAuthenticationManager.class.getName());
    private CrowdConfigurationService configuration;

    public CrowdAuthenticationManager(CrowdConfigurationService pConfiguration) {
        this.configuration = pConfiguration;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = authentication.getPrincipal().toString();
        if (null == authentication.getCredentials() && authentication instanceof CrowdAuthenticationToken && null != ((CrowdAuthenticationToken)authentication).getSSOToken()) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("User '" + username + "' already authenticated");
            }
            return authentication;
        }
        String password = authentication.getCredentials().toString();
        if (!this.configuration.isGroupMember(username)) {
            throw new InsufficientAuthenticationException(ErrorMessages.userNotValid(username, this.configuration.allowedGroupNames));
        }
        String displayName = null;
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Authenticating user: " + username);
            }
            User user = this.configuration.crowdClient.authenticateUser(username, password);
            displayName = user.getDisplayName();
        }
        catch (UserNotFoundException ex) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info(ErrorMessages.userNotFound(username));
            }
            throw new BadCredentialsException(ErrorMessages.userNotFound(username), (Throwable)ex);
        }
        catch (ExpiredCredentialException ex) {
            LOG.warning(ErrorMessages.expiredCredentials(username));
            throw new CredentialsExpiredException(ErrorMessages.expiredCredentials(username), (Throwable)ex);
        }
        catch (InactiveAccountException ex) {
            LOG.warning(ErrorMessages.accountExpired(username));
            throw new AccountExpiredException(ErrorMessages.accountExpired(username), (Throwable)ex);
        }
        catch (ApplicationPermissionException ex) {
            LOG.warning(ErrorMessages.applicationPermission());
            throw new AuthenticationServiceException(ErrorMessages.applicationPermission(), (Throwable)ex);
        }
        catch (InvalidAuthenticationException ex) {
            LOG.warning(ErrorMessages.invalidAuthentication());
            throw new AuthenticationServiceException(ErrorMessages.invalidAuthentication(), (Throwable)ex);
        }
        catch (OperationFailedException ex) {
            LOG.log(Level.SEVERE, ErrorMessages.operationFailed(), ex);
            throw new AuthenticationServiceException(ErrorMessages.operationFailed(), (Throwable)ex);
        }
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        authorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
        authorities.addAll(this.configuration.getAuthoritiesForUser(username));
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("User successfully authenticated; creating authentication token");
        }
        return new CrowdAuthenticationToken(username, password, authorities, null, displayName);
    }
}

