/*
 * Decompiled with CFR 0.152.
 */
package hudson.os.windows;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.os.windows.ManagedWindowsServiceLauncher;
import hudson.os.windows.Messages;
import hudson.slaves.ComputerConnector;
import hudson.slaves.ComputerConnectorDescriptor;
import hudson.slaves.ComputerLauncher;
import hudson.util.Secret;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class ManagedWindowsServiceConnector
extends ComputerConnector {
    public final String userName;
    public final Secret password;

    @DataBoundConstructor
    public ManagedWindowsServiceConnector(String userName, String password) {
        this.userName = userName;
        this.password = Secret.fromString((String)password);
    }

    public ManagedWindowsServiceLauncher launch(final String host, TaskListener listener) throws IOException, InterruptedException {
        return new ManagedWindowsServiceLauncher(this.userName, Secret.toString((Secret)this.password)){

            @Override
            protected String determineHost(Computer c) throws IOException, InterruptedException {
                return host;
            }

            public Descriptor<ComputerLauncher> getDescriptor() {
                return Hudson.getInstance().getDescriptor(ManagedWindowsServiceLauncher.class);
            }
        };
    }

    @Extension
    public static class DescriptorImpl
    extends ComputerConnectorDescriptor {
        public static final Class CONFIG_DELEGATE_TO = ManagedWindowsServiceLauncher.class;

        public String getDisplayName() {
            return Messages.ManagedWindowsServiceLauncher_DisplayName();
        }
    }
}

