/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.xpath.operations;

import javax.xml.transform.TransformerException;
import org.htmlunit.xpath.Expression;
import org.htmlunit.xpath.XPathContext;
import org.htmlunit.xpath.XPathVisitor;
import org.htmlunit.xpath.objects.XObject;

public class Operation
extends Expression {
    protected Expression m_left;
    protected Expression m_right;

    @Override
    public boolean canTraverseOutsideSubtree() {
        return null != this.m_left && this.m_left.canTraverseOutsideSubtree() || null != this.m_right && this.m_right.canTraverseOutsideSubtree();
    }

    public void setLeftRight(Expression l, Expression r) {
        this.m_left = l;
        this.m_right = r;
        l.exprSetParent(this);
        r.exprSetParent(this);
    }

    @Override
    public XObject execute(XPathContext xctxt) throws TransformerException {
        XObject left = this.m_left.execute(xctxt, true);
        XObject right = this.m_right.execute(xctxt, true);
        XObject result = this.operate(left, right);
        left.detach();
        right.detach();
        return result;
    }

    public XObject operate(XObject left, XObject right) throws TransformerException {
        return null;
    }

    @Override
    public void callVisitors(XPathVisitor visitor) {
        if (visitor.visitBinaryOperation()) {
            this.m_left.callVisitors(visitor);
            this.m_right.callVisitors(visitor);
        }
    }

    @Override
    public boolean deepEquals(Expression expr) {
        return this.isSameClass(expr) && this.m_left.deepEquals(((Operation)expr).m_left) && this.m_right.deepEquals(((Operation)expr).m_right);
    }
}

