/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.xpath.xml.utils;

public class NodeVector
implements Cloneable {
    private final int m_blocksize;
    private int[] m_map;
    protected int m_firstFree = 0;
    private int m_mapSize = 0;

    public NodeVector() {
        this.m_blocksize = 32;
    }

    public Object clone() throws CloneNotSupportedException {
        NodeVector clone = (NodeVector)super.clone();
        if (null != this.m_map && this.m_map == clone.m_map) {
            clone.m_map = new int[this.m_map.length];
            System.arraycopy(this.m_map, 0, clone.m_map, 0, this.m_map.length);
        }
        return clone;
    }

    public int size() {
        return this.m_firstFree;
    }

    public void addElement(int value) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            if (null == this.m_map) {
                this.m_map = new int[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                int[] newMap = new int[this.m_mapSize];
                System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
                this.m_map = newMap;
            }
        }
        this.m_map[this.m_firstFree] = value;
        ++this.m_firstFree;
    }

    public void insertElementAt(int value, int at) {
        if (null == this.m_map) {
            this.m_map = new int[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] newMap = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
            this.m_map = newMap;
        }
        if (at <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, at, this.m_map, at + 1, this.m_firstFree - at);
        }
        this.m_map[at] = value;
        ++this.m_firstFree;
    }

    public int elementAt(int i) {
        if (null == this.m_map) {
            return -1;
        }
        return this.m_map[i];
    }

    public boolean contains(int s) {
        if (null == this.m_map) {
            return false;
        }
        for (int i = 0; i < this.m_firstFree; ++i) {
            int node = this.m_map[i];
            if (node != s) continue;
            return true;
        }
        return false;
    }

    public int indexOf(int elem, int index) {
        if (null == this.m_map) {
            return -1;
        }
        for (int i = index; i < this.m_firstFree; ++i) {
            int node = this.m_map[i];
            if (node != elem) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(int elem) {
        if (null == this.m_map) {
            return -1;
        }
        for (int i = 0; i < this.m_firstFree; ++i) {
            int node = this.m_map[i];
            if (node != elem) continue;
            return i;
        }
        return -1;
    }
}

