/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.csp.value;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.htmlunit.csp.Utils;

public final class Nonce {
    private final String base64ValuePart_;

    private Nonce(String base64Valuepart) {
        this.base64ValuePart_ = base64Valuepart;
    }

    public String getBase64ValuePart() {
        return this.base64ValuePart_;
    }

    public static Optional<Nonce> parseNonce(String value) {
        String nonce;
        String lowcaseValue = value.toLowerCase(Locale.ROOT);
        if (lowcaseValue.startsWith("'nonce-") && lowcaseValue.endsWith("'") && Utils.IS_BASE64_VALUE.test(nonce = value.substring(7, value.length() - 1))) {
            return Optional.of(new Nonce(nonce));
        }
        return Optional.empty();
    }

    public String toString() {
        return "'nonce-" + this.base64ValuePart_ + "'";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Nonce nonce = (Nonce)o;
        return this.base64ValuePart_.equals(nonce.base64ValuePart_);
    }

    public int hashCode() {
        return Objects.hash(this.base64ValuePart_);
    }
}

