/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.file;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.utils.time.DateFormatter;
import org.hswebframework.web.id.IDGenerator;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.MediaType;

@ConfigurationProperties(prefix="hsweb.file.upload")
public class FileUploadProperties {
    private String staticFilePath = "./static";
    private String staticLocation = "/static";
    private boolean useOriginalFileName = false;
    private Set<String> allowFiles;
    private Set<String> denyFiles;
    private Set<String> allowMediaType;
    private Set<String> denyMediaType;
    private Set<PosixFilePermission> permissions;

    public void applyFilePermission(File file) {
        if (CollectionUtils.isEmpty(this.permissions)) {
            return;
        }
        try {
            Path path = Paths.get(file.toURI());
            PosixFileAttributeView view = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
            view.setPermissions(this.permissions);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean denied(String name, MediaType mediaType) {
        String suffix = (name.contains(".") ? name.substring(name.lastIndexOf(".") + 1) : "").toLowerCase(Locale.ROOT);
        boolean defaultDeny = false;
        if (CollectionUtils.isNotEmpty(this.denyFiles)) {
            if (this.denyFiles.contains(suffix)) {
                return true;
            }
            defaultDeny = false;
        }
        if (CollectionUtils.isNotEmpty(this.allowFiles)) {
            if (this.allowFiles.contains(suffix)) {
                return false;
            }
            defaultDeny = true;
        }
        if (CollectionUtils.isNotEmpty(this.denyMediaType)) {
            if (this.denyMediaType.contains(mediaType.toString())) {
                return true;
            }
            defaultDeny = false;
        }
        if (CollectionUtils.isNotEmpty(this.allowMediaType)) {
            if (this.allowMediaType.contains(mediaType.toString())) {
                return false;
            }
            defaultDeny = true;
        }
        return defaultDeny;
    }

    public StaticFileInfo createStaticSavePath(String name) {
        Object fileName = (String)IDGenerator.SNOW_FLAKE_STRING.generate();
        Object filePath = DateFormatter.toString((Date)new Date(), (String)"yyyyMMdd");
        String suffix = name.contains(".") ? name.substring(name.lastIndexOf(".")) : "";
        StaticFileInfo info = new StaticFileInfo();
        if (this.useOriginalFileName) {
            filePath = (String)filePath + "/" + (String)fileName;
            fileName = name;
        } else {
            fileName = (String)fileName + suffix;
        }
        String absPath = this.staticFilePath.concat("/").concat((String)filePath);
        new File(absPath).mkdirs();
        info.location = this.staticLocation + "/" + (String)filePath + "/" + (String)fileName;
        info.savePath = absPath + "/" + (String)fileName;
        info.relativeLocation = (String)filePath + "/" + (String)fileName;
        return info;
    }

    @Generated
    public String getStaticFilePath() {
        return this.staticFilePath;
    }

    @Generated
    public String getStaticLocation() {
        return this.staticLocation;
    }

    @Generated
    public boolean isUseOriginalFileName() {
        return this.useOriginalFileName;
    }

    @Generated
    public Set<String> getAllowFiles() {
        return this.allowFiles;
    }

    @Generated
    public Set<String> getDenyFiles() {
        return this.denyFiles;
    }

    @Generated
    public Set<String> getAllowMediaType() {
        return this.allowMediaType;
    }

    @Generated
    public Set<String> getDenyMediaType() {
        return this.denyMediaType;
    }

    @Generated
    public Set<PosixFilePermission> getPermissions() {
        return this.permissions;
    }

    @Generated
    public void setStaticFilePath(String staticFilePath) {
        this.staticFilePath = staticFilePath;
    }

    @Generated
    public void setStaticLocation(String staticLocation) {
        this.staticLocation = staticLocation;
    }

    @Generated
    public void setUseOriginalFileName(boolean useOriginalFileName) {
        this.useOriginalFileName = useOriginalFileName;
    }

    @Generated
    public void setAllowFiles(Set<String> allowFiles) {
        this.allowFiles = allowFiles;
    }

    @Generated
    public void setDenyFiles(Set<String> denyFiles) {
        this.denyFiles = denyFiles;
    }

    @Generated
    public void setAllowMediaType(Set<String> allowMediaType) {
        this.allowMediaType = allowMediaType;
    }

    @Generated
    public void setDenyMediaType(Set<String> denyMediaType) {
        this.denyMediaType = denyMediaType;
    }

    @Generated
    public void setPermissions(Set<PosixFilePermission> permissions) {
        this.permissions = permissions;
    }

    public static class StaticFileInfo {
        private String savePath;
        private String relativeLocation;
        private String location;

        @Generated
        public String getSavePath() {
            return this.savePath;
        }

        @Generated
        public String getRelativeLocation() {
            return this.relativeLocation;
        }

        @Generated
        public String getLocation() {
            return this.location;
        }

        @Generated
        public void setSavePath(String savePath) {
            this.savePath = savePath;
        }

        @Generated
        public void setRelativeLocation(String relativeLocation) {
            this.relativeLocation = relativeLocation;
        }

        @Generated
        public void setLocation(String location) {
            this.location = location;
        }
    }
}

