/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.hswebframework.web.api.crud.entity.EntityFactory;
import org.reactivestreams.Publisher;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CustomMappingJackson2HttpMessageConverter
extends MappingJackson2HttpMessageConverter {
    private final EntityFactory entityFactory;

    public CustomMappingJackson2HttpMessageConverter(ObjectMapper objectMapper, EntityFactory entityFactory) {
        super(objectMapper);
        this.entityFactory = entityFactory;
        this.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON, MediaType.APPLICATION_NDJSON, new MediaType("application", "*+json")));
    }

    public Object doRead(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        Class newType;
        if (type instanceof Class && null != (newType = this.entityFactory.getInstanceType((Class)type, false))) {
            type = newType;
        }
        return super.read(type, contextClass, inputMessage);
    }

    @Nonnull
    public Object read(@Nonnull Type type, Class<?> contextClass, @Nonnull HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        ResolvableType resolvableType;
        Class clazz;
        if (type instanceof ParameterizedType && Publisher.class.isAssignableFrom(clazz = (resolvableType = ResolvableType.forType((Type)GenericTypeResolver.resolveType((Type)type, contextClass))).toClass())) {
            Type _gen = resolvableType.getGeneric(new int[]{0}).getType();
            if (Flux.class.isAssignableFrom(clazz)) {
                Object rel = this.doRead(ResolvableType.forClassWithGenerics(List.class, (ResolvableType[])new ResolvableType[]{resolvableType.getGeneric(new int[]{0})}).getType(), contextClass, inputMessage);
                if (rel instanceof Iterable) {
                    return Flux.fromIterable((Iterable)((Iterable)rel));
                }
                return Flux.just((Object)rel);
            }
            return Mono.just((Object)this.doRead(_gen, contextClass, inputMessage));
        }
        return this.doRead(type, contextClass, inputMessage);
    }
}

