/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter.jackson;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import java.io.IOException;
import lombok.Generated;
import org.hswebframework.web.api.crud.entity.EntityFactory;
import org.hswebframework.web.dict.EnumDict;

public class CustomDeserializers
extends SimpleDeserializers {
    private final EntityFactory entityFactory;

    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        JsonDeserializer deserializer = super.findBeanDeserializer(type, config, beanDesc);
        if (deserializer == null) {
            final Class clazz = this.entityFactory.getInstanceType(type.getRawClass(), false);
            if (clazz == null || clazz == type.getRawClass()) {
                return null;
            }
            this.addDeserializer(type.getRawClass(), (JsonDeserializer)new JsonDeserializer<Object>(){

                public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
                    return p.readValueAs(clazz);
                }
            });
        }
        return super.findBeanDeserializer(type, config, beanDesc);
    }

    public JsonDeserializer<?> findEnumDeserializer(Class<?> type, DeserializationConfig config, BeanDescription beanDesc) {
        EnumDict.EnumDictJSONDeserializer deser = null;
        if (type.isEnum() && EnumDict.class.isAssignableFrom(type)) {
            deser = new EnumDict.EnumDictJSONDeserializer(val -> EnumDict.find((Class)type, (Object)val).orElse(null));
        }
        return deser;
    }

    @Generated
    public CustomDeserializers(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }
}

