/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.HttpMethod;
import org.springframework.web.reactive.config.CorsRegistration;

@ConfigurationProperties(prefix="hsweb.cors")
public class CorsProperties {
    private List<CorsConfiguration> configs;

    @Generated
    public List<CorsConfiguration> getConfigs() {
        return this.configs;
    }

    @Generated
    public void setConfigs(List<CorsConfiguration> configs) {
        this.configs = configs;
    }

    public static class CorsConfiguration {
        public static final String ALL = "*";
        private String path = "/**";
        private List<String> allowedOrigins;
        private List<String> allowedMethods;
        private List<String> allowedHeaders;
        private List<String> exposedHeaders;
        private Boolean allowCredentials;
        private Long maxAge = 1800L;

        public void apply(CorsRegistration registry) {
            if (CollectionUtils.isNotEmpty(this.allowedHeaders)) {
                registry.allowedHeaders(this.getAllowedHeaders().toArray(new String[0]));
            }
            if (CollectionUtils.isNotEmpty(this.allowedMethods)) {
                registry.allowedMethods(this.getAllowedMethods().toArray(new String[0]));
            }
            if (CollectionUtils.isNotEmpty(this.allowedOrigins)) {
                registry.allowedOrigins(this.getAllowedOrigins().toArray(new String[0]));
            }
            if (CollectionUtils.isNotEmpty(this.exposedHeaders)) {
                registry.exposedHeaders(this.getExposedHeaders().toArray(new String[0]));
            }
            if (this.maxAge == null) {
                registry.maxAge(this.getMaxAge().longValue());
            }
            registry.allowCredentials(this.getAllowCredentials() == null || Boolean.TRUE.equals(this.getAllowCredentials()));
        }

        CorsConfiguration applyPermitDefaultValues() {
            if (this.allowedOrigins == null) {
                this.addAllowedOrigin();
            }
            if (this.allowedMethods == null) {
                this.setAllowedMethods(Arrays.asList(HttpMethod.GET.name(), HttpMethod.HEAD.name(), HttpMethod.POST.name()));
            }
            if (this.allowedHeaders == null) {
                this.addAllowedHeader();
            }
            if (this.allowCredentials == null) {
                this.setAllowCredentials(true);
            }
            if (this.maxAge == null) {
                this.setMaxAge(1800L);
            }
            return this;
        }

        void addAllowedOrigin() {
            if (this.allowedOrigins == null) {
                this.allowedOrigins = new ArrayList<String>(4);
            }
            this.allowedOrigins.add(ALL);
        }

        void addAllowedHeader() {
            if (this.allowedHeaders == null) {
                this.allowedHeaders = new ArrayList<String>(4);
            }
            this.allowedHeaders.add(ALL);
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public List<String> getAllowedOrigins() {
            return this.allowedOrigins;
        }

        @Generated
        public List<String> getAllowedMethods() {
            return this.allowedMethods;
        }

        @Generated
        public List<String> getAllowedHeaders() {
            return this.allowedHeaders;
        }

        @Generated
        public List<String> getExposedHeaders() {
            return this.exposedHeaders;
        }

        @Generated
        public Boolean getAllowCredentials() {
            return this.allowCredentials;
        }

        @Generated
        public Long getMaxAge() {
            return this.maxAge;
        }

        @Generated
        public void setPath(String path) {
            this.path = path;
        }

        @Generated
        public void setAllowedOrigins(List<String> allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
        }

        @Generated
        public void setAllowedMethods(List<String> allowedMethods) {
            this.allowedMethods = allowedMethods;
        }

        @Generated
        public void setAllowedHeaders(List<String> allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
        }

        @Generated
        public void setExposedHeaders(List<String> exposedHeaders) {
            this.exposedHeaders = exposedHeaders;
        }

        @Generated
        public void setAllowCredentials(Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
        }

        @Generated
        public void setMaxAge(Long maxAge) {
            this.maxAge = maxAge;
        }

        @Generated
        public String toString() {
            return "CorsProperties.CorsConfiguration(path=" + this.getPath() + ", allowedOrigins=" + this.getAllowedOrigins() + ", allowedMethods=" + this.getAllowedMethods() + ", allowedHeaders=" + this.getAllowedHeaders() + ", exposedHeaders=" + this.getExposedHeaders() + ", allowCredentials=" + this.getAllowCredentials() + ", maxAge=" + this.getMaxAge() + ")";
        }
    }
}

