/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.sql.Blob;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.Type;

public final class BlobType
extends BinaryType {
    public static final long maxBlobPrecision = 0x10000000000L;
    public static final int defaultBlobSize = 0x1000000;

    public BlobType(long l) {
        super(30, l);
    }

    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    public int getJDBCTypeCode() {
        return 2004;
    }

    public Class getJDBCClass() {
        return Blob.class;
    }

    public String getJDBCClassName() {
        return "java.sql.Blob";
    }

    public String getNameString() {
        return "BLOB";
    }

    public String getFullNameString() {
        return "BINARY LARGE OBJECT";
    }

    public String getDefinition() {
        long l = this.precision;
        String string = null;
        if (this.precision % 0x40000000L == 0L) {
            l = this.precision / 0x40000000L;
            string = "G";
        } else if (this.precision % 0x100000L == 0L) {
            l = this.precision / 0x100000L;
            string = "M";
        } else if (this.precision % 1024L == 0L) {
            l = this.precision / 1024L;
            string = "K";
        }
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(this.getNameString());
        stringBuffer.append('(');
        stringBuffer.append(l);
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean acceptsPrecision() {
        return true;
    }

    public boolean requiresPrecision() {
        return false;
    }

    public long getMaxPrecision() {
        return 0x10000000000L;
    }

    public boolean isBinaryType() {
        return true;
    }

    public boolean isLobType() {
        return true;
    }

    public int compare(Session session, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object2 instanceof BinaryData) {
            return session.database.lobManager.compare((BlobData)object, ((BlobData)object2).getBytes());
        }
        return session.database.lobManager.compare((BlobData)object, (BlobData)object2);
    }

    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        return object;
    }

    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return null;
        }
        if (type.typeCode == 30) {
            return object;
        }
        if (type.typeCode == 60 || type.typeCode == 61) {
            BlobData blobData = (BlobData)object;
            BlobDataID blobDataID = sessionInterface.createBlob(blobData.length(sessionInterface));
            blobDataID.setBytes(sessionInterface, 0L, blobData.getBytes());
            return blobDataID;
        }
        throw Error.error(5561);
    }

    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return object;
        }
        if (object instanceof byte[]) {
            return new BinaryData((byte[])object, false);
        }
        throw Error.error(5561);
    }

    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        byte[] byArray = ((BlobData)object).getBytes();
        return StringConverter.byteArrayToHexString(byArray);
    }

    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        byte[] byArray = ((BlobData)object).getBytes();
        return StringConverter.byteArrayToSQLHexString(byArray);
    }

    public Object convertJavaToSQL(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof JDBCBlobClient) {
            return ((JDBCBlobClient)object).getBlob();
        }
        throw Error.error(5561);
    }

    public Object convertSQLToJava(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BlobDataID) {
            BlobDataID blobDataID = (BlobDataID)object;
            return new JDBCBlobClient(sessionInterface, blobDataID);
        }
        throw Error.error(5561);
    }
}

