/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.hsqldb.store.BitMap;

public final class ServerAcl {
    protected static final byte[] ALL_SET_4BYTES = new byte[]{-1, -1, -1, -1};
    protected static final byte[] ALL_SET_16BYTES = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private PrintWriter pw = null;
    private List aclEntries;
    private static AclEntry PROHIBIT_ALL_IPV4;
    private static AclEntry PROHIBIT_ALL_IPV6;
    private File aclFile;
    private long lastLoadTime = 0L;

    public static String dottedNotation(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(byArray[i] & 0xFF);
        }
        return stringBuffer.toString();
    }

    public static String colonNotation(byte[] byArray) {
        if (byArray.length / 2 * 2 != byArray.length) {
            throw new RuntimeException("At this time .colonNotation only handles even byte quantities");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; i += 2) {
            if (i > 0) {
                stringBuffer.append(':');
            }
            stringBuffer.append(Integer.toHexString((byArray[i] & 0xFF) * 256 + (byArray[i + 1] & 0xFF)));
        }
        return stringBuffer.toString();
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.pw = printWriter;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.aclEntries.size(); ++i) {
            if (i > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append("Entry " + (i + 1) + ": " + this.aclEntries.get(i));
        }
        return stringBuffer.toString();
    }

    public boolean permitAccess(String string) {
        try {
            return this.permitAccess(InetAddress.getByName(string).getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            this.println("'" + string + "' denied because failed to resolve to an addr");
            return false;
        }
    }

    public boolean permitAccess(byte[] byArray) {
        this.ensureAclsUptodate();
        for (int i = 0; i < this.aclEntries.size(); ++i) {
            if (!((AclEntry)this.aclEntries.get(i)).matches(byArray)) continue;
            AclEntry aclEntry = (AclEntry)this.aclEntries.get(i);
            this.println("Addr '" + ServerAcl.dottedNotation(byArray) + "' matched rule #" + (i + 1) + ":  " + aclEntry);
            return aclEntry.allow;
        }
        throw new RuntimeException("No rule matches address '" + ServerAcl.dottedNotation(byArray) + "'");
    }

    private void println(String string) {
        if (this.pw == null) {
            return;
        }
        this.pw.println(string);
        this.pw.flush();
    }

    public ServerAcl(File file) throws IOException, AclFormatException {
        this.aclFile = file;
        this.aclEntries = this.load();
    }

    protected synchronized void ensureAclsUptodate() {
        if (this.lastLoadTime > this.aclFile.lastModified()) {
            return;
        }
        try {
            this.aclEntries = this.load();
            this.println("ACLs reloaded from file");
            return;
        }
        catch (Exception exception) {
            this.println("Failed to reload ACL file.  Retaining old ACLs.  " + exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List load() throws IOException, AclFormatException {
        if (!this.aclFile.exists()) {
            throw new IOException("File '" + this.aclFile.getAbsolutePath() + "' is not present");
        }
        if (!this.aclFile.isFile()) {
            throw new IOException("'" + this.aclFile.getAbsolutePath() + "' is not a regular file");
        }
        if (!this.aclFile.canRead()) {
            throw new IOException("'" + this.aclFile.getAbsolutePath() + "' is not accessible");
        }
        String string = null;
        int n = 0;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.aclFile));
        ArrayList<AclEntry> arrayList = new ArrayList<AclEntry>();
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                boolean bl;
                int n2;
                byte[] byArray;
                block19: {
                    ++n;
                    if ((string2 = string2.trim()).length() < 1 || string2.charAt(0) == '#') continue;
                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                    try {
                        if (stringTokenizer.countTokens() != 2) {
                            throw new InternalException();
                        }
                        String string3 = stringTokenizer.nextToken();
                        String string4 = stringTokenizer.nextToken();
                        int n3 = string4.indexOf(47);
                        if (n3 > -1) {
                            string = string4.substring(n3 + 1);
                            string4 = string4.substring(0, n3);
                        }
                        byArray = InetAddress.getByName(string4).getAddress();
                        int n4 = n2 = string == null ? byArray.length * 8 : Integer.parseInt(string);
                        if (string3.equalsIgnoreCase("allow")) {
                            bl = true;
                            break block19;
                        }
                        if (string3.equalsIgnoreCase("permit")) {
                            bl = true;
                            break block19;
                        }
                        if (string3.equalsIgnoreCase("accept")) {
                            bl = true;
                            break block19;
                        }
                        if (string3.equalsIgnoreCase("prohibit")) {
                            bl = false;
                            break block19;
                        }
                        if (string3.equalsIgnoreCase("deny")) {
                            bl = false;
                            break block19;
                        }
                        if (string3.equalsIgnoreCase("reject")) {
                            bl = false;
                            break block19;
                        }
                        throw new InternalException();
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new AclFormatException("Syntax error at ACL file '" + this.aclFile.getAbsolutePath() + "', line " + n);
                    }
                    catch (InternalException internalException) {
                        throw new AclFormatException("Syntax error at ACL file '" + this.aclFile.getAbsolutePath() + "', line " + n);
                    }
                }
                try {
                    arrayList.add(new AclEntry(byArray, n2, bl));
                }
                catch (AclFormatException aclFormatException) {
                    throw new AclFormatException("Syntax error at ACL file '" + this.aclFile.getAbsolutePath() + "', line " + n + ": " + aclFormatException.toString());
                }
            }
            Object var15_16 = null;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        arrayList.add(PROHIBIT_ALL_IPV4);
        arrayList.add(PROHIBIT_ALL_IPV6);
        this.lastLoadTime = new Date().getTime();
        return arrayList;
    }

    public static void main(String[] stringArray) throws AclFormatException, IOException {
        String string;
        if (stringArray.length > 1) {
            throw new RuntimeException("Try: java -cp path/to/hsqldb.jar " + ServerAcl.class.getName() + " --help");
        }
        if (stringArray.length > 0 && stringArray[0].equals("--help")) {
            System.err.println("SYNTAX: java -cp path/to/hsqldb.jar " + ServerAcl.class.getName() + " [filepath.txt]");
            System.err.println("ACL file path defaults to 'acl.txt' in the current directory.");
            System.exit(0);
        }
        ServerAcl serverAcl = new ServerAcl(new File(stringArray.length == 0 ? "acl.txt" : stringArray[0]));
        serverAcl.setPrintWriter(new PrintWriter(System.out));
        System.out.println(serverAcl.toString());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Enter hostnames or IP addresses to be tested (one per line).");
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() < 1) continue;
            System.out.println(Boolean.toString(serverAcl.permitAccess(string)));
        }
    }

    static {
        try {
            PROHIBIT_ALL_IPV4 = new AclEntry(InetAddress.getByName("0.0.0.0").getAddress(), 0, false);
            PROHIBIT_ALL_IPV6 = new AclEntry(InetAddress.getByName("::").getAddress(), 0, false);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("Unexpected problem in static initializer", unknownHostException);
        }
        catch (AclFormatException aclFormatException) {
            throw new RuntimeException("Unexpected problem in static initializer", aclFormatException);
        }
    }

    private static final class InternalException
    extends Exception {
        private InternalException() {
        }
    }

    private static final class AclEntry {
        private byte[] value;
        private byte[] mask;
        private int bitBlockSize;
        public boolean allow;

        public AclEntry(byte[] byArray, int n, boolean bl) throws AclFormatException {
            byte[] byArray2 = null;
            switch (byArray.length) {
                case 4: {
                    byArray2 = ALL_SET_4BYTES;
                    break;
                }
                case 16: {
                    byArray2 = ALL_SET_16BYTES;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Only 4 and 16 bytes supported, not " + byArray.length);
                }
            }
            if (n > byArray.length * 8) {
                throw new IllegalArgumentException("Specified " + n + " significant bits, but value only has " + byArray.length * 8 + " bits");
            }
            this.bitBlockSize = n;
            this.value = byArray;
            this.mask = BitMap.leftShift(byArray2, byArray.length * 8 - n);
            if (this.mask.length != byArray.length) {
                throw new RuntimeException("Basic program assertion failed.  Generated mask length " + this.mask.length + " (bytes) does not match given value length " + byArray.length + " (bytes).");
            }
            this.allow = bl;
            this.validateMask();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("Addrs ");
            stringBuffer.append(this.value.length == 16 ? "[" + ServerAcl.colonNotation(this.value) + ']' : ServerAcl.dottedNotation(this.value));
            stringBuffer.append("/" + this.bitBlockSize + ' ' + (this.allow ? "ALLOW" : "DENY"));
            return stringBuffer.toString();
        }

        public boolean matches(byte[] byArray) {
            if (this.value.length != byArray.length) {
                return false;
            }
            return !BitMap.hasAnyBitSet(BitMap.xor(this.value, BitMap.and(byArray, this.mask)));
        }

        public void validateMask() throws AclFormatException {
            if (BitMap.hasAnyBitSet(BitMap.and(this.value, BitMap.not(this.mask)))) {
                throw new AclFormatException("The base address '" + ServerAcl.dottedNotation(this.value) + "' is too specific for block-size-spec /" + this.bitBlockSize);
            }
        }
    }

    public static final class AclFormatException
    extends Exception {
        public AclFormatException(String string) {
            super(string);
        }
    }
}

