/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import org.hsqldb.Row;
import org.hsqldb.persist.Crypto;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.Type;

public class RowOutputBinaryEncode
extends RowOutputBinary {
    final Crypto crypto;

    public RowOutputBinaryEncode(Crypto crypto, int n, int n2) {
        super(n, n2);
        this.crypto = crypto;
    }

    public void writeData(Row row, Type[] typeArray) {
        if (this.crypto == null) {
            super.writeData(row, typeArray);
        } else {
            int n = this.count;
            this.ensureRoom(row.getStorageSize());
            this.writeInt(0);
            super.writeData(row, typeArray);
            int n2 = this.count - n - 4;
            int n3 = this.crypto.encode(this.buffer, n + 4, n2, this.buffer, n + 4);
            this.writeIntData(n3, n);
            this.count = n + 4 + n3;
        }
    }

    public int getSize(Row row) {
        int n = super.getSize(row);
        if (this.crypto != null) {
            n = this.crypto.getEncodedSize(n - 4) + 8;
        }
        return n;
    }

    public RowOutputInterface duplicate() {
        return new RowOutputBinaryEncode(this.crypto, 128, this.scale);
    }
}

