/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.hsqldb.Database;
import org.hsqldb.persist.RandomAccessInterface;

final class ScaledRAFileSimple
implements RandomAccessInterface {
    final RandomAccessFile file;
    final boolean readOnly;

    ScaledRAFileSimple(String string, String string2) throws FileNotFoundException, IOException {
        this.file = new RandomAccessFile(string, string2);
        this.readOnly = string2.equals("r");
    }

    public long length() throws IOException {
        return this.file.length();
    }

    public void seek(long l) throws IOException {
        this.file.seek(l);
    }

    public long getFilePointer() throws IOException {
        return this.file.getFilePointer();
    }

    public int read() throws IOException {
        return this.file.read();
    }

    public long readLong() throws IOException {
        return this.file.readLong();
    }

    public int readInt() throws IOException {
        return this.file.readInt();
    }

    public void read(byte[] byArray, int n, int n2) throws IOException {
        this.file.readFully(byArray, n, n2);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.file.write(byArray, n, n2);
    }

    public void writeInt(int n) throws IOException {
        this.file.writeInt(n);
    }

    public void writeLong(long l) throws IOException {
        this.file.writeLong(l);
    }

    public void close() throws IOException {
        this.file.close();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean wasNio() {
        return false;
    }

    public boolean ensureLength(long l) {
        return true;
    }

    public boolean setLength(long l) {
        try {
            this.file.setLength(l);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public Database getDatabase() {
        return null;
    }

    public void synch() {
        try {
            this.file.getFD().sync();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

