/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarMalformatException;

public class TarFileInputStream {
    protected long bytesRead = 0L;
    private InputStream readStream;
    protected byte[] readBuffer;
    protected int readBufferBlocks;
    protected int compressionType;

    public TarFileInputStream(File file) throws IOException {
        this(file, 0);
    }

    public TarFileInputStream(File file, int n) throws IOException {
        this(file, n, 20);
    }

    public int getReadBufferBlocks() {
        return this.readBufferBlocks;
    }

    public TarFileInputStream(File file, int n, int n2) throws IOException {
        if (!file.isFile()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IOException(RB.read_denied.getString(file.getAbsolutePath()));
        }
        this.readBufferBlocks = n2;
        this.compressionType = n;
        this.readBuffer = new byte[n2 * 512];
        switch (n) {
            case 0: {
                this.readStream = new FileInputStream(file);
                break;
            }
            case 1: {
                this.readStream = new GZIPInputStream((InputStream)new FileInputStream(file), this.readBuffer.length);
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.compression_unknown.getString(n));
            }
        }
    }

    public void readBlocks(int n) throws IOException, TarMalformatException {
        if (this.compressionType != 0) {
            this.readCompressedBlocks(n);
            return;
        }
        int n2 = this.readStream.read(this.readBuffer, 0, n * 512);
        this.bytesRead += (long)n2;
        if (n2 != n * 512) {
            throw new TarMalformatException(RB.insufficient_read.getString(n * 512, n2));
        }
    }

    protected void readCompressedBlocks(int n) throws IOException {
        int n2;
        int n3 = 512 * n;
        for (int i = 0; i < n3; i += n2) {
            n2 = this.readStream.read(this.readBuffer, i, n3 - i);
            if (n2 < 0) {
                throw new EOFException(RB.decompression_ranout.getString(i, n3));
            }
            this.bytesRead += (long)n2;
        }
    }

    public void readBlock() throws IOException, TarMalformatException {
        this.readBlocks(1);
    }

    public boolean readNextHeaderBlock() throws IOException, TarMalformatException {
        try {
            while (this.readStream.available() > 0) {
                this.readBlock();
                if (this.readBuffer[0] == 0) continue;
                return true;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        this.close();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.readStream == null) {
            return;
        }
        try {
            this.readStream.close();
            Object var2_1 = null;
            this.readStream = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.readStream = null;
            throw throwable;
        }
    }
}

