/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;

public class TransactionManager2PL
extends TransactionManagerCommon
implements TransactionManager {
    public TransactionManager2PL(Database database) {
        this.database = database;
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.txModel = 0;
    }

    public long getGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.get();
    }

    public boolean isMVRows() {
        return false;
    }

    public boolean isMVCC() {
        return false;
    }

    public int getTransactionControl() {
        return 0;
    }

    public void setTransactionControl(Session session, int n) {
        super.setTransactionControl(session, n);
    }

    public void completeActions(Session session) {
        this.endActionTPL(session);
    }

    public boolean prepareCommitActions(Session session) {
        session.actionTimestamp = this.nextChangeTimestamp();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        int n = session.rowActionList.size();
        Object[] objectArray = session.rowActionList.getArray();
        this.writeLock.lock();
        try {
            session.transactionEndTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
            this.endTransaction(session);
            for (int i = 0; i < n; ++i) {
                RowAction rowAction = (RowAction)objectArray[i];
                rowAction.commit(session);
            }
            this.persistCommit(session, objectArray, n);
            this.endTransactionTPL(session);
            Object var7_6 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        session.tempSet.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Session session) {
        session.abortTransaction = false;
        session.transactionEndTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
        this.rollbackPartial(session, 0, session.transactionTimestamp);
        this.endTransaction(session);
        this.writeLock.lock();
        try {
            this.endTransactionTPL(session);
            Object var3_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public void rollbackSavepoint(Session session, int n) {
        long l = session.sessionContext.savepointTimestamps.get(n);
        Integer n2 = (Integer)session.sessionContext.savepoints.get(n);
        int n3 = n2;
        while (session.sessionContext.savepoints.size() > n + 1) {
            session.sessionContext.savepoints.remove(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, n3, l);
    }

    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionTimestamp);
        this.endActionTPL(session);
    }

    void rollbackPartial(Session session, int n, long l) {
        Object[] objectArray = session.rowActionList.getArray();
        int n2 = session.rowActionList.size();
        if (n == n2) {
            return;
        }
        for (int i = n2 - 1; i >= n; --i) {
            RowAction rowAction = (RowAction)objectArray[i];
            if (rowAction == null || rowAction.type == 0 || rowAction.type == 3) continue;
            Row row = rowAction.memoryRow;
            if (row == null) {
                row = (Row)rowAction.store.get(rowAction.getPos(), false);
            }
            if (row == null) continue;
            rowAction.rollback(session, l);
            int n3 = rowAction.mergeRollback(session, l, row);
            rowAction.store.rollbackRow(session, row, n3, this.txModel);
        }
        session.rowActionList.setSize(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowAction addDeleteAction(Session session, Table table, Row row, int[] nArray) {
        RowAction rowAction;
        Object object = row;
        synchronized (object) {
            rowAction = RowAction.addDeleteAction(session, table, row, nArray);
        }
        session.rowActionList.add(rowAction);
        object = table.getRowStore(session);
        object.delete(session, row);
        row.rowAction = null;
        return rowAction;
    }

    public void addInsertAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction = row.rowAction;
        if (rowAction == null) {
            System.out.println("null insert action " + session + " " + session.actionTimestamp);
        }
        persistentStore.indexRow(session, row);
        session.rowActionList.add(rowAction);
        row.rowAction = null;
    }

    public boolean canRead(Session session, Row row, int n, int[] nArray) {
        return true;
    }

    public boolean canRead(Session session, int n, int n2) {
        return true;
    }

    public void setTransactionInfo(CachedObject cachedObject) {
    }

    public void removeTransactionInfo(CachedObject cachedObject) {
    }

    public void beginTransaction(Session session) {
        if (!session.isTransaction) {
            session.transactionTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
            session.isTransaction = true;
            ++this.transactionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginAction(Session session, Statement statement) {
        if (session.hasLocks(statement)) {
            return;
        }
        this.writeLock.lock();
        try {
            boolean bl;
            if (statement.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
                session.sessionContext.currentStatement = statement = session.statementManager.getStatement(session, statement);
                if (statement == null) {
                    Object var5_3 = null;
                    this.writeLock.unlock();
                    return;
                }
            }
            if (bl = this.setWaitedSessionsTPL(session, statement)) {
                if (session.tempSet.isEmpty()) {
                    this.lockTablesTPL(session, statement);
                } else {
                    this.setWaitingSessionTPL(session);
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        Object var5_4 = null;
        this.writeLock.unlock();
    }

    public void beginActionResume(Session session) {
        session.actionTimestamp = this.nextChangeTimestamp();
        if (!session.isTransaction) {
            session.transactionTimestamp = session.actionTimestamp;
            session.isTransaction = true;
            ++this.transactionCount;
        }
    }

    void endTransaction(Session session) {
        if (session.isTransaction) {
            session.isTransaction = false;
            --this.transactionCount;
        }
    }

    public DoubleIntIndex getTransactionIDList() {
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(10, false);
        return doubleIntIndex;
    }

    public void convertTransactionIDs(DoubleIntIndex doubleIntIndex) {
    }
}

