/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;

public class TableWorks {
    OrderedHashSet emptySet = new OrderedHashSet();
    private Database database;
    private Table table;
    private Session session;

    public TableWorks(Session session, Table table) {
        this.database = table.database;
        this.table = table;
        this.session = session;
    }

    public Table getTable() {
        return this.table;
    }

    void checkCreateForeignKey(Constraint constraint) {
        Object object;
        Object object2;
        int n;
        boolean bl;
        boolean bl2 = bl = constraint.core.updateAction == 4 || constraint.core.updateAction == 2 || constraint.core.updateAction == 0 || constraint.core.deleteAction == 4 || constraint.core.deleteAction == 2;
        if (bl) {
            for (n = 0; n < constraint.core.refCols.length; ++n) {
                object2 = this.table.getColumn(constraint.core.refCols[n]);
                if (!((ColumnSchema)object2).isGenerated()) continue;
                throw Error.error(5524, ((ColumnSchema)object2).getNameString());
            }
        }
        if (constraint.core.mainName == this.table.getName() && ArrayUtil.haveCommonElement(constraint.core.refCols, constraint.core.mainCols)) {
            throw Error.error(5527);
        }
        boolean bl3 = bl = constraint.core.updateAction == 4 || constraint.core.deleteAction == 4;
        if (bl) {
            for (n = 0; n < constraint.core.refCols.length; ++n) {
                object2 = this.table.getColumn(constraint.core.refCols[n]);
                object = ((ColumnSchema)object2).getDefaultExpression();
                if (object != null) continue;
                String string = ((ColumnSchema)object2).getName().statementName;
                throw Error.error(5521, string);
            }
        }
        boolean bl4 = bl = constraint.core.updateAction == 2 || constraint.core.deleteAction == 2;
        if (bl && !this.session.isProcessingScript) {
            for (n = 0; n < constraint.core.refCols.length; ++n) {
                object2 = this.table.getColumn(constraint.core.refCols[n]);
                if (((ColumnSchema)object2).isNullable()) continue;
                object = ((ColumnSchema)object2).getName().statementName;
                throw Error.error(5520, (String)object);
            }
        }
        this.database.schemaManager.checkSchemaObjectNotExists(constraint.getName());
        if (this.table.getConstraint(constraint.getName().name) != null) {
            throw Error.error(5504, constraint.getName().statementName);
        }
        if (this.table.getFKConstraintForColumns(constraint.core.mainTable, constraint.core.mainCols, constraint.core.refCols) != null) {
            throw Error.error(5528, constraint.getName().statementName);
        }
        if (constraint.core.mainTable.isTemp() != this.table.isTemp()) {
            throw Error.error(5524, constraint.getName().statementName);
        }
        Constraint constraint2 = constraint.core.mainTable.getUniqueConstraintForColumns(constraint.core.mainCols);
        if (constraint2 == null) {
            throw Error.error(5529, constraint.getMain().getName().statementName);
        }
        constraint.core.mainTable.checkColumnsMatch(constraint.core.mainCols, this.table, constraint.core.refCols);
        ArrayUtil.reorderMaps(constraint2.getMainColumns(), constraint.getMainColumns(), constraint.getRefColumns());
        object2 = constraint.core.mainTable.getColumnCheckList(constraint.core.mainCols);
        object = this.session.getGrantee();
        ((Grantee)object).checkReferences(constraint.core.mainTable, (boolean[])object2);
    }

    void addForeignKey(Constraint constraint) {
        this.checkModifyTable();
        this.checkCreateForeignKey(constraint);
        Constraint constraint2 = constraint.core.mainTable.getUniqueConstraintForColumns(constraint.core.mainCols);
        Index index = constraint2.getMainIndex();
        constraint2.checkReferencedRows(this.session, this.table);
        boolean bl = false;
        if (constraint.core.mainTable.getSchemaName() == this.table.getSchemaName()) {
            int n = this.database.schemaManager.getTableIndex(this.table);
            if (n != -1 && n < this.database.schemaManager.getTableIndex(constraint.core.mainTable)) {
                bl = true;
            }
        } else {
            bl = true;
        }
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newAutoName("IDX", this.table.getSchemaName(), this.table.getName(), 20);
        Index index2 = this.table.createIndexStructure(hsqlName, constraint.core.refCols, null, null, false, true, bl);
        HsqlNameManager.HsqlName hsqlName2 = this.database.nameManager.newAutoName("REF", constraint.getName().name, this.table.getSchemaName(), this.table.getName(), 20);
        constraint.core.uniqueName = constraint2.getName();
        constraint.core.mainName = hsqlName2;
        constraint.core.mainIndex = index;
        constraint.core.refTable = this.table;
        constraint.core.refName = constraint.getName();
        constraint.core.refIndex = index2;
        constraint.isForward = bl;
        Table table = this.table.moveDefinition(this.session, this.table.tableType, null, constraint, index2, -1, 0, this.emptySet, this.emptySet);
        this.moveData(this.table, table, -1, 0);
        this.database.schemaManager.addSchemaObject(constraint);
        this.setNewTableInSchema(table);
        Table table2 = this.database.schemaManager.getTable(this.session, constraint.core.mainTable.getName().name, constraint.core.mainTable.getSchemaName().name);
        table2.addConstraint(new Constraint(hsqlName2, constraint));
        this.updateConstraints(table, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(table);
        this.table = table;
    }

    void checkAddColumn(ColumnSchema columnSchema) {
        this.checkModifyTable();
        if (this.table.isText() && !this.table.isEmpty(this.session)) {
            throw Error.error(320);
        }
        if (this.table.findColumn(columnSchema.getName().name) != -1) {
            throw Error.error(5504);
        }
        if (columnSchema.isPrimaryKey() && this.table.hasPrimaryKey()) {
            throw Error.error(5530);
        }
        if (columnSchema.isIdentity() && this.table.hasIdentityColumn()) {
            throw Error.error(5525);
        }
        if (!(this.table.isEmpty(this.session) || columnSchema.hasDefault() || columnSchema.isNullable() && !columnSchema.isPrimaryKey() || columnSchema.isIdentity())) {
            throw Error.error(5531);
        }
    }

    void addColumn(ColumnSchema columnSchema, int n, HsqlArrayList hsqlArrayList) {
        Index index = null;
        Table table = this.table;
        Constraint constraint = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.checkAddColumn(columnSchema);
        Constraint constraint2 = (Constraint)hsqlArrayList.get(0);
        if (constraint2.getConstraintType() == 4) {
            if (columnSchema.getDataType().isLobType()) {
                throw Error.error(5534);
            }
            constraint2.core.mainCols = new int[]{n};
            this.database.schemaManager.checkSchemaObjectNotExists(constraint2.getName());
            if (this.table.hasPrimaryKey()) {
                throw Error.error(5530);
            }
            bl2 = true;
        } else {
            constraint2 = null;
        }
        this.table = this.table.moveDefinition(this.session, this.table.tableType, columnSchema, constraint2, null, n, 1, this.emptySet, this.emptySet);
        block5: for (int i = 1; i < hsqlArrayList.size(); ++i) {
            constraint2 = (Constraint)hsqlArrayList.get(i);
            switch (constraint2.constType) {
                case 2: {
                    if (bl2) {
                        throw Error.error(5522);
                    }
                    if (columnSchema.getDataType().isLobType()) {
                        throw Error.error(5534);
                    }
                    bl2 = true;
                    constraint2.core.mainCols = new int[]{n};
                    this.database.schemaManager.checkSchemaObjectNotExists(constraint2.getName());
                    HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newAutoName("IDX", constraint2.getName().name, this.table.getSchemaName(), this.table.getName(), 20);
                    index = this.table.createAndAddIndexStructure(this.session, hsqlName, constraint2.getMainColumns(), null, null, true, true, false);
                    constraint2.core.mainTable = this.table;
                    constraint2.core.mainIndex = index;
                    this.table.addConstraint(constraint2);
                    continue block5;
                }
                case 0: {
                    boolean bl4;
                    if (bl) {
                        throw Error.error(5528);
                    }
                    bl = true;
                    constraint2.core.refCols = new int[]{n};
                    constraint2.core.mainTable = this.database.schemaManager.getUserTable(this.session, constraint2.getMainTableName());
                    constraint2.core.refTable = this.table;
                    constraint2.core.refName = constraint2.getName();
                    boolean bl5 = bl4 = table == constraint2.core.mainTable;
                    if (bl4) {
                        constraint2.core.mainTable = this.table;
                    }
                    constraint2.setColumnsIndexes(this.table);
                    this.checkCreateForeignKey(constraint2);
                    Constraint constraint3 = constraint2.core.mainTable.getUniqueConstraintForColumns(constraint2.core.mainCols);
                    boolean bl6 = constraint2.core.mainTable.getSchemaName() != this.table.getSchemaName();
                    int n2 = this.database.schemaManager.getTableIndex(table);
                    if (!bl4 && n2 < this.database.schemaManager.getTableIndex(constraint2.core.mainTable)) {
                        bl6 = true;
                    }
                    HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newAutoName("IDX", constraint2.getName().name, this.table.getSchemaName(), this.table.getName(), 20);
                    index = this.table.createAndAddIndexStructure(this.session, hsqlName, constraint2.getRefColumns(), null, null, false, true, bl6);
                    constraint2.core.uniqueName = constraint3.getName();
                    constraint2.core.mainName = this.database.nameManager.newAutoName("REF", constraint2.core.refName.name, this.table.getSchemaName(), this.table.getName(), 20);
                    constraint2.core.mainIndex = constraint3.getMainIndex();
                    constraint2.core.refIndex = index;
                    constraint2.isForward = bl6;
                    this.table.addConstraint(constraint2);
                    constraint = new Constraint(constraint2.core.mainName, constraint2);
                    continue block5;
                }
                case 3: {
                    if (bl3) {
                        throw Error.error(5528);
                    }
                    bl3 = true;
                    constraint2.prepareCheckConstraint(this.session, this.table, false);
                    this.table.addConstraint(constraint2);
                    if (!constraint2.isNotNull()) continue block5;
                    columnSchema.setNullable(false);
                    this.table.setColumnTypeVars(n);
                    if (table.isEmpty(this.session) || columnSchema.hasDefault()) continue block5;
                    throw Error.error(5531);
                }
            }
        }
        columnSchema.compile(this.session, this.table);
        this.moveData(table, this.table, n, 1);
        if (constraint != null) {
            constraint.getMain().addConstraint(constraint);
        }
        this.registerConstraintNames(hsqlArrayList);
        this.setNewTableInSchema(this.table);
        this.updateConstraints(this.table, this.emptySet);
        this.database.schemaManager.addSchemaObject(columnSchema);
        this.database.schemaManager.recompileDependentObjects(this.table);
        this.table.compile(this.session, null);
    }

    void updateConstraints(OrderedHashSet orderedHashSet, OrderedHashSet orderedHashSet2) {
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            Table table = (Table)orderedHashSet.get(i);
            this.updateConstraints(table, orderedHashSet2);
        }
    }

    void updateConstraints(Table table, OrderedHashSet orderedHashSet) {
        for (int i = table.constraintList.length - 1; i >= 0; --i) {
            Constraint constraint;
            Table table2;
            Constraint constraint2 = table.constraintList[i];
            if (orderedHashSet.contains(constraint2.getName())) {
                table.removeConstraint(i);
                continue;
            }
            if (constraint2.getConstraintType() == 0) {
                table2 = this.database.schemaManager.getUserTable(this.session, constraint2.core.mainTable.getName());
                constraint = table2.getConstraint(constraint2.getMainName().name);
                constraint.core = constraint2.core;
                continue;
            }
            if (constraint2.getConstraintType() != 1) continue;
            table2 = this.database.schemaManager.getUserTable(this.session, constraint2.core.refTable.getName());
            constraint = table2.getConstraint(constraint2.getRefName().name);
            constraint.core = constraint2.core;
        }
    }

    OrderedHashSet makeNewTables(OrderedHashSet orderedHashSet, OrderedHashSet orderedHashSet2, OrderedHashSet orderedHashSet3) {
        OrderedHashSet orderedHashSet4 = new OrderedHashSet();
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            Table table = (Table)orderedHashSet.get(i);
            TableWorks tableWorks = new TableWorks(this.session, table);
            tableWorks.makeNewTable(orderedHashSet2, orderedHashSet3);
            orderedHashSet4.add(tableWorks.getTable());
        }
        return orderedHashSet4;
    }

    void makeNewTable(OrderedHashSet orderedHashSet, OrderedHashSet orderedHashSet2) {
        Table table = this.table.moveDefinition(this.session, this.table.tableType, null, null, null, -1, 0, orderedHashSet, orderedHashSet2);
        if (table.indexList.length == this.table.indexList.length) {
            this.database.persistentStoreCollection.releaseStore(table);
            return;
        }
        this.moveData(this.table, table, -1, 0);
        this.table = table;
    }

    void alterIndex(Index index, int[] nArray) {
        Index index2 = this.database.logger.newIndex(this.table, index, nArray);
        int n = index.getPosition();
        PersistentStore persistentStore = this.database.persistentStoreCollection.getStore(this.table);
        Index[] indexArray = persistentStore.getAccessorKeys();
        index2.setPosition(n);
        this.table.getIndexList()[n] = index2;
        this.table.setBestRowIdentifiers();
        indexArray[n] = index2;
        persistentStore.reindex(this.session, index2);
    }

    Index addIndex(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        Index index;
        this.checkModifyTable();
        if (this.table.isEmpty(this.session) || this.table.isIndexingMutable()) {
            index = this.table.createIndex(this.session, hsqlName, nArray, null, null, bl, false, false);
        } else {
            index = this.table.createIndexStructure(hsqlName, nArray, null, null, bl, false, false);
            Table table = this.table.moveDefinition(this.session, this.table.tableType, null, null, index, -1, 0, this.emptySet, this.emptySet);
            this.moveData(this.table, table, -1, 0);
            this.table = table;
            this.setNewTableInSchema(this.table);
            this.updateConstraints(this.table, this.emptySet);
        }
        this.database.schemaManager.addSchemaObject(index);
        this.database.schemaManager.recompileDependentObjects(this.table);
        return index;
    }

    void addPrimaryKey(Constraint constraint) {
        this.checkModifyTable();
        if (this.table.hasPrimaryKey()) {
            throw Error.error(5532);
        }
        this.database.schemaManager.checkSchemaObjectNotExists(constraint.getName());
        Table table = this.table.moveDefinition(this.session, this.table.tableType, null, constraint, null, -1, 0, this.emptySet, this.emptySet);
        this.moveData(this.table, table, -1, 0);
        this.table = table;
        this.database.schemaManager.addSchemaObject(constraint);
        this.setNewTableInSchema(this.table);
        this.updateConstraints(this.table, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    void addUniqueConstraint(int[] nArray, HsqlNameManager.HsqlName hsqlName) {
        this.checkModifyTable();
        this.database.schemaManager.checkSchemaObjectNotExists(hsqlName);
        if (this.table.getUniqueConstraintForColumns(nArray) != null) {
            throw Error.error(5522);
        }
        HsqlNameManager.HsqlName hsqlName2 = this.database.nameManager.newAutoName("IDX", hsqlName.name, this.table.getSchemaName(), this.table.getName(), 20);
        Index index = this.table.createIndexStructure(hsqlName2, nArray, null, null, true, true, false);
        Constraint constraint = new Constraint(hsqlName, this.table, index, 2);
        Table table = this.table.moveDefinition(this.session, this.table.tableType, null, constraint, index, -1, 0, this.emptySet, this.emptySet);
        this.moveData(this.table, table, -1, 0);
        this.table = table;
        this.database.schemaManager.addSchemaObject(constraint);
        this.setNewTableInSchema(this.table);
        this.updateConstraints(this.table, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    void addUniqueConstraint(Constraint constraint) {
        this.checkModifyTable();
        this.database.schemaManager.checkSchemaObjectNotExists(constraint.getName());
        if (this.table.getUniqueConstraintForColumns(constraint.getMainColumns()) != null) {
            throw Error.error(5522);
        }
        Table table = this.table.moveDefinition(this.session, this.table.tableType, null, constraint, constraint.getMainIndex(), -1, 0, this.emptySet, this.emptySet);
        this.moveData(this.table, table, -1, 0);
        this.table = table;
        this.database.schemaManager.addSchemaObject(constraint);
        this.setNewTableInSchema(this.table);
        this.updateConstraints(this.table, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    void addCheckConstraint(Constraint constraint) {
        this.checkModifyTable();
        this.database.schemaManager.checkSchemaObjectNotExists(constraint.getName());
        constraint.prepareCheckConstraint(this.session, this.table, true);
        this.table.addConstraint(constraint);
        if (constraint.isNotNull()) {
            ColumnSchema columnSchema = this.table.getColumn(constraint.notNullColumnIndex);
            columnSchema.setNullable(false);
            this.table.setColumnTypeVars(constraint.notNullColumnIndex);
        }
        this.database.schemaManager.addSchemaObject(constraint);
    }

    void dropIndex(String string) {
        this.checkModifyTable();
        Index index = this.table.getIndex(string);
        if (this.table.isIndexingMutable()) {
            this.table.dropIndex(index.getPosition());
        } else {
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            orderedHashSet.add(this.table.getIndex(string).getName());
            Table table = this.table.moveDefinition(this.session, this.table.tableType, null, null, null, -1, 0, this.emptySet, orderedHashSet);
            this.moveData(this.table, table, -1, 0);
            this.updateConstraints(table, this.emptySet);
            this.setNewTableInSchema(table);
            this.table = table;
        }
        if (!index.isConstraint()) {
            this.database.schemaManager.removeSchemaObject(index.getName());
        }
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    void dropColumn(int n, boolean bl) {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        OrderedHashSet orderedHashSet2 = this.table.getDependentConstraints(n);
        OrderedHashSet orderedHashSet3 = this.table.getContainingConstraints(n);
        OrderedHashSet orderedHashSet4 = this.table.getContainingIndexNames(n);
        ColumnSchema columnSchema = this.table.getColumn(n);
        HsqlNameManager.HsqlName hsqlName = columnSchema.getName();
        OrderedHashSet orderedHashSet5 = this.database.schemaManager.getReferencingObjectNames(this.table.getName(), hsqlName);
        this.checkModifyTable();
        if (!bl) {
            if (!orderedHashSet3.isEmpty()) {
                Constraint constraint = (Constraint)orderedHashSet3.get(0);
                HsqlNameManager.HsqlName hsqlName2 = constraint.getName();
                throw Error.error(5536, hsqlName2.getSchemaQualifiedStatementName());
            }
            if (!orderedHashSet5.isEmpty()) {
                block0: for (int i = 0; i < orderedHashSet5.size(); ++i) {
                    HsqlNameManager.HsqlName hsqlName3 = (HsqlNameManager.HsqlName)orderedHashSet5.get(i);
                    if (hsqlName3 == hsqlName) continue;
                    for (int j = 0; j < orderedHashSet2.size(); ++j) {
                        Constraint constraint = (Constraint)orderedHashSet2.get(j);
                        if (constraint.getName() == hsqlName3) continue block0;
                    }
                    throw Error.error(5536, hsqlName3.getSchemaQualifiedStatementName());
                }
            }
        }
        orderedHashSet2.addAll(orderedHashSet3);
        orderedHashSet3.clear();
        OrderedHashSet orderedHashSet6 = new OrderedHashSet();
        for (int i = 0; i < orderedHashSet2.size(); ++i) {
            Constraint constraint = (Constraint)orderedHashSet2.get(i);
            if (constraint.constType == 0) {
                orderedHashSet6.add(constraint.getMain());
                orderedHashSet.add(constraint.getMainName());
                orderedHashSet.add(constraint.getRefName());
                orderedHashSet4.add(constraint.getRefIndex().getName());
            }
            if (constraint.constType == 1) {
                orderedHashSet6.add(constraint.getRef());
                orderedHashSet.add(constraint.getMainName());
                orderedHashSet.add(constraint.getRefName());
                orderedHashSet4.add(constraint.getRefIndex().getName());
            }
            orderedHashSet.add(constraint.getName());
        }
        orderedHashSet6 = this.makeNewTables(orderedHashSet6, orderedHashSet, orderedHashSet4);
        Table table = this.table.moveDefinition(this.session, this.table.tableType, null, null, null, n, -1, orderedHashSet, orderedHashSet4);
        this.moveData(this.table, table, n, -1);
        this.database.schemaManager.removeSchemaObjects(orderedHashSet5);
        this.database.schemaManager.removeSchemaObjects(orderedHashSet);
        this.database.schemaManager.removeSchemaObject(hsqlName);
        this.setNewTableInSchema(table);
        this.setNewTablesInSchema(orderedHashSet6);
        this.updateConstraints(table, this.emptySet);
        this.updateConstraints(orderedHashSet6, orderedHashSet);
        this.database.schemaManager.recompileDependentObjects(orderedHashSet6);
        this.database.schemaManager.recompileDependentObjects(table);
        table.compile(this.session, null);
        this.table = table;
    }

    void registerConstraintNames(HsqlArrayList hsqlArrayList) {
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            Constraint constraint = (Constraint)hsqlArrayList.get(i);
            switch (constraint.constType) {
                case 2: 
                case 3: 
                case 4: {
                    this.database.schemaManager.addSchemaObject(constraint);
                }
            }
        }
    }

    void dropConstraint(String string, boolean bl) {
        Constraint constraint = this.table.getConstraint(string);
        if (constraint == null) {
            throw Error.error(5501, string);
        }
        switch (constraint.getConstraintType()) {
            case 1: {
                throw Error.error(4002);
            }
            case 2: 
            case 4: {
                Object object;
                this.checkModifyTable();
                OrderedHashSet orderedHashSet = this.table.getDependentConstraints(constraint);
                if (!bl && !orderedHashSet.isEmpty()) {
                    Constraint constraint2 = (Constraint)orderedHashSet.get(0);
                    throw Error.error(5533, constraint2.getName().getSchemaQualifiedStatementName());
                }
                OrderedHashSet orderedHashSet2 = new OrderedHashSet();
                OrderedHashSet orderedHashSet3 = new OrderedHashSet();
                OrderedHashSet orderedHashSet4 = new OrderedHashSet();
                for (int i = 0; i < orderedHashSet.size(); ++i) {
                    object = (Constraint)orderedHashSet.get(i);
                    Table table = ((Constraint)object).getMain();
                    if (table != this.table) {
                        orderedHashSet2.add(table);
                    }
                    if ((table = ((Constraint)object).getRef()) != this.table) {
                        orderedHashSet2.add(table);
                    }
                    orderedHashSet3.add(((Constraint)object).getMainName());
                    orderedHashSet3.add(((Constraint)object).getRefName());
                    orderedHashSet4.add(((Constraint)object).getRefIndex().getName());
                }
                orderedHashSet3.add(constraint.getName());
                if (constraint.getConstraintType() == 2) {
                    orderedHashSet4.add(constraint.getMainIndex().getName());
                }
                Table table = this.table.moveDefinition(this.session, this.table.tableType, null, null, null, -1, 0, orderedHashSet3, orderedHashSet4);
                this.moveData(this.table, table, -1, 0);
                orderedHashSet2 = this.makeNewTables(orderedHashSet2, orderedHashSet3, orderedHashSet4);
                if (constraint.getConstraintType() == 4) {
                    object = constraint.getMainColumns();
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        table.getColumn((int)object[i]).setPrimaryKey(false);
                        table.setColumnTypeVars((int)object[i]);
                    }
                }
                this.database.schemaManager.removeSchemaObjects(orderedHashSet3);
                this.setNewTableInSchema(table);
                this.setNewTablesInSchema(orderedHashSet2);
                this.updateConstraints(table, this.emptySet);
                this.updateConstraints(orderedHashSet2, orderedHashSet3);
                this.database.schemaManager.recompileDependentObjects(orderedHashSet2);
                this.database.schemaManager.recompileDependentObjects(table);
                this.table = table;
                break;
            }
            case 0: {
                this.checkModifyTable();
                OrderedHashSet orderedHashSet = new OrderedHashSet();
                Table table = constraint.getMain();
                HsqlNameManager.HsqlName hsqlName = constraint.getMainName();
                orderedHashSet.add(hsqlName);
                orderedHashSet.add(constraint.getRefName());
                OrderedHashSet orderedHashSet5 = new OrderedHashSet();
                orderedHashSet5.add(constraint.getRefIndex().getName());
                Table table2 = this.table.moveDefinition(this.session, this.table.tableType, null, null, null, -1, 0, orderedHashSet, orderedHashSet5);
                this.moveData(this.table, table2, -1, 0);
                this.database.schemaManager.removeSchemaObject(constraint.getName());
                this.setNewTableInSchema(table2);
                table.removeConstraint(hsqlName.name);
                this.updateConstraints(table2, this.emptySet);
                this.database.schemaManager.recompileDependentObjects(this.table);
                this.table = table2;
                break;
            }
            case 3: {
                this.database.schemaManager.removeSchemaObject(constraint.getName());
                if (!constraint.isNotNull()) break;
                ColumnSchema columnSchema = this.table.getColumn(constraint.notNullColumnIndex);
                columnSchema.setNullable(false);
                this.table.setColumnTypeVars(constraint.notNullColumnIndex);
            }
        }
    }

    void retypeColumn(ColumnSchema columnSchema, ColumnSchema columnSchema2) {
        int n;
        Type type = columnSchema.getDataType();
        Type type2 = columnSchema2.getDataType();
        this.checkModifyTable();
        if (type.equals(type2) && columnSchema.getIdentitySequence() == columnSchema2.getIdentitySequence()) {
            return;
        }
        if (!this.table.isEmpty(this.session) && type.typeCode != type2.typeCode) {
            n = columnSchema2.getDataType().canConvertFrom(columnSchema.getDataType()) ? 1 : 0;
            switch (type.typeCode) {
                case 1111: 
                case 2000: {
                    n = 0;
                }
            }
            if (n == 0) {
                throw Error.error(5561);
            }
        }
        n = this.table.getColumnIndex(columnSchema.getName().name);
        int n2 = type2.canMoveFrom(type);
        if (n2 == 0 && columnSchema2.isIdentity() && !columnSchema.isIdentity() && columnSchema.isNullable() && !columnSchema.isPrimaryKey()) {
            n2 = 1;
        }
        if (n2 == 1) {
            this.checkConvertColDataType(columnSchema, columnSchema2);
            n2 = 0;
        }
        if (n2 == 0) {
            columnSchema.setType(columnSchema2);
            columnSchema.setDefaultExpression(columnSchema2.getDefaultExpression());
            columnSchema.setIdentity(columnSchema2.getIdentitySequence());
            this.table.setColumnTypeVars(n);
            this.table.resetDefaultsFlag();
            return;
        }
        this.database.schemaManager.checkColumnIsReferenced(this.table.getName(), this.table.getColumn(n).getName());
        this.table.checkColumnInCheckConstraint(n);
        this.table.checkColumnInFKConstraint(n);
        this.checkConvertColDataType(columnSchema, columnSchema2);
        this.retypeColumn(columnSchema2, n);
    }

    void checkConvertColDataType(ColumnSchema columnSchema, ColumnSchema columnSchema2) {
        int n = this.table.getColumnIndex(columnSchema.getName().name);
        RowIterator rowIterator = this.table.rowIterator(this.session);
        while (rowIterator.hasNext()) {
            Row row = rowIterator.getNextRow();
            Object object = row.getData()[n];
            if (!columnSchema2.isNullable() && object == null) {
                throw Error.error(10);
            }
            columnSchema2.getDataType().convertToType(this.session, object, columnSchema.getDataType());
        }
    }

    private void retypeColumn(ColumnSchema columnSchema, int n) {
        Table table = this.table.moveDefinition(this.session, this.table.tableType, columnSchema, null, null, n, 0, this.emptySet, this.emptySet);
        this.moveData(this.table, table, n, 0);
        this.updateConstraints(table, this.emptySet);
        this.setNewTableInSchema(table);
        this.database.schemaManager.recompileDependentObjects(this.table);
        this.table = table;
    }

    void setColNullability(ColumnSchema columnSchema, boolean bl) {
        Constraint constraint = null;
        int n = this.table.getColumnIndex(columnSchema.getName().name);
        if (columnSchema.isNullable() == bl) {
            return;
        }
        if (bl) {
            if (columnSchema.isPrimaryKey()) {
                throw Error.error(5526);
            }
            this.table.checkColumnInFKConstraint(n, 2);
            this.removeColumnNotNullConstraints(n);
        } else {
            HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newAutoName("CT", this.table.getSchemaName(), this.table.getName(), 5);
            constraint = new Constraint(hsqlName, null, 3);
            constraint.check = new ExpressionLogical(columnSchema);
            constraint.prepareCheckConstraint(this.session, this.table, true);
            columnSchema.setNullable(false);
            this.table.addConstraint(constraint);
            this.table.setColumnTypeVars(n);
            this.database.schemaManager.addSchemaObject(constraint);
        }
    }

    void setColDefaultExpression(int n, Expression expression) {
        if (expression == null) {
            this.table.checkColumnInFKConstraint(n, 4);
        }
        ColumnSchema columnSchema = this.table.getColumn(n);
        columnSchema.setDefaultExpression(expression);
        this.table.setColumnTypeVars(n);
    }

    public boolean setTableType(Session session, int n) {
        Table table;
        int n2 = this.table.getTableType();
        if (n2 == n) {
            return false;
        }
        switch (n) {
            case 5: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                return false;
            }
        }
        try {
            table = this.table.moveDefinition(session, n, null, null, null, -1, 0, this.emptySet, this.emptySet);
            this.moveData(this.table, table, -1, 0);
            this.updateConstraints(table, this.emptySet);
        }
        catch (HsqlException hsqlException) {
            return false;
        }
        this.setNewTableInSchema(table);
        this.table = table;
        this.database.schemaManager.recompileDependentObjects(this.table);
        return true;
    }

    void setNewTablesInSchema(OrderedHashSet orderedHashSet) {
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            Table table = (Table)orderedHashSet.get(i);
            this.setNewTableInSchema(table);
        }
    }

    void setNewTableInSchema(Table table) {
        int n = this.database.schemaManager.getTableIndex(table);
        if (n != -1) {
            this.database.schemaManager.setTable(n, table);
        }
    }

    void removeColumnNotNullConstraints(int n) {
        for (int i = this.table.constraintList.length - 1; i >= 0; --i) {
            Constraint constraint = this.table.constraintList[i];
            if (!constraint.isNotNull() || constraint.notNullColumnIndex != n) continue;
            this.database.schemaManager.removeSchemaObject(constraint.getName());
        }
        ColumnSchema columnSchema = this.table.getColumn(n);
        columnSchema.setNullable(true);
        this.table.setColumnTypeVars(n);
    }

    private void checkModifyTable() {
        if (this.session.getUser().isSystem()) {
            return;
        }
        if (this.session.isProcessingScript) {
            return;
        }
        if (this.database.isFilesReadOnly() || this.table.isReadOnly()) {
            throw Error.error(456);
        }
        if (this.table.isText() && this.table.isConnected()) {
            throw Error.error(320);
        }
    }

    void moveData(Table table, Table table2, int n, int n2) {
        int n3 = table.getTableType();
        if (n3 == 3) {
            Session[] sessionArray = this.database.sessionManager.getAllSessions();
            for (int i = 0; i < sessionArray.length; ++i) {
                sessionArray[i].sessionData.persistentStoreCollection.moveData(table, table2, n, n2);
            }
        } else {
            PersistentStore persistentStore = this.database.persistentStoreCollection.getStore(table);
            PersistentStore persistentStore2 = this.database.persistentStoreCollection.getStore(table2);
            try {
                persistentStore2.moveData(this.session, persistentStore, n, n2);
            }
            catch (HsqlException hsqlException) {
                persistentStore2.release();
                this.database.persistentStoreCollection.setStore(table2, null);
                throw hsqlException;
            }
            this.database.persistentStoreCollection.releaseStore(table);
        }
    }
}

