/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Row;
import org.hsqldb.Schema;
import org.hsqldb.SchemaObject;
import org.hsqldb.SchemaObjectSet;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Table;
import org.hsqldb.TableUtil;
import org.hsqldb.TableWorks;
import org.hsqldb.TriggerDef;
import org.hsqldb.TypeInvariants;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.rights.Grantee;
import org.hsqldb.store.BaseHashMap;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Type;

public class SchemaManager {
    Database database;
    HsqlNameManager.HsqlName defaultSchemaHsqlName;
    HashMappedList schemaMap = new HashMappedList();
    MultiValueHashMap referenceMap = new MultiValueHashMap();
    int defaultTableType = 4;
    long schemaChangeTimestamp;
    HsqlNameManager.HsqlName[] catalogNameArray;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock readLock = this.lock.readLock();
    Lock writeLock = this.lock.writeLock();
    Table dualTable;
    int[][] tempIndexRoots;

    public SchemaManager(Database database) {
        this.database = database;
        this.defaultSchemaHsqlName = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        this.catalogNameArray = new HsqlNameManager.HsqlName[]{database.getCatalogName()};
        Schema schema = new Schema(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, SqlInvariants.INFORMATION_SCHEMA_HSQLNAME.owner);
        this.schemaMap.put(schema.getName().name, schema);
        try {
            schema.typeLookup.add(TypeInvariants.CARDINAL_NUMBER);
            schema.typeLookup.add(TypeInvariants.YES_OR_NO);
            schema.typeLookup.add(TypeInvariants.CHARACTER_DATA);
            schema.typeLookup.add(TypeInvariants.SQL_IDENTIFIER);
            schema.typeLookup.add(TypeInvariants.TIME_STAMP);
            schema.charsetLookup.add(TypeInvariants.SQL_TEXT);
            schema.charsetLookup.add(TypeInvariants.SQL_IDENTIFIER_CHARSET);
            schema.charsetLookup.add(TypeInvariants.SQL_CHARACTER);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    public void setSchemaChangeTimestamp() {
        this.schemaChangeTimestamp = this.database.txManager.getGlobalChangeTimestamp();
    }

    public long getSchemaChangeTimestamp() {
        return this.schemaChangeTimestamp;
    }

    public HsqlNameManager.HsqlName getSQLJSchemaHsqlName() {
        return SqlInvariants.SQLJ_SCHEMA_HSQLNAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPublicSchema() {
        this.writeLock.lock();
        try {
            HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(null, "PUBLIC", 2);
            Schema schema = new Schema(hsqlName, this.database.getGranteeManager().getDBARole());
            this.defaultSchemaHsqlName = schema.getName();
            this.schemaMap.put(schema.getName().name, schema);
            Object var4_3 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(HsqlNameManager.HsqlName hsqlName, Grantee grantee) {
        this.writeLock.lock();
        try {
            SqlInvariants.checkSchemaNameNotSystem(hsqlName.name);
            Schema schema = new Schema(hsqlName, grantee);
            this.schemaMap.add(hsqlName.name, schema);
            Object var5_4 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSchema(Session session, String string, boolean bl) {
        this.writeLock.lock();
        try {
            Object object;
            Object object2;
            Schema schema = (Schema)this.schemaMap.get(string);
            if (schema == null) {
                throw Error.error(5501, string);
            }
            if (SqlInvariants.isLobsSchemaName(string)) {
                throw Error.error(5503, string);
            }
            if (!bl && !schema.isEmpty()) {
                throw Error.error(4200);
            }
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            this.getCascadingSchemaReferences(schema.getName(), orderedHashSet);
            this.removeSchemaObjects(orderedHashSet);
            Iterator iterator = schema.schemaObjectIterator(3);
            while (iterator.hasNext()) {
                object2 = (Table)iterator.next();
                object = ((Table)object2).getFKConstraints();
                for (int i = 0; i < ((Constraint[])object).length; ++i) {
                    Constraint constraint = object[i];
                    if (constraint.getMain().getSchemaName() == schema.getName()) continue;
                    constraint.getMain().removeConstraint(constraint.getMainName().name);
                }
                this.removeTable(session, (Table)object2);
            }
            object2 = schema.schemaObjectIterator(7);
            while (object2.hasNext()) {
                object = (NumberSequence)object2.next();
                this.database.getGranteeManager().removeDbObject(((NumberSequence)object).getName());
            }
            schema.clearStructures();
            this.schemaMap.remove(string);
            if (this.defaultSchemaHsqlName.name.equals(string)) {
                object = this.database.nameManager.newHsqlName(string, false, 2);
                schema = new Schema((HsqlNameManager.HsqlName)object, this.database.getGranteeManager().getDBARole());
                this.defaultSchemaHsqlName = schema.getName();
                this.schemaMap.put(schema.getName().name, schema);
            }
            this.database.getUserManager().removeSchemaReference(string);
            this.database.getSessionManager().removeSchemaReference(schema);
            Object var12_11 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameSchema(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(hsqlName.name);
            Schema schema2 = (Schema)this.schemaMap.get(hsqlName2.name);
            if (schema == null) {
                throw Error.error(5501, hsqlName.name);
            }
            if (schema2 != null) {
                throw Error.error(5504, hsqlName2.name);
            }
            SqlInvariants.checkSchemaNameNotSystem(hsqlName.name);
            SqlInvariants.checkSchemaNameNotSystem(hsqlName2.name);
            int n = this.schemaMap.getIndex(hsqlName.name);
            schema.getName().rename(hsqlName2);
            this.schemaMap.set(n, hsqlName2.name, schema);
            Object var7_6 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStructures() {
        this.writeLock.lock();
        try {
            Iterator iterator = this.schemaMap.values().iterator();
            while (iterator.hasNext()) {
                Schema schema = (Schema)iterator.next();
                schema.clearStructures();
            }
            Object var4_3 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSchemaNamesArray() {
        this.readLock.lock();
        try {
            Object[] objectArray = new String[this.schemaMap.size()];
            this.schemaMap.toKeysArray(objectArray);
            Object[] objectArray2 = objectArray;
            Object var4_3 = null;
            this.readLock.unlock();
            return objectArray2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema[] getAllSchemas() {
        this.readLock.lock();
        try {
            Object[] objectArray = new Schema[this.schemaMap.size()];
            this.schemaMap.toValuesArray(objectArray);
            Object[] objectArray2 = objectArray;
            Object var4_3 = null;
            this.readLock.unlock();
            return objectArray2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName getUserSchemaHsqlName(String string) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(string);
            if (schema == null) {
                throw Error.error(4850, string);
            }
            if (schema.getName() == SqlInvariants.INFORMATION_SCHEMA_HSQLNAME) {
                throw Error.error(4850, string);
            }
            HsqlNameManager.HsqlName hsqlName = schema.getName();
            Object var5_4 = null;
            this.readLock.unlock();
            return hsqlName;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Grantee toSchemaOwner(String string) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(string);
            Grantee grantee = schema == null ? null : schema.getOwner();
            Object var5_4 = null;
            this.readLock.unlock();
            return grantee;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    public HsqlNameManager.HsqlName getDefaultSchemaHsqlName() {
        return this.defaultSchemaHsqlName;
    }

    public void setDefaultSchemaHsqlName(HsqlNameManager.HsqlName hsqlName) {
        this.defaultSchemaHsqlName = hsqlName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean schemaExists(String string) {
        this.readLock.lock();
        try {
            boolean bl = this.schemaMap.containsKey(string);
            Object var4_3 = null;
            this.readLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName findSchemaHsqlName(String string) {
        Schema schema;
        block3: {
            this.readLock.lock();
            try {
                schema = (Schema)this.schemaMap.get(string);
                if (schema != null) break block3;
                HsqlNameManager.HsqlName hsqlName = null;
                Object var5_5 = null;
                this.readLock.unlock();
                return hsqlName;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        HsqlNameManager.HsqlName hsqlName = schema.getName();
        Object var5_6 = null;
        this.readLock.unlock();
        return hsqlName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName getSchemaHsqlName(String string) {
        if (string == null) {
            return this.defaultSchemaHsqlName;
        }
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(string);
            if (schema == null) {
                throw Error.error(4850, string);
            }
            HsqlNameManager.HsqlName hsqlName = schema.getName();
            Object var5_4 = null;
            this.readLock.unlock();
            return hsqlName;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    public String getSchemaName(String string) {
        return this.getSchemaHsqlName((String)string).name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema findSchema(String string) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(string);
            Object var4_3 = null;
            this.readLock.unlock();
            return schema;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSchemas(Session session, Grantee grantee, boolean bl) {
        this.writeLock.lock();
        try {
            HsqlArrayList hsqlArrayList = this.getSchemas(grantee);
            Iterator iterator = hsqlArrayList.iterator();
            while (iterator.hasNext()) {
                Schema schema = (Schema)iterator.next();
                this.dropSchema(session, schema.getName().name, bl);
            }
            Object var8_7 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlArrayList getSchemas(Grantee grantee) {
        this.readLock.lock();
        try {
            Object object;
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            Iterator iterator = this.schemaMap.values().iterator();
            while (iterator.hasNext()) {
                object = (Schema)iterator.next();
                if (!grantee.equals(((Schema)object).getOwner())) continue;
                hsqlArrayList.add(object);
            }
            object = hsqlArrayList;
            Object var6_5 = null;
            this.readLock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasSchemas(Grantee grantee) {
        boolean bl;
        this.readLock.lock();
        try {
            Iterator iterator = this.schemaMap.values().iterator();
            while (iterator.hasNext()) {
                Schema schema = (Schema)iterator.next();
                if (!grantee.equals(schema.getOwner())) continue;
                boolean bl2 = true;
                Object var6_6 = null;
                this.readLock.unlock();
                return bl2;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.readLock.unlock();
            throw throwable;
        }
        Object var6_7 = null;
        this.readLock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlArrayList getAllTables(boolean bl) {
        this.readLock.lock();
        try {
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            String[] stringArray = this.getSchemaNamesArray();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (!bl && SqlInvariants.isLobsSchemaName(string) || SqlInvariants.isSystemSchemaName(string)) continue;
                HashMappedList hashMappedList = this.getTables(string);
                hsqlArrayList.addAll(hashMappedList.values());
            }
            HsqlArrayList hsqlArrayList2 = hsqlArrayList;
            Object var8_8 = null;
            this.readLock.unlock();
            return hsqlArrayList2;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMappedList getTables(String string) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(string);
            HashMappedList hashMappedList = schema.tableList;
            Object var5_4 = null;
            this.readLock.unlock();
            return hashMappedList;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    public HsqlNameManager.HsqlName[] getCatalogNameArray() {
        return this.catalogNameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName[] getCatalogAndBaseTableNames() {
        this.readLock.lock();
        try {
            Object[] objectArray;
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            HsqlArrayList hsqlArrayList = this.getAllTables(false);
            for (int i = 0; i < hsqlArrayList.size(); ++i) {
                objectArray = (Object[])hsqlArrayList.get(i);
                if (objectArray.isTemp()) continue;
                orderedHashSet.add(objectArray.getName());
            }
            orderedHashSet.add(this.database.getCatalogName());
            Object[] objectArray2 = new HsqlNameManager.HsqlName[orderedHashSet.size()];
            orderedHashSet.toArray(objectArray2);
            objectArray = objectArray2;
            Object var6_6 = null;
            this.readLock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaObjectSet getSchemaObjectSet(Schema schema, int n) {
        this.readLock.lock();
        try {
            SchemaObjectSet schemaObjectSet = null;
            switch (n) {
                case 7: {
                    schemaObjectSet = schema.sequenceLookup;
                    break;
                }
                case 3: 
                case 4: {
                    schemaObjectSet = schema.tableLookup;
                    break;
                }
                case 14: {
                    schemaObjectSet = schema.charsetLookup;
                    break;
                }
                case 15: {
                    schemaObjectSet = schema.collationLookup;
                    break;
                }
                case 17: {
                    schemaObjectSet = schema.procedureLookup;
                    break;
                }
                case 16: {
                    schemaObjectSet = schema.functionLookup;
                    break;
                }
                case 12: 
                case 13: {
                    schemaObjectSet = schema.typeLookup;
                    break;
                }
                case 20: {
                    schemaObjectSet = schema.indexLookup;
                    break;
                }
                case 5: {
                    schemaObjectSet = schema.constraintLookup;
                    break;
                }
                case 8: {
                    schemaObjectSet = schema.triggerLookup;
                    break;
                }
                case 24: {
                    schemaObjectSet = schema.specificRoutineLookup;
                }
            }
            SchemaObjectSet schemaObjectSet2 = schemaObjectSet;
            Object var6_5 = null;
            this.readLock.unlock();
            return schemaObjectSet2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSchemaObjectNotExists(HsqlNameManager.HsqlName hsqlName) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
            SchemaObjectSet schemaObjectSet = this.getSchemaObjectSet(schema, hsqlName.type);
            schemaObjectSet.checkAdd(hsqlName);
            Object var5_4 = null;
            this.readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Table getTable(Session session, String string, String string2) {
        Table table;
        block10: {
            Table table2;
            block9: {
                this.readLock.lock();
                try {
                    Table table3 = null;
                    if ("MODULE".equals(string2)) {
                        table3 = this.findSessionTable(session, string);
                        if (table3 == null) {
                            throw Error.error(5501, string);
                        }
                        Table table4 = table3;
                        Object var7_8 = null;
                        this.readLock.unlock();
                        return table4;
                    }
                    if (string2 == null) {
                        if (session.database.sqlSyntaxOra && "DUAL".equals(string)) {
                            table2 = this.dualTable;
                            break block9;
                        }
                        table3 = this.findSessionTable(session, string);
                    }
                    if (table3 == null) {
                        string2 = session.getSchemaName(string2);
                        table3 = this.findUserTable(session, string, string2);
                    }
                    if (table3 == null && "INFORMATION_SCHEMA".equals(string2) && this.database.dbInfo != null) {
                        table3 = this.database.dbInfo.getSystemTable(session, string);
                    }
                    if (table3 == null) {
                        throw Error.error(5501, string);
                    }
                    table = table3;
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    this.readLock.unlock();
                    throw throwable;
                }
            }
            Object var7_9 = null;
            this.readLock.unlock();
            return table2;
        }
        Object var7_10 = null;
        this.readLock.unlock();
        return table;
    }

    public Table getUserTable(Session session, HsqlNameManager.HsqlName hsqlName) {
        return this.getUserTable(session, hsqlName.name, hsqlName.schema.name);
    }

    public Table getUserTable(Session session, String string, String string2) {
        Table table = this.findUserTable(session, string, string2);
        if (table == null) {
            String string3 = string2 == null ? string : string2 + '.' + string;
            throw Error.error(5501, string3);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table findUserTable(Session session, String string, String string2) {
        int n;
        Schema schema;
        block5: {
            block4: {
                this.readLock.lock();
                try {
                    schema = (Schema)this.schemaMap.get(string2);
                    if (schema != null) break block4;
                    Table table = null;
                    Object var8_7 = null;
                    this.readLock.unlock();
                    return table;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    this.readLock.unlock();
                    throw throwable;
                }
            }
            n = schema.tableList.getIndex(string);
            if (n != -1) break block5;
            Table table = null;
            Object var8_8 = null;
            this.readLock.unlock();
            return table;
        }
        Table table = (Table)schema.tableList.get(n);
        Object var8_9 = null;
        this.readLock.unlock();
        return table;
    }

    public Table findSessionTable(Session session, String string) {
        return session.sessionContext.findSessionTable(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTableOrView(Session session, Table table, boolean bl) {
        this.writeLock.lock();
        try {
            if (table.isView()) {
                this.removeSchemaObject(table.getName(), bl);
            } else {
                this.dropTable(session, table, bl);
            }
            Object var5_4 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    private void dropTable(Session session, Table table, boolean bl) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
        int n2 = schema.tableList.getIndex(table.getName().name);
        OrderedHashSet orderedHashSet = table.getDependentExternalConstraints();
        OrderedHashSet orderedHashSet2 = new OrderedHashSet();
        this.getCascadingReferencingObjectNames(table.getName(), orderedHashSet2);
        if (!bl) {
            int n3;
            for (n3 = 0; n3 < orderedHashSet.size(); ++n3) {
                object3 = (Constraint)orderedHashSet.get(n3);
                object2 = ((Constraint)object3).getRef().getName();
                object = ((Constraint)object3).getRefName();
                if (((Constraint)object3).getConstraintType() != 1) continue;
                throw Error.error(5533, ((HsqlNameManager.HsqlName)object).schema.name + '.' + ((HsqlNameManager.HsqlName)object2).name + '.' + ((HsqlNameManager.HsqlName)object).name);
            }
            if (!orderedHashSet2.isEmpty()) {
                for (n3 = 0; n3 < orderedHashSet2.size(); ++n3) {
                    object3 = (HsqlNameManager.HsqlName)orderedHashSet2.get(n3);
                    if (((HsqlNameManager.HsqlName)object3).parent == table.getName()) continue;
                    throw Error.error(5502, ((HsqlNameManager.HsqlName)object3).getSchemaQualifiedStatementName());
                }
            }
        }
        OrderedHashSet orderedHashSet3 = new OrderedHashSet();
        object3 = new OrderedHashSet();
        object2 = new OrderedHashSet();
        object = table.getReferences();
        for (int i = ((BaseHashMap)object).size() - 1; i >= 0; --i) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)((OrderedHashSet)object).get(i);
            if (hsqlName.type != 7) continue;
            ((OrderedHashSet)object).remove(i);
        }
        TriggerDef[] triggerDefArray = table.getTriggers();
        for (n = 0; n < triggerDefArray.length; ++n) {
            ((HashSet)object).add(triggerDefArray[n].getName());
        }
        for (n = 0; n < orderedHashSet.size(); ++n) {
            Constraint constraint = (Constraint)orderedHashSet.get(n);
            Table table2 = constraint.getMain();
            if (table2 != table) {
                orderedHashSet3.add(table2);
            }
            if ((table2 = constraint.getRef()) != table) {
                orderedHashSet3.add(table2);
            }
            ((HashSet)object3).add(constraint.getMainName());
            ((HashSet)object3).add(constraint.getRefName());
            ((HashSet)object2).add(constraint.getRefIndex().getName());
        }
        TableWorks tableWorks = new TableWorks(session, table);
        orderedHashSet3 = tableWorks.makeNewTables(orderedHashSet3, (OrderedHashSet)object3, (OrderedHashSet)object2);
        tableWorks.setNewTablesInSchema(orderedHashSet3);
        tableWorks.updateConstraints(orderedHashSet3, (OrderedHashSet)object3);
        this.removeSchemaObjects(orderedHashSet2);
        this.removeSchemaObjects((OrderedHashSet)object);
        this.removeReferencedObject(table.getName());
        this.removeReferencingObject(table);
        schema.tableList.remove(n2);
        schema.indexLookup.removeParent(table.getName());
        schema.constraintLookup.removeParent(table.getName());
        this.removeTable(session, table);
        this.recompileDependentObjects(orderedHashSet3);
    }

    private void removeTable(Session session, Table table) {
        this.database.getGranteeManager().removeDbObject(table.getName());
        table.releaseTriggers();
        if (table.hasLobColumn()) {
            RowIterator rowIterator = table.rowIterator(session);
            while (rowIterator.hasNext()) {
                Row row = rowIterator.getNextRow();
                Object[] objectArray = row.getData();
                session.sessionData.adjustLobUsageCount(table, objectArray, -1);
            }
        }
        this.database.persistentStoreCollection.releaseStore(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTable(int n, Table table) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
            schema.tableList.set(n, table.getName().name, table);
            Object var5_4 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTableIndex(Table table) {
        Schema schema;
        block3: {
            this.readLock.lock();
            try {
                schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
                if (schema != null) break block3;
                int n = -1;
                Object var6_5 = null;
                this.readLock.unlock();
                return n;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        HsqlNameManager.HsqlName hsqlName = table.getName();
        int n = schema.tableList.getIndex(hsqlName.name);
        Object var6_6 = null;
        this.readLock.unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recompileDependentObjects(OrderedHashSet orderedHashSet) {
        this.writeLock.lock();
        try {
            OrderedHashSet orderedHashSet2 = new OrderedHashSet();
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                Table table = (Table)orderedHashSet.get(i);
                orderedHashSet2.addAll(this.getReferencingObjectNames(table.getName()));
            }
            Session session = this.database.sessionManager.getSysSession();
            for (int i = 0; i < orderedHashSet2.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet2.get(i);
                switch (hsqlName.type) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 24: {
                        SchemaObject schemaObject = this.getSchemaObject(hsqlName);
                        schemaObject.compile(session, null);
                    }
                }
            }
            Object var8_9 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recompileDependentObjects(Table table) {
        this.writeLock.lock();
        try {
            SchemaObject schemaObject;
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            this.getCascadingReferencingObjectNames(table.getName(), orderedHashSet);
            Session session = this.database.sessionManager.getSysSession();
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
                switch (hsqlName.type) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 24: {
                        schemaObject = this.getSchemaObject(hsqlName);
                        schemaObject.compile(session, null);
                    }
                }
            }
            HsqlArrayList hsqlArrayList = this.getAllTables(false);
            for (int i = 0; i < hsqlArrayList.size(); ++i) {
                schemaObject = (Table)hsqlArrayList.get(i);
                ((Table)schemaObject).verifyConstraintsIntegrity();
            }
            Object var8_9 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumberSequence getSequence(String string, String string2, boolean bl) {
        NumberSequence numberSequence;
        block4: {
            this.readLock.lock();
            try {
                Schema schema = (Schema)this.schemaMap.get(string2);
                if (schema == null || (numberSequence = (NumberSequence)schema.sequenceList.get(string)) == null) break block4;
                NumberSequence numberSequence2 = numberSequence;
                Object var8_7 = null;
                this.readLock.unlock();
                return numberSequence2;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        if (bl) {
            throw Error.error(5501, string);
        }
        numberSequence = null;
        Object var8_8 = null;
        this.readLock.unlock();
        return numberSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getUserDefinedType(String string, String string2, boolean bl) {
        SchemaObject schemaObject;
        block4: {
            this.readLock.lock();
            try {
                Schema schema = (Schema)this.schemaMap.get(string2);
                if (schema == null || (schemaObject = schema.typeLookup.getObject(string)) == null) break block4;
                Type type = (Type)schemaObject;
                Object var8_7 = null;
                this.readLock.unlock();
                return type;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        if (bl) {
            throw Error.error(5501, string);
        }
        schemaObject = null;
        Object var8_8 = null;
        this.readLock.unlock();
        return schemaObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getDomainOrUDT(String string, String string2, boolean bl) {
        SchemaObject schemaObject;
        block4: {
            this.readLock.lock();
            try {
                Schema schema = (Schema)this.schemaMap.get(string2);
                if (schema == null || (schemaObject = schema.typeLookup.getObject(string)) == null) break block4;
                Type type = (Type)schemaObject;
                Object var8_7 = null;
                this.readLock.unlock();
                return type;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        if (bl) {
            throw Error.error(5501, string);
        }
        schemaObject = null;
        Object var8_8 = null;
        this.readLock.unlock();
        return schemaObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getDomain(String string, String string2, boolean bl) {
        SchemaObject schemaObject;
        block4: {
            this.readLock.lock();
            try {
                Schema schema = (Schema)this.schemaMap.get(string2);
                if (schema == null || (schemaObject = schema.typeLookup.getObject(string)) == null || !((Type)schemaObject).isDomainType()) break block4;
                Type type = (Type)schemaObject;
                Object var8_7 = null;
                this.readLock.unlock();
                return type;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        if (bl) {
            throw Error.error(5501, string);
        }
        schemaObject = null;
        Object var8_8 = null;
        this.readLock.unlock();
        return schemaObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getDistinctType(String string, String string2, boolean bl) {
        SchemaObject schemaObject;
        block4: {
            this.readLock.lock();
            try {
                Schema schema = (Schema)this.schemaMap.get(string2);
                if (schema == null || (schemaObject = schema.typeLookup.getObject(string)) == null || !((Type)schemaObject).isDistinctType()) break block4;
                Type type = (Type)schemaObject;
                Object var8_7 = null;
                this.readLock.unlock();
                return type;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        if (bl) {
            throw Error.error(5501, string);
        }
        schemaObject = null;
        Object var8_8 = null;
        this.readLock.unlock();
        return schemaObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaObject getSchemaObject(String string, String string2, int n) {
        this.readLock.lock();
        try {
            SchemaObject schemaObject = this.findSchemaObject(string, string2, n);
            if (schemaObject == null) {
                throw Error.error(SchemaObjectSet.getGetErrorCode(n), string);
            }
            SchemaObject schemaObject2 = schemaObject;
            Object var7_6 = null;
            this.readLock.unlock();
            return schemaObject2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SchemaObject findSchemaObject(String string, String string2, int n) {
        TriggerDef triggerDef;
        block45: {
            SchemaObject schemaObject;
            block44: {
                Constraint constraint;
                block43: {
                    SchemaObject schemaObject2;
                    block42: {
                        SchemaObject schemaObject3;
                        block41: {
                            Index index;
                            block40: {
                                SchemaObject schemaObject4;
                                block39: {
                                    SchemaObject schemaObject5;
                                    block38: {
                                        SchemaObject schemaObject6;
                                        block37: {
                                            SchemaObject schemaObject7;
                                            block36: {
                                                SchemaObject schemaObject8;
                                                block35: {
                                                    SchemaObject schemaObject9;
                                                    block34: {
                                                        SchemaObject schemaObject10;
                                                        block33: {
                                                            SchemaObject schemaObject11;
                                                            block32: {
                                                                Charset charset;
                                                                block31: {
                                                                    Charset charset2;
                                                                    block30: {
                                                                        Charset charset3;
                                                                        block29: {
                                                                            Charset charset4;
                                                                            block28: {
                                                                                SchemaObject schemaObject12;
                                                                                block27: {
                                                                                    SchemaObject schemaObject13;
                                                                                    this.readLock.lock();
                                                                                    try {
                                                                                        Schema schema = (Schema)this.schemaMap.get(string2);
                                                                                        if (schema == null) {
                                                                                            SchemaObject schemaObject14 = null;
                                                                                            Object var11_7 = null;
                                                                                            this.readLock.unlock();
                                                                                            return schemaObject14;
                                                                                        }
                                                                                        SchemaObjectSet schemaObjectSet = null;
                                                                                        switch (n) {
                                                                                            case 7: {
                                                                                                schemaObject13 = schema.sequenceLookup.getObject(string);
                                                                                                break;
                                                                                            }
                                                                                            case 3: 
                                                                                            case 4: {
                                                                                                schemaObject12 = schema.tableLookup.getObject(string);
                                                                                                break block27;
                                                                                            }
                                                                                            case 14: {
                                                                                                if (string.equals("SQL_IDENTIFIER")) {
                                                                                                    charset4 = TypeInvariants.SQL_IDENTIFIER_CHARSET;
                                                                                                    break block28;
                                                                                                }
                                                                                                if (string.equals("SQL_TEXT")) {
                                                                                                    charset3 = TypeInvariants.SQL_TEXT;
                                                                                                    break block29;
                                                                                                }
                                                                                                if (string.equals("LATIN1")) {
                                                                                                    charset2 = TypeInvariants.LATIN1;
                                                                                                    break block30;
                                                                                                }
                                                                                                if (string.equals("ASCII_GRAPHIC")) {
                                                                                                    charset = TypeInvariants.ASCII_GRAPHIC;
                                                                                                    break block31;
                                                                                                }
                                                                                                schemaObject11 = schema.charsetLookup.getObject(string);
                                                                                                break block32;
                                                                                            }
                                                                                            case 15: {
                                                                                                schemaObject10 = schema.collationLookup.getObject(string);
                                                                                                break block33;
                                                                                            }
                                                                                            case 17: {
                                                                                                schemaObject9 = schema.procedureLookup.getObject(string);
                                                                                                break block34;
                                                                                            }
                                                                                            case 16: {
                                                                                                schemaObject8 = schema.functionLookup.getObject(string);
                                                                                                break block35;
                                                                                            }
                                                                                            case 18: {
                                                                                                SchemaObject schemaObject15 = schema.procedureLookup.getObject(string);
                                                                                                if (schemaObject15 == null) {
                                                                                                    schemaObject15 = schema.functionLookup.getObject(string);
                                                                                                }
                                                                                                schemaObject7 = schemaObject15;
                                                                                                break block36;
                                                                                            }
                                                                                            case 24: {
                                                                                                schemaObject6 = schema.specificRoutineLookup.getObject(string);
                                                                                                break block37;
                                                                                            }
                                                                                            case 12: 
                                                                                            case 13: {
                                                                                                schemaObject5 = schema.typeLookup.getObject(string);
                                                                                                break block38;
                                                                                            }
                                                                                            case 20: {
                                                                                                schemaObjectSet = schema.indexLookup;
                                                                                                HsqlNameManager.HsqlName hsqlName = schemaObjectSet.getName(string);
                                                                                                if (hsqlName == null) {
                                                                                                    schemaObject4 = null;
                                                                                                    break block39;
                                                                                                }
                                                                                                Table table = (Table)schema.tableList.get(hsqlName.parent.name);
                                                                                                index = table.getIndex(string);
                                                                                                break block40;
                                                                                            }
                                                                                            case 5: {
                                                                                                schemaObjectSet = schema.constraintLookup;
                                                                                                HsqlNameManager.HsqlName hsqlName = schemaObjectSet.getName(string);
                                                                                                if (hsqlName == null) {
                                                                                                    schemaObject3 = null;
                                                                                                    break block41;
                                                                                                }
                                                                                                Table table = (Table)schema.tableList.get(hsqlName.parent.name);
                                                                                                if (table == null) {
                                                                                                    schemaObject2 = null;
                                                                                                    break block42;
                                                                                                }
                                                                                                constraint = table.getConstraint(string);
                                                                                                break block43;
                                                                                            }
                                                                                            case 8: {
                                                                                                schemaObjectSet = schema.indexLookup;
                                                                                                HsqlNameManager.HsqlName hsqlName = schemaObjectSet.getName(string);
                                                                                                if (hsqlName == null) {
                                                                                                    schemaObject = null;
                                                                                                    break block44;
                                                                                                }
                                                                                                Table table = (Table)schema.tableList.get(hsqlName.parent.name);
                                                                                                triggerDef = table.getTrigger(string);
                                                                                                break block45;
                                                                                            }
                                                                                            default: {
                                                                                                throw Error.runtimeError(201, "SchemaManager");
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    catch (Throwable throwable) {
                                                                                        Object var11_28 = null;
                                                                                        this.readLock.unlock();
                                                                                        throw throwable;
                                                                                    }
                                                                                    Object var11_8 = null;
                                                                                    this.readLock.unlock();
                                                                                    return schemaObject13;
                                                                                }
                                                                                Object var11_9 = null;
                                                                                this.readLock.unlock();
                                                                                return schemaObject12;
                                                                            }
                                                                            Object var11_10 = null;
                                                                            this.readLock.unlock();
                                                                            return charset4;
                                                                        }
                                                                        Object var11_11 = null;
                                                                        this.readLock.unlock();
                                                                        return charset3;
                                                                    }
                                                                    Object var11_12 = null;
                                                                    this.readLock.unlock();
                                                                    return charset2;
                                                                }
                                                                Object var11_13 = null;
                                                                this.readLock.unlock();
                                                                return charset;
                                                            }
                                                            Object var11_14 = null;
                                                            this.readLock.unlock();
                                                            return schemaObject11;
                                                        }
                                                        Object var11_15 = null;
                                                        this.readLock.unlock();
                                                        return schemaObject10;
                                                    }
                                                    Object var11_16 = null;
                                                    this.readLock.unlock();
                                                    return schemaObject9;
                                                }
                                                Object var11_17 = null;
                                                this.readLock.unlock();
                                                return schemaObject8;
                                            }
                                            Object var11_18 = null;
                                            this.readLock.unlock();
                                            return schemaObject7;
                                        }
                                        Object var11_19 = null;
                                        this.readLock.unlock();
                                        return schemaObject6;
                                    }
                                    Object var11_20 = null;
                                    this.readLock.unlock();
                                    return schemaObject5;
                                }
                                Object var11_21 = null;
                                this.readLock.unlock();
                                return schemaObject4;
                            }
                            Object var11_22 = null;
                            this.readLock.unlock();
                            return index;
                        }
                        Object var11_23 = null;
                        this.readLock.unlock();
                        return schemaObject3;
                    }
                    Object var11_24 = null;
                    this.readLock.unlock();
                    return schemaObject2;
                }
                Object var11_25 = null;
                this.readLock.unlock();
                return constraint;
            }
            Object var11_26 = null;
            this.readLock.unlock();
            return schemaObject;
        }
        Object var11_27 = null;
        this.readLock.unlock();
        return triggerDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Table findUserTableForIndex(Session session, String string, String string2) {
        HsqlNameManager.HsqlName hsqlName;
        block3: {
            this.readLock.lock();
            try {
                Schema schema = (Schema)this.schemaMap.get(string2);
                hsqlName = schema.indexLookup.getName(string);
                if (hsqlName != null) break block3;
                Table table = null;
                Object var8_8 = null;
                this.readLock.unlock();
                return table;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        Table table = this.findUserTable(session, hsqlName.parent.name, string2);
        Object var8_9 = null;
        this.readLock.unlock();
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropIndex(Session session, HsqlNameManager.HsqlName hsqlName) {
        this.writeLock.lock();
        try {
            Table table = this.getTable(session, hsqlName.parent.name, hsqlName.parent.schema.name);
            TableWorks tableWorks = new TableWorks(session, table);
            tableWorks.dropIndex(hsqlName.name);
            Object var6_5 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropConstraint(Session session, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        this.writeLock.lock();
        try {
            Table table = this.getTable(session, hsqlName.parent.name, hsqlName.parent.schema.name);
            TableWorks tableWorks = new TableWorks(session, table);
            tableWorks.dropConstraint(hsqlName.name, bl);
            Object var7_6 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDependentObjects(HsqlNameManager.HsqlName hsqlName) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
            schema.indexLookup.removeParent(hsqlName);
            schema.constraintLookup.removeParent(hsqlName);
            schema.triggerLookup.removeParent(hsqlName);
            Object var4_3 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeExportedKeys(Table table) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
            for (int i = 0; i < schema.tableList.size(); ++i) {
                Table table2 = (Table)schema.tableList.get(i);
                Constraint[] constraintArray = table2.getConstraints();
                for (int j = constraintArray.length - 1; j >= 0; --j) {
                    Table table3 = constraintArray[j].getRef();
                    if (table != table3) continue;
                    table2.removeConstraint(j);
                }
            }
            Object var9_8 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator databaseObjectIterator(String string, int n) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(string);
            Iterator iterator = schema.schemaObjectIterator(n);
            Object var6_5 = null;
            this.readLock.unlock();
            return iterator;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator databaseObjectIterator(int n) {
        this.readLock.lock();
        try {
            Iterator iterator = this.schemaMap.values().iterator();
            WrapperIterator wrapperIterator = new WrapperIterator();
            while (iterator.hasNext()) {
                Object[] objectArray;
                int n2 = n;
                if (n == 18) {
                    n2 = 16;
                }
                Schema schema = (Schema)iterator.next();
                SchemaObjectSet schemaObjectSet = schema.getObjectSet(n2);
                if (schemaObjectSet.map.size() != 0) {
                    objectArray = new Object[schemaObjectSet.map.size()];
                    schemaObjectSet.map.valuesToArray(objectArray);
                    wrapperIterator = new WrapperIterator(wrapperIterator, new WrapperIterator(objectArray));
                }
                if (n != 18) continue;
                schemaObjectSet = schema.getObjectSet(17);
                if (schemaObjectSet.map.size() == 0) continue;
                objectArray = new Object[schemaObjectSet.map.size()];
                schemaObjectSet.map.valuesToArray(objectArray);
                wrapperIterator = new WrapperIterator(wrapperIterator, new WrapperIterator(objectArray));
            }
            WrapperIterator wrapperIterator2 = wrapperIterator;
            Object var9_9 = null;
            this.readLock.unlock();
            return wrapperIterator2;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    private void addReferences(SchemaObject schemaObject) {
        OrderedHashSet orderedHashSet = schemaObject.getReferences();
        if (orderedHashSet == null) {
            return;
        }
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
            HsqlNameManager.HsqlName hsqlName2 = schemaObject.getName();
            if (schemaObject instanceof Routine) {
                hsqlName2 = ((Routine)schemaObject).getSpecificName();
            }
            this.referenceMap.put(hsqlName, hsqlName2);
        }
    }

    private void removeReferencedObject(HsqlNameManager.HsqlName hsqlName) {
        this.referenceMap.remove(hsqlName);
    }

    private void removeReferencingObject(SchemaObject schemaObject) {
        OrderedHashSet orderedHashSet = schemaObject.getReferences();
        if (orderedHashSet == null) {
            return;
        }
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
            HsqlNameManager.HsqlName hsqlName2 = schemaObject.getName();
            if (schemaObject instanceof Routine) {
                hsqlName2 = ((Routine)schemaObject).getSpecificName();
            }
            this.referenceMap.remove(hsqlName, hsqlName2);
            if (hsqlName2.parent == null) continue;
            this.referenceMap.remove(hsqlName, hsqlName2.parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedHashSet getReferencingObjectNames(HsqlNameManager.HsqlName hsqlName) {
        this.readLock.lock();
        try {
            Object object;
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            Iterator iterator = this.referenceMap.get(hsqlName);
            while (iterator.hasNext()) {
                object = (HsqlNameManager.HsqlName)iterator.next();
                orderedHashSet.add(object);
            }
            object = orderedHashSet;
            Object var6_5 = null;
            this.readLock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedHashSet getReferencingObjectNames(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        this.readLock.lock();
        try {
            Object object;
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            Iterator iterator = this.referenceMap.get(hsqlName);
            while (iterator.hasNext()) {
                object = (HsqlNameManager.HsqlName)iterator.next();
                SchemaObject schemaObject = this.getSchemaObject((HsqlNameManager.HsqlName)object);
                OrderedHashSet orderedHashSet2 = schemaObject.getReferences();
                if (!orderedHashSet2.contains(hsqlName2)) continue;
                orderedHashSet.add(object);
            }
            object = orderedHashSet;
            Object var9_8 = null;
            this.readLock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReferenced(HsqlNameManager.HsqlName hsqlName) {
        this.writeLock.lock();
        try {
            boolean bl = this.referenceMap.containsKey(hsqlName);
            Object var4_3 = null;
            this.writeLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCascadingReferencingObjectNames(HsqlNameManager.HsqlName hsqlName, OrderedHashSet orderedHashSet) {
        this.readLock.lock();
        try {
            OrderedHashSet orderedHashSet2 = new OrderedHashSet();
            Iterator iterator = this.referenceMap.get(hsqlName);
            while (iterator.hasNext()) {
                HsqlNameManager.HsqlName hsqlName2 = (HsqlNameManager.HsqlName)iterator.next();
                boolean bl = orderedHashSet.add(hsqlName2);
                if (!bl) continue;
                orderedHashSet2.add(hsqlName2);
            }
            for (int i = 0; i < orderedHashSet2.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName3 = (HsqlNameManager.HsqlName)orderedHashSet2.get(i);
                this.getCascadingReferencingObjectNames(hsqlName3, orderedHashSet);
            }
            Object var8_9 = null;
            this.readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    public void getCascadingSchemaReferences(HsqlNameManager.HsqlName hsqlName, OrderedHashSet orderedHashSet) {
        Iterator iterator = this.referenceMap.keySet().iterator();
        while (iterator.hasNext()) {
            HsqlNameManager.HsqlName hsqlName2 = (HsqlNameManager.HsqlName)iterator.next();
            if (hsqlName2.schema != hsqlName) continue;
            this.getCascadingReferencingObjectNames(hsqlName2, orderedHashSet);
        }
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName3 = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
            if (hsqlName3.schema != hsqlName) continue;
            orderedHashSet.remove(i);
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName getSchemaObjectName(HsqlNameManager.HsqlName hsqlName, String string, int n, boolean bl) {
        Object object;
        SchemaObjectSet schemaObjectSet;
        Schema schema;
        block8: {
            this.readLock.lock();
            try {
                schema = (Schema)this.schemaMap.get(hsqlName.name);
                schemaObjectSet = null;
                if (schema != null) break block8;
                if (bl) {
                    throw Error.error(SchemaObjectSet.getGetErrorCode(n));
                }
                HsqlNameManager.HsqlName hsqlName2 = null;
                Object var9_9 = null;
                this.readLock.unlock();
                return hsqlName2;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        if (n == 18) {
            schemaObjectSet = schema.functionLookup;
            object = schema.functionLookup.getObject(string);
            if (object == null) {
                schemaObjectSet = schema.procedureLookup;
                object = schema.procedureLookup.getObject(string);
            }
        } else {
            schemaObjectSet = this.getSchemaObjectSet(schema, n);
        }
        if (bl) {
            schemaObjectSet.checkExists(string);
        }
        object = schemaObjectSet.getName(string);
        Object var9_10 = null;
        this.readLock.unlock();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SchemaObject getSchemaObject(HsqlNameManager.HsqlName hsqlName) {
        SchemaObject schemaObject;
        block38: {
            Index index;
            block37: {
                SchemaObject schemaObject2;
                block36: {
                    SchemaObject schemaObject3;
                    block35: {
                        Constraint constraint;
                        block34: {
                            SchemaObject schemaObject4;
                            block33: {
                                TriggerDef triggerDef;
                                block32: {
                                    SchemaObject schemaObject5;
                                    block31: {
                                        SchemaObject schemaObject6;
                                        block30: {
                                            SchemaObject schemaObject7;
                                            block29: {
                                                SchemaObject schemaObject8;
                                                block28: {
                                                    SchemaObject schemaObject9;
                                                    block27: {
                                                        SchemaObject schemaObject10;
                                                        block26: {
                                                            SchemaObject schemaObject11;
                                                            block25: {
                                                                SchemaObject schemaObject12;
                                                                block24: {
                                                                    SchemaObject schemaObject13;
                                                                    block23: {
                                                                        SchemaObject schemaObject14;
                                                                        block22: {
                                                                            this.readLock.lock();
                                                                            try {
                                                                                Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
                                                                                if (schema == null) {
                                                                                    SchemaObject schemaObject15 = null;
                                                                                    Object var8_13 = null;
                                                                                    this.readLock.unlock();
                                                                                    return schemaObject15;
                                                                                }
                                                                                switch (hsqlName.type) {
                                                                                    case 7: {
                                                                                        schemaObject14 = (SchemaObject)schema.sequenceList.get(hsqlName.name);
                                                                                        break block22;
                                                                                    }
                                                                                    case 3: 
                                                                                    case 4: {
                                                                                        schemaObject13 = (SchemaObject)schema.tableList.get(hsqlName.name);
                                                                                        break block23;
                                                                                    }
                                                                                    case 14: {
                                                                                        schemaObject12 = schema.charsetLookup.getObject(hsqlName.name);
                                                                                        break block24;
                                                                                    }
                                                                                    case 15: {
                                                                                        schemaObject11 = schema.collationLookup.getObject(hsqlName.name);
                                                                                        break block25;
                                                                                    }
                                                                                    case 17: {
                                                                                        schemaObject10 = schema.procedureLookup.getObject(hsqlName.name);
                                                                                        break block26;
                                                                                    }
                                                                                    case 16: {
                                                                                        schemaObject9 = schema.functionLookup.getObject(hsqlName.name);
                                                                                        break block27;
                                                                                    }
                                                                                    case 24: {
                                                                                        schemaObject8 = schema.specificRoutineLookup.getObject(hsqlName.name);
                                                                                        break block28;
                                                                                    }
                                                                                    case 18: {
                                                                                        SchemaObject schemaObject16 = schema.functionLookup.getObject(hsqlName.name);
                                                                                        if (schemaObject16 == null) {
                                                                                            schemaObject16 = schema.procedureLookup.getObject(hsqlName.name);
                                                                                        }
                                                                                        schemaObject7 = schemaObject16;
                                                                                        break block29;
                                                                                    }
                                                                                    case 12: 
                                                                                    case 13: {
                                                                                        schemaObject6 = schema.typeLookup.getObject(hsqlName.name);
                                                                                        break block30;
                                                                                    }
                                                                                    case 8: {
                                                                                        hsqlName = schema.triggerLookup.getName(hsqlName.name);
                                                                                        if (hsqlName == null) {
                                                                                            schemaObject5 = null;
                                                                                            break block31;
                                                                                        }
                                                                                        HsqlNameManager.HsqlName hsqlName2 = hsqlName.parent;
                                                                                        Table table = (Table)schema.tableList.get(hsqlName2.name);
                                                                                        triggerDef = table.getTrigger(hsqlName.name);
                                                                                        break block32;
                                                                                    }
                                                                                    case 5: {
                                                                                        hsqlName = schema.constraintLookup.getName(hsqlName.name);
                                                                                        if (hsqlName == null) {
                                                                                            schemaObject4 = null;
                                                                                            break block33;
                                                                                        }
                                                                                        HsqlNameManager.HsqlName hsqlName3 = hsqlName.parent;
                                                                                        Table table = (Table)schema.tableList.get(hsqlName3.name);
                                                                                        constraint = table.getConstraint(hsqlName.name);
                                                                                        break block34;
                                                                                    }
                                                                                    case 6: {
                                                                                        schemaObject3 = null;
                                                                                        break block35;
                                                                                    }
                                                                                    case 20: {
                                                                                        hsqlName = schema.indexLookup.getName(hsqlName.name);
                                                                                        if (hsqlName == null) {
                                                                                            schemaObject2 = null;
                                                                                            break block36;
                                                                                        }
                                                                                        HsqlNameManager.HsqlName hsqlName4 = hsqlName.parent;
                                                                                        Table table = (Table)schema.tableList.get(hsqlName4.name);
                                                                                        index = table.getIndex(hsqlName.name);
                                                                                        break block37;
                                                                                    }
                                                                                    default: {
                                                                                        schemaObject = null;
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                break block38;
                                                                            }
                                                                            catch (Throwable throwable) {
                                                                                Object var8_31 = null;
                                                                                this.readLock.unlock();
                                                                                throw throwable;
                                                                            }
                                                                        }
                                                                        Object var8_14 = null;
                                                                        this.readLock.unlock();
                                                                        return schemaObject14;
                                                                    }
                                                                    Object var8_15 = null;
                                                                    this.readLock.unlock();
                                                                    return schemaObject13;
                                                                }
                                                                Object var8_16 = null;
                                                                this.readLock.unlock();
                                                                return schemaObject12;
                                                            }
                                                            Object var8_17 = null;
                                                            this.readLock.unlock();
                                                            return schemaObject11;
                                                        }
                                                        Object var8_18 = null;
                                                        this.readLock.unlock();
                                                        return schemaObject10;
                                                    }
                                                    Object var8_19 = null;
                                                    this.readLock.unlock();
                                                    return schemaObject9;
                                                }
                                                Object var8_20 = null;
                                                this.readLock.unlock();
                                                return schemaObject8;
                                            }
                                            Object var8_21 = null;
                                            this.readLock.unlock();
                                            return schemaObject7;
                                        }
                                        Object var8_22 = null;
                                        this.readLock.unlock();
                                        return schemaObject6;
                                    }
                                    Object var8_23 = null;
                                    this.readLock.unlock();
                                    return schemaObject5;
                                }
                                Object var8_24 = null;
                                this.readLock.unlock();
                                return triggerDef;
                            }
                            Object var8_25 = null;
                            this.readLock.unlock();
                            return schemaObject4;
                        }
                        Object var8_26 = null;
                        this.readLock.unlock();
                        return constraint;
                    }
                    Object var8_27 = null;
                    this.readLock.unlock();
                    return schemaObject3;
                }
                Object var8_28 = null;
                this.readLock.unlock();
                return schemaObject2;
            }
            Object var8_29 = null;
            this.readLock.unlock();
            return index;
        }
        Object var8_30 = null;
        this.readLock.unlock();
        return schemaObject;
    }

    public void checkColumnIsReferenced(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        OrderedHashSet orderedHashSet = this.getReferencingObjectNames(hsqlName, hsqlName2);
        if (!orderedHashSet.isEmpty()) {
            HsqlNameManager.HsqlName hsqlName3 = (HsqlNameManager.HsqlName)orderedHashSet.get(0);
            throw Error.error(5502, hsqlName3.getSchemaQualifiedStatementName());
        }
    }

    public void checkObjectIsReferenced(HsqlNameManager.HsqlName hsqlName) {
        OrderedHashSet orderedHashSet = this.getReferencingObjectNames(hsqlName);
        HsqlNameManager.HsqlName hsqlName2 = null;
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            hsqlName2 = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
            if (hsqlName2.parent != hsqlName) break;
            hsqlName2 = null;
        }
        if (hsqlName2 == null) {
            return;
        }
        throw Error.error(5502, hsqlName2.getSchemaQualifiedStatementName());
    }

    public void checkSchemaNameCanChange(HsqlNameManager.HsqlName hsqlName) {
        this.readLock.lock();
        try {
            Iterator iterator = this.referenceMap.values().iterator();
            HsqlNameManager.HsqlName hsqlName2 = null;
            block5: while (iterator.hasNext()) {
                hsqlName2 = (HsqlNameManager.HsqlName)iterator.next();
                switch (hsqlName2.type) {
                    case 4: 
                    case 8: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 24: {
                        if (hsqlName2.schema == hsqlName) break block5;
                    }
                    default: {
                        hsqlName2 = null;
                        continue block5;
                    }
                }
            }
            if (hsqlName2 == null) {
                Object var5_4 = null;
                this.readLock.unlock();
                return;
            }
            throw Error.error(5502, hsqlName2.getSchemaQualifiedStatementName());
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addSchemaObject(SchemaObject schemaObject) {
        block13: {
            block12: {
                this.writeLock.lock();
                try {
                    HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
                    Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
                    SchemaObjectSet schemaObjectSet = this.getSchemaObjectSet(schema, hsqlName.type);
                    switch (hsqlName.type) {
                        case 16: 
                        case 17: {
                            RoutineSchema routineSchema = (RoutineSchema)schemaObjectSet.getObject(hsqlName.name);
                            if (routineSchema == null) {
                                routineSchema = new RoutineSchema(hsqlName.type, hsqlName);
                                routineSchema.addSpecificRoutine(this.database, (Routine)schemaObject);
                                schemaObjectSet.checkAdd(hsqlName);
                                SchemaObjectSet schemaObjectSet2 = this.getSchemaObjectSet(schema, 24);
                                schemaObjectSet2.checkAdd(((Routine)schemaObject).getSpecificName());
                                schemaObjectSet.add(routineSchema);
                                schemaObjectSet2.add(schemaObject);
                            } else {
                                SchemaObjectSet schemaObjectSet3 = this.getSchemaObjectSet(schema, 24);
                                HsqlNameManager.HsqlName hsqlName2 = ((Routine)schemaObject).getSpecificName();
                                if (hsqlName2 != null) {
                                    schemaObjectSet3.checkAdd(hsqlName2);
                                }
                                routineSchema.addSpecificRoutine(this.database, (Routine)schemaObject);
                                schemaObjectSet3.add(schemaObject);
                            }
                            this.addReferences(schemaObject);
                            Object var11_12 = null;
                            this.writeLock.unlock();
                            return;
                        }
                        case 3: {
                            OrderedHashSet orderedHashSet = schemaObject.getReferences();
                            for (int i = 0; i < orderedHashSet.size(); ++i) {
                                HsqlNameManager.HsqlName hsqlName3 = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
                                if (hsqlName3.type != 9) continue;
                                int n = ((Table)schemaObject).findColumn(hsqlName3.name);
                                ColumnSchema columnSchema = ((Table)schemaObject).getColumn(n);
                                this.addSchemaObject(columnSchema);
                            }
                            break;
                        }
                        case 9: {
                            if (!schemaObject.getReferences().isEmpty()) break;
                            break block12;
                        }
                    }
                    if (schemaObjectSet != null) {
                        schemaObjectSet.add(schemaObject);
                    }
                    this.addReferences(schemaObject);
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    this.writeLock.unlock();
                    throw throwable;
                }
            }
            Object var11_13 = null;
            this.writeLock.unlock();
            return;
        }
        Object var11_14 = null;
        this.writeLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObject(HsqlNameManager.HsqlName hsqlName, boolean bl) {
        this.writeLock.lock();
        try {
            Object object;
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            switch (hsqlName.type) {
                case 16: 
                case 17: 
                case 18: {
                    object = (RoutineSchema)this.getSchemaObject(hsqlName);
                    if (object == null) break;
                    Routine[] routineArray = ((RoutineSchema)object).getSpecificRoutines();
                    for (int i = 0; i < routineArray.length; ++i) {
                        this.getCascadingReferencingObjectNames(routineArray[i].getSpecificName(), orderedHashSet);
                    }
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 12: 
                case 14: 
                case 15: 
                case 24: {
                    this.getCascadingReferencingObjectNames(hsqlName, orderedHashSet);
                    break;
                }
                case 13: {
                    HsqlNameManager.HsqlName hsqlName2;
                    object = this.getReferencingObjectNames(hsqlName);
                    Iterator iterator = ((HashSet)object).iterator();
                    while (iterator.hasNext()) {
                        hsqlName2 = (HsqlNameManager.HsqlName)iterator.next();
                        if (hsqlName2.type != 9) continue;
                        iterator.remove();
                    }
                    if (((BaseHashMap)object).isEmpty()) break;
                    hsqlName2 = (HsqlNameManager.HsqlName)((OrderedHashSet)object).get(0);
                    throw Error.error(5502, hsqlName2.getSchemaQualifiedStatementName());
                }
            }
            if (orderedHashSet.isEmpty()) {
                this.removeSchemaObject(hsqlName);
                Object var8_9 = null;
                this.writeLock.unlock();
                return;
            }
            if (!bl) {
                object = (HsqlNameManager.HsqlName)orderedHashSet.get(0);
                throw Error.error(5502, ((HsqlNameManager.HsqlName)object).getSchemaQualifiedStatementName());
            }
            orderedHashSet.add(hsqlName);
            this.removeSchemaObjects(orderedHashSet);
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        Object var8_10 = null;
        this.writeLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObjects(OrderedHashSet orderedHashSet) {
        this.writeLock.lock();
        try {
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
                this.removeSchemaObject(hsqlName);
            }
            Object var5_4 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObject(HsqlNameManager.HsqlName hsqlName) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
            SchemaObject schemaObject = null;
            SchemaObjectSet schemaObjectSet = null;
            switch (hsqlName.type) {
                case 7: {
                    schemaObjectSet = schema.sequenceLookup;
                    schemaObject = schemaObjectSet.getObject(hsqlName.name);
                    break;
                }
                case 3: 
                case 4: {
                    schemaObjectSet = schema.tableLookup;
                    schemaObject = schemaObjectSet.getObject(hsqlName.name);
                    break;
                }
                case 9: {
                    Table table = (Table)this.getSchemaObject(hsqlName.parent);
                    if (table == null) break;
                    schemaObject = table.getColumn(table.getColumnIndex(hsqlName.name));
                    break;
                }
                case 14: {
                    schemaObjectSet = schema.charsetLookup;
                    schemaObject = schemaObjectSet.getObject(hsqlName.name);
                    break;
                }
                case 15: {
                    schemaObjectSet = schema.collationLookup;
                    schemaObject = schemaObjectSet.getObject(hsqlName.name);
                    break;
                }
                case 17: {
                    schemaObjectSet = schema.procedureLookup;
                    RoutineSchema routineSchema = (RoutineSchema)schemaObjectSet.getObject(hsqlName.name);
                    schemaObject = routineSchema;
                    Routine[] routineArray = routineSchema.getSpecificRoutines();
                    for (int i = 0; i < routineArray.length; ++i) {
                        this.removeSchemaObject(routineArray[i].getSpecificName());
                    }
                    break;
                }
                case 16: {
                    schemaObjectSet = schema.functionLookup;
                    RoutineSchema routineSchema = (RoutineSchema)schemaObjectSet.getObject(hsqlName.name);
                    schemaObject = routineSchema;
                    Routine[] routineArray = routineSchema.getSpecificRoutines();
                    for (int i = 0; i < routineArray.length; ++i) {
                        this.removeSchemaObject(routineArray[i].getSpecificName());
                    }
                    break;
                }
                case 24: {
                    schemaObjectSet = schema.specificRoutineLookup;
                    Routine routine = (Routine)schemaObjectSet.getObject(hsqlName.name);
                    schemaObject = routine;
                    routine.routineSchema.removeSpecificRoutine(routine);
                    if (routine.routineSchema.getSpecificRoutines().length != 0) break;
                    this.removeSchemaObject(routine.getName());
                    break;
                }
                case 12: 
                case 13: {
                    schemaObjectSet = schema.typeLookup;
                    schemaObject = schemaObjectSet.getObject(hsqlName.name);
                    break;
                }
                case 20: {
                    schemaObjectSet = schema.indexLookup;
                    break;
                }
                case 5: {
                    schemaObjectSet = schema.constraintLookup;
                    if (hsqlName.parent.type == 3) {
                        Table table = (Table)schema.tableList.get(hsqlName.parent.name);
                        schemaObject = table.getConstraint(hsqlName.name);
                        table.removeConstraint(hsqlName.name);
                        break;
                    }
                    if (hsqlName.parent.type != 13) break;
                    Type type = (Type)schema.typeLookup.getObject(hsqlName.parent.name);
                    schemaObject = type.userTypeModifier.getConstraint(hsqlName.name);
                    type.userTypeModifier.removeConstraint(hsqlName.name);
                    break;
                }
                case 8: {
                    schemaObjectSet = schema.triggerLookup;
                    Table table = (Table)schema.tableList.get(hsqlName.parent.name);
                    schemaObject = table.getTrigger(hsqlName.name);
                    if (schemaObject == null) break;
                    table.removeTrigger((TriggerDef)schemaObject);
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "SchemaManager");
                }
            }
            if (schemaObject != null) {
                this.database.getGranteeManager().removeDbObject(hsqlName);
                this.removeReferencingObject(schemaObject);
            }
            if (schemaObjectSet != null) {
                schemaObjectSet.remove(hsqlName.name);
            }
            this.removeReferencedObject(hsqlName);
            Object var9_16 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var9_17 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameSchemaObject(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        this.writeLock.lock();
        try {
            if (hsqlName.schema != hsqlName2.schema) {
                throw Error.error(5505, hsqlName2.schema.name);
            }
            this.checkObjectIsReferenced(hsqlName);
            Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
            SchemaObjectSet schemaObjectSet = this.getSchemaObjectSet(schema, hsqlName.type);
            schemaObjectSet.rename(hsqlName, hsqlName2);
            Object var6_5 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceReferences(SchemaObject schemaObject, SchemaObject schemaObject2) {
        this.writeLock.lock();
        try {
            this.removeReferencingObject(schemaObject);
            this.addReferences(schemaObject2);
            Object var4_3 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSQLArray() {
        this.readLock.lock();
        try {
            Object[] objectArray;
            Object object;
            Object object2;
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            OrderedHashSet orderedHashSet2 = new OrderedHashSet();
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            Iterator iterator = this.schemaMap.values().iterator();
            iterator = this.schemaMap.values().iterator();
            while (iterator.hasNext()) {
                object2 = (Schema)iterator.next();
                if (SqlInvariants.isSystemSchemaName(((Schema)object2).getName().name) || SqlInvariants.isLobsSchemaName(((Schema)object2).getName().name)) continue;
                hsqlArrayList.add(((Schema)object2).getSQL());
                ((Schema)object2).addSimpleObjects(orderedHashSet2);
            }
            while ((object2 = orderedHashSet2.iterator()).hasNext()) {
                object = new OrderedHashSet();
                SchemaObjectSet.addAllSQL(orderedHashSet, orderedHashSet2, hsqlArrayList, (Iterator)object2, (OrderedHashSet)object);
                orderedHashSet2.removeAll((Collection)object);
                if (object.size() != 0) continue;
                break;
            }
            iterator = this.schemaMap.values().iterator();
            while (iterator.hasNext()) {
                object2 = (Schema)iterator.next();
                if (SqlInvariants.isLobsSchemaName(((Schema)object2).getName().name) || SqlInvariants.isSystemSchemaName(((Schema)object2).getName().name)) continue;
                hsqlArrayList.addAll(((Schema)object2).getSQLArray(orderedHashSet, orderedHashSet2));
            }
            while ((object2 = orderedHashSet2.iterator()).hasNext()) {
                object = new OrderedHashSet();
                SchemaObjectSet.addAllSQL(orderedHashSet, orderedHashSet2, hsqlArrayList, (Iterator)object2, (OrderedHashSet)object);
                orderedHashSet2.removeAll((Collection)object);
                if (object.size() != 0) continue;
                break;
            }
            object2 = orderedHashSet2.iterator();
            while (object2.hasNext()) {
                object = (SchemaObject)object2.next();
                if (!(object instanceof Routine)) continue;
                hsqlArrayList.add(((Routine)object).getSQLDeclaration());
            }
            object2 = orderedHashSet2.iterator();
            while (object2.hasNext()) {
                object = (SchemaObject)object2.next();
                if (object instanceof Routine) {
                    hsqlArrayList.add(((Routine)object).getSQLAlter());
                    continue;
                }
                hsqlArrayList.add(object.getSQL());
            }
            iterator = this.schemaMap.values().iterator();
            while (iterator.hasNext()) {
                object = (Schema)iterator.next();
                if (SqlInvariants.isLobsSchemaName(object.getName().name) || SqlInvariants.isSystemSchemaName(object.getName().name) || (objectArray = object.getTriggerSQL()).length <= 0) continue;
                hsqlArrayList.add(Schema.getSetSchemaSQL(object.getName()));
                hsqlArrayList.addAll(objectArray);
            }
            iterator = this.schemaMap.values().iterator();
            while (iterator.hasNext()) {
                object = (Schema)iterator.next();
                hsqlArrayList.addAll(object.getSequenceRestartSQL());
            }
            if (this.defaultSchemaHsqlName != null) {
                object = new StringBuffer();
                object.append("SET").append(' ').append("DATABASE");
                object.append(' ').append("DEFAULT").append(' ');
                object.append("INITIAL").append(' ').append("SCHEMA");
                object.append(' ').append(this.defaultSchemaHsqlName.statementName);
                hsqlArrayList.add(object.toString());
            }
            object = new String[hsqlArrayList.size()];
            hsqlArrayList.toArray(object);
            objectArray = object;
            Object var9_8 = null;
            this.readLock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTablePropsSQL(boolean bl) {
        this.readLock.lock();
        try {
            String[] stringArray;
            HsqlArrayList hsqlArrayList = this.getAllTables(false);
            HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
            for (int i = 0; i < hsqlArrayList.size(); ++i) {
                Object object;
                stringArray = (String[])hsqlArrayList.get(i);
                if (stringArray.isText()) {
                    object = stringArray.getSQLForTextSource(bl);
                    hsqlArrayList2.addAll((Object[])object);
                }
                if ((object = stringArray.getSQLForReadOnly()) != null) {
                    hsqlArrayList2.add(object);
                }
                if (!stringArray.isCached() || (object = stringArray.getSQLForClustered()) == null) continue;
                hsqlArrayList2.add(object);
            }
            String[] stringArray2 = new String[hsqlArrayList2.size()];
            hsqlArrayList2.toArray(stringArray2);
            stringArray = stringArray2;
            Object var8_8 = null;
            this.readLock.unlock();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getIndexRootsSQL() {
        this.readLock.lock();
        try {
            String[] stringArray;
            Session session = this.database.sessionManager.getSysSession();
            int[][] nArray = this.getIndexRoots(session);
            HsqlArrayList hsqlArrayList = this.getAllTables(true);
            HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
            for (int i = 0; i < nArray.length; ++i) {
                stringArray = (String[])hsqlArrayList.get(i);
                if (nArray[i] == null || nArray[i].length <= 0 || nArray[i][0] == -1) continue;
                String string = ((Table)hsqlArrayList.get(i)).getIndexRootsSQL(nArray[i]);
                hsqlArrayList2.add(string);
            }
            String[] stringArray2 = new String[hsqlArrayList2.size()];
            hsqlArrayList2.toArray(stringArray2);
            stringArray = stringArray2;
            Object var9_9 = null;
            this.readLock.unlock();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCommentsArray() {
        this.readLock.lock();
        try {
            Object object;
            HsqlArrayList hsqlArrayList = this.getAllTables(false);
            HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < hsqlArrayList.size(); ++i) {
                object = (Table)hsqlArrayList.get(i);
                if (object.getTableType() == 1) continue;
                int n = object.getColumnCount();
                for (int j = 0; j < n; ++j) {
                    ColumnSchema columnSchema = object.getColumn(j);
                    if (columnSchema.getName().comment == null) continue;
                    stringBuffer.setLength(0);
                    stringBuffer.append("COMMENT").append(' ').append("ON");
                    stringBuffer.append(' ').append("COLUMN").append(' ');
                    stringBuffer.append(object.getName().getSchemaQualifiedStatementName());
                    stringBuffer.append('.').append(columnSchema.getName().statementName);
                    stringBuffer.append(' ').append("IS").append(' ');
                    stringBuffer.append(StringConverter.toQuotedString(columnSchema.getName().comment, '\'', true));
                    hsqlArrayList2.add(stringBuffer.toString());
                }
                if (object.getName().comment == null) continue;
                stringBuffer.setLength(0);
                stringBuffer.append("COMMENT").append(' ').append("ON");
                stringBuffer.append(' ').append("TABLE").append(' ');
                stringBuffer.append(object.getName().getSchemaQualifiedStatementName());
                stringBuffer.append(' ').append("IS").append(' ');
                stringBuffer.append(StringConverter.toQuotedString(object.getName().comment, '\'', true));
                hsqlArrayList2.add(stringBuffer.toString());
            }
            Iterator iterator = this.databaseObjectIterator(18);
            while (iterator.hasNext()) {
                object = (SchemaObject)iterator.next();
                if (object.getName().comment == null) continue;
                stringBuffer.setLength(0);
                stringBuffer.append("COMMENT").append(' ').append("ON");
                stringBuffer.append(' ').append("ROUTINE").append(' ');
                stringBuffer.append(object.getName().getSchemaQualifiedStatementName());
                stringBuffer.append(' ').append("IS").append(' ');
                stringBuffer.append(StringConverter.toQuotedString(object.getName().comment, '\'', true));
                hsqlArrayList2.add(stringBuffer.toString());
            }
            object = new String[hsqlArrayList2.size()];
            hsqlArrayList2.toArray(object);
            String[] stringArray = object;
            Object var10_11 = null;
            this.readLock.unlock();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    public void setTempIndexRoots(int[][] nArray) {
        this.tempIndexRoots = nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[][] getIndexRoots(Session session) {
        block5: {
            this.readLock.lock();
            if (this.tempIndexRoots == null) break block5;
            int[][] nArray = this.tempIndexRoots;
            this.tempIndexRoots = null;
            int[][] nArray2 = nArray;
            Object var9_6 = null;
            this.readLock.unlock();
            return nArray2;
        }
        try {
            HsqlArrayList hsqlArrayList = this.getAllTables(true);
            HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
            int n = hsqlArrayList.size();
            for (int i = 0; i < n; ++i) {
                Table table = (Table)hsqlArrayList.get(i);
                if (table.getTableType() == 5) {
                    int[] nArray = table.getIndexRootsArray();
                    hsqlArrayList2.add(nArray);
                    continue;
                }
                hsqlArrayList2.add(null);
            }
            int[][] nArrayArray = new int[hsqlArrayList2.size()][];
            hsqlArrayList2.toArray(nArrayArray);
            int[][] nArrayArray2 = nArrayArray;
            Object var9_7 = null;
            this.readLock.unlock();
            return nArrayArray2;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndexRoots(int[][] nArray) {
        this.readLock.lock();
        try {
            HsqlArrayList hsqlArrayList = this.database.schemaManager.getAllTables(true);
            int n = hsqlArrayList.size();
            for (int i = 0; i < n; ++i) {
                Table table = (Table)hsqlArrayList.get(i);
                if (table.getTableType() != 5) continue;
                int[] nArray2 = nArray[i];
                if (nArray == null) continue;
                table.setIndexRoots(nArray2);
            }
            Object var8_7 = null;
            this.readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    public void setDefaultTableType(int n) {
        this.defaultTableType = n;
    }

    public int getDefaultTableType() {
        return this.defaultTableType;
    }

    public void createSystemTables() {
        this.dualTable = TableUtil.newLookupTable(this.database, SqlInvariants.DUAL_TABLE_HSQLNAME, 12, SqlInvariants.DUAL_COLUMN_HSQLNAME, Type.SQL_VARCHAR);
        this.dualTable.insertSys(this.database.sessionManager.getSysSession(), this.dualTable.getRowStore(null), new Object[]{"X"});
        this.dualTable.setDataReadOnly(true);
    }
}

