/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.OrderBy;
import org.hibernate.annotations.Sort;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.annotations.AbstractCollectionBinder;
import org.hibernate.cfg.annotations.SimpleValueBinder;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IndexBackref;
import org.hibernate.mapping.List;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;

public class ListBinder
extends AbstractCollectionBinder {
    private static Log log = LogFactory.getLog(ListBinder.class);

    protected Collection createCollection(PersistentClass persistentClass) {
        return new List(persistentClass);
    }

    public void setOrderBy(OrderBy orderByAnn) {
        if (orderByAnn != null) {
            log.warn((Object)"@OrderBy not allowed for a indexed collection, annotation ignored.");
        }
    }

    public void setSort(Sort sortAnn) {
        if (sortAnn != null) {
            log.warn((Object)"@Sort not allowed for a indexed collection, annotation ignored.");
        }
    }

    public SecondPass getSecondPass(final ExtendedMappings mappings, final Ejb3JoinColumn[] keyColumns, final Ejb3JoinColumn[] inverseColumns, final String collType, final FetchMode fetchMode, final boolean unique) {
        if (inverseColumns != null) {
            return new SecondPass(mappings, this.collection){

                public void secondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
                    AbstractCollectionBinder.bindManyToManySecondPass(ListBinder.this.collection, persistentClasses, keyColumns, inverseColumns, collType, fetchMode, unique, mappings);
                    ListBinder.this.bindIndex(mappings);
                }
            };
        }
        return new SecondPass(mappings, this.collection){

            public void secondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
                AbstractCollectionBinder.bindCollectionSecondPass(ListBinder.this.collection, persistentClasses, keyColumns, mappings);
                ListBinder.this.bindIndex(mappings);
            }
        };
    }

    private void bindIndex(ExtendedMappings mappings) {
        if (!this.indexColumn.isImplicit()) {
            PropertyHolder valueHolder = PropertyHolderBuilder.buildPropertyHolder(this.collection, "idx");
            List list = (List)this.collection;
            if (!list.isOneToMany()) {
                this.indexColumn.forceNotNull();
            }
            this.indexColumn.setPropertyHolder(valueHolder);
            SimpleValueBinder value = new SimpleValueBinder();
            value.setColumns(new Ejb3Column[]{this.indexColumn});
            value.setExplicitType("integer");
            value.setMappings(mappings);
            SimpleValue indexValue = value.make();
            this.indexColumn.linkWithValue(indexValue);
            list.setIndex((Value)indexValue);
            list.setBaseIndex(this.indexColumn.getBase());
            if (list.isOneToMany() && !list.getKey().isNullable() && !list.isInverse()) {
                String entityName = ((OneToMany)list.getElement()).getReferencedEntityName();
                PersistentClass referenced = mappings.getClass(entityName);
                IndexBackref ib = new IndexBackref();
                ib.setName('_' + this.propertyName + "IndexBackref");
                ib.setUpdateable(false);
                ib.setSelectable(false);
                ib.setCollectionRole(list.getRole());
                ib.setValue(list.getIndex());
                referenced.addProperty((Property)ib);
            }
        } else {
            Collection coll = this.collection;
            throw new AnnotationException("List/array has to be annotated with an @IndexColumn: " + coll.getRole());
        }
    }
}

