/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.persistence.AccessType;
import javax.persistence.AssociationTable;
import javax.persistence.AttributeOverride;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedIdTable;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceJoinColumn;
import javax.persistence.InheritanceJoinColumns;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.LobType;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SequenceGenerator;
import javax.persistence.Serialized;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.OrderBy;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.annotations.Where;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.AnnotedElementInferredData;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3DiscriminatorColumn;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.FkSecondPass;
import org.hibernate.cfg.IndexColumn;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.annotations.AbstractCollectionBinder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.PropertyBinder;
import org.hibernate.cfg.annotations.QueryBinder;
import org.hibernate.cfg.annotations.SimpleValueBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.id.MultipleHiLoPerTableGenerator;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.mapping.Value;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;
import org.hibernate.type.ByteArrayBlobType;
import org.hibernate.type.CharacterArrayClobType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.PrimitiveByteArrayBlobType;
import org.hibernate.type.PrimitiveCharacterArrayClobType;
import org.hibernate.type.StringClobType;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.hibernate.validator.ClassValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationBinder {
    private static final String GENERATOR_TABLE_NAME_PARAM = "generatorTableName";
    public static final String ANNOTATION_STRING_DEFAULT = "";
    private static final Log log = LogFactory.getLog(AnnotationBinder.class);

    private AnnotationBinder() {
    }

    public static void bindPackage(String packageName, ExtendedMappings mappings) {
        IdGenerator idGen;
        SequenceGenerator ann;
        Package pckg = null;
        try {
            pckg = ReflectHelper.classForName((String)(packageName + ".package-info")).getPackage();
        }
        catch (ClassNotFoundException cnf) {
            log.warn((Object)("Package not found or wo package-info.java: " + packageName));
            return;
        }
        if (pckg.isAnnotationPresent(SequenceGenerator.class)) {
            ann = pckg.getAnnotation(SequenceGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator((Annotation)ann);
            mappings.addGenerator(idGen);
            log.debug((Object)("Add sequence generator with name: " + idGen.getName()));
        }
        if (pckg.isAnnotationPresent(TableGenerator.class)) {
            ann = pckg.getAnnotation(TableGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator((Annotation)ann);
            mappings.addGenerator(idGen);
            log.debug((Object)("Add table generator with name: " + idGen.getName()));
        }
        if (pckg.isAnnotationPresent(GeneratedIdTable.class)) {
            ann = pckg.getAnnotation(GeneratedIdTable.class);
            Properties params = AnnotationBinder.buildPropertiesFromGeneratorTable((GeneratedIdTable)ann);
            mappings.addGeneratorTable(ann.name(), params);
        }
        AnnotationBinder.bindQueries(pckg, mappings);
        AnnotationBinder.bindFilterDefs(pckg, mappings);
        AnnotationBinder.bindTypeDefs(pckg, mappings);
    }

    private static void bindQueries(AnnotatedElement annotatedElement, ExtendedMappings mappings) {
        SqlResultSetMapping ann = annotatedElement.getAnnotation(SqlResultSetMapping.class);
        QueryBinder.bindSqlResultsetMapping(ann, mappings);
        ann = annotatedElement.getAnnotation(NamedQuery.class);
        QueryBinder.bindQuery((NamedQuery)ann, mappings);
        ann = annotatedElement.getAnnotation(NamedQueries.class);
        QueryBinder.bindQueries((NamedQueries)ann, mappings);
    }

    private static Properties buildPropertiesFromGeneratorTable(GeneratedIdTable ann) {
        Properties params = new Properties();
        if (!AnnotationBinder.isDefault(ann.pkColumnName())) {
            params.setProperty("primary_key_column", ann.pkColumnName());
        }
        if (!AnnotationBinder.isDefault(ann.valueColumnName())) {
            params.setProperty("value_column", ann.valueColumnName());
        }
        if (ann.table().specified()) {
            Table table = ann.table();
            if (!AnnotationBinder.isDefault(table.name())) {
                params.setProperty("table", table.name());
            }
            if (!AnnotationBinder.isDefault(table.catalog())) {
                params.setProperty("catalog", table.catalog());
            }
            if (!AnnotationBinder.isDefault(table.schema())) {
                params.setProperty("schema", table.schema());
            }
        } else {
            params.setProperty("table", ann.name());
        }
        return params;
    }

    private static IdGenerator buildIdGenerator(Annotation ann) {
        IdGenerator idGen = new IdGenerator();
        if (ann == null) {
            idGen = null;
        } else if (ann instanceof TableGenerator) {
            TableGenerator tabGen = (TableGenerator)ann;
            idGen.setName(tabGen.name());
            idGen.setIdentifierGeneratorStrategy(MultipleHiLoPerTableGenerator.class.getName());
            if (!AnnotationBinder.isDefault(tabGen.tableName())) {
                idGen.addParam(GENERATOR_TABLE_NAME_PARAM, tabGen.tableName());
            }
            if (!AnnotationBinder.isDefault(tabGen.pkColumnValue())) {
                idGen.addParam("primary_key_value", tabGen.pkColumnValue());
            }
            idGen.addParam("max_lo", String.valueOf(tabGen.allocationSize()));
        } else if (ann instanceof SequenceGenerator) {
            SequenceGenerator seqGen = (SequenceGenerator)ann;
            idGen.setName(seqGen.name());
            idGen.setIdentifierGeneratorStrategy("sequence");
            if (!AnnotationBinder.isDefault(seqGen.sequenceName())) {
                idGen.addParam("sequence", seqGen.sequenceName());
            }
            if (seqGen.initialValue() != 0 || seqGen.allocationSize() != 50) {
                log.warn((Object)"Hibernate does not support SequenceGenerator.initialValue() nor SequenceGenerator.allocationSize()");
            }
        } else {
            throw new AssertionFailure("Unknown Generator annotation: " + ann);
        }
        return idGen;
    }

    public static void bindClass(Class annotatedClass, InheritanceState inheritanceState, ExtendedMappings mappings) throws MappingException {
        Filters filtersAnn;
        RootClass persistentClass;
        boolean hasJoinedColumns;
        if (!mappings.getClassType(annotatedClass).equals((Object)AnnotatedClassType.ENTITY)) {
            throw new AnnotationException("Annotated class should have an @Entity annotation: " + annotatedClass.getName());
        }
        AnnotationBinder.bindQueries(annotatedClass, mappings);
        AnnotationBinder.bindFilterDefs(annotatedClass, mappings);
        AnnotationBinder.bindTypeDefs(annotatedClass, mappings);
        Class superClass = annotatedClass.getSuperclass();
        PersistentClass superEntity = mappings.getClass(superClass.getName());
        if (superEntity == null && mappings.getClassType(superClass).equals((Object)AnnotatedClassType.ENTITY)) {
            throw new AnnotationException("Subclass has to be binded after it's mother class: " + superClass.getName());
        }
        String schema = ANNOTATION_STRING_DEFAULT;
        String table = ANNOTATION_STRING_DEFAULT;
        String catalog = ANNOTATION_STRING_DEFAULT;
        String discrimValue = null;
        ArrayList<String[]> uniqueConstraints = new ArrayList<String[]>();
        Ejb3DiscriminatorColumn discriminatorColumn = null;
        Ejb3JoinColumn[] inheritanceJoinedColumns = null;
        if (annotatedClass.isAnnotationPresent(Table.class)) {
            Table tabAnn = annotatedClass.getAnnotation(Table.class);
            table = tabAnn.name();
            schema = tabAnn.schema();
            catalog = tabAnn.catalog();
            if (tabAnn.uniqueConstraints().length != 0) {
                for (UniqueConstraint uc : tabAnn.uniqueConstraints()) {
                    if (!uc.primary()) {
                        uniqueConstraints.add(uc.columnNames());
                        continue;
                    }
                    log.warn((Object)"@UniqueConstraint(primaryKey=true) not yet supported");
                }
            }
        }
        boolean bl = hasJoinedColumns = InheritanceType.JOINED.equals((Object)inheritanceState.type) && inheritanceState.hasParents;
        if (hasJoinedColumns) {
            boolean explicitInheritanceJoinedColumns;
            InheritanceJoinColumns jcsAnn = annotatedClass.getAnnotation(InheritanceJoinColumns.class);
            boolean bl2 = explicitInheritanceJoinedColumns = jcsAnn != null && jcsAnn.value().length != 0;
            if (explicitInheritanceJoinedColumns) {
                int nbrOfInhJoinedColumns = jcsAnn.value().length;
                inheritanceJoinedColumns = new Ejb3JoinColumn[nbrOfInhJoinedColumns];
                for (int colIndex = 0; colIndex < nbrOfInhJoinedColumns; ++colIndex) {
                    InheritanceJoinColumn jcAnn = jcsAnn.value()[colIndex];
                    inheritanceJoinedColumns[colIndex] = Ejb3JoinColumn.buildJoinColumn(jcAnn, (Value)superEntity.getIdentifier(), (Map<String, Join>)null, (PropertyHolder)null, mappings);
                }
            } else {
                InheritanceJoinColumn jcAnn = annotatedClass.getAnnotation(InheritanceJoinColumn.class);
                inheritanceJoinedColumns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn(jcAnn, (Value)superEntity.getIdentifier(), (Map<String, Join>)null, (PropertyHolder)null, mappings)};
            }
            log.debug((Object)"Joined column(s) created");
        } else if (annotatedClass.isAnnotationPresent(InheritanceJoinColumns.class) || annotatedClass.isAnnotationPresent(InheritanceJoinColumn.class)) {
            log.warn((Object)"Root entity should not hold an InheritanceJoinColum(s), will be ignored");
        }
        if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.type)) {
            Inheritance inhAnn = annotatedClass.getAnnotation(Inheritance.class);
            DiscriminatorType discriminatorType = inhAnn == null ? DiscriminatorType.STRING : inhAnn.discriminatorType();
            DiscriminatorColumn discAnn = annotatedClass.getAnnotation(DiscriminatorColumn.class);
            if (!inheritanceState.hasParents) {
                discriminatorColumn = Ejb3DiscriminatorColumn.buildDiscriminatorColumn(discriminatorType, discAnn, mappings);
            }
            if (discAnn != null && inheritanceState.hasParents) {
                log.warn((Object)("Discriminator column has to be defined in the root entity, it will be ignored in subclass: " + annotatedClass.getName()));
            }
            String string = discrimValue = inhAnn == null ? null : inhAnn.discriminatorValue();
        }
        if (!inheritanceState.hasParents) {
            persistentClass = new RootClass();
        } else if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.type)) {
            persistentClass = new Subclass(superEntity);
        } else if (InheritanceType.JOINED.equals((Object)inheritanceState.type)) {
            persistentClass = new JoinedSubclass(superEntity);
        } else if (InheritanceType.TABLE_PER_CLASS.equals((Object)inheritanceState.type)) {
            persistentClass = new UnionSubclass(superEntity);
        } else {
            throw new AssertionFailure("Unknown inheritance type: " + inheritanceState.type);
        }
        Proxy proxyAnn = annotatedClass.getAnnotation(Proxy.class);
        BatchSize sizeAnn = annotatedClass.getAnnotation(BatchSize.class);
        Where whereAnn = annotatedClass.getAnnotation(Where.class);
        Entity entityAnn = annotatedClass.getAnnotation(Entity.class);
        org.hibernate.annotations.Entity hibEntityAnn = annotatedClass.getAnnotation(org.hibernate.annotations.Entity.class);
        Cache cacheAnn = annotatedClass.getAnnotation(Cache.class);
        EntityBinder entityBinder = new EntityBinder(entityAnn, hibEntityAnn, annotatedClass, (PersistentClass)persistentClass, mappings);
        entityBinder.setDiscriminatorValue(discrimValue);
        entityBinder.setBatchSize(sizeAnn);
        entityBinder.setProxy(proxyAnn);
        entityBinder.setWhere(whereAnn);
        entityBinder.setCache(cacheAnn);
        Filter filterAnn = annotatedClass.getAnnotation(Filter.class);
        if (filterAnn != null) {
            entityBinder.addFilter(filterAnn.name(), filterAnn.condition());
        }
        if ((filtersAnn = annotatedClass.getAnnotation(Filters.class)) != null) {
            for (Filter filter : filtersAnn.value()) {
                entityBinder.addFilter(filter.name(), filter.condition());
            }
        }
        entityBinder.bindEntity();
        if (inheritanceState.hasTable()) {
            Check checkAnn = annotatedClass.getAnnotation(Check.class);
            String constraints = checkAnn == null ? null : checkAnn.constraints();
            entityBinder.bindTable(schema, catalog, table, uniqueConstraints, constraints, inheritanceState.hasDenormalizedTable() ? superEntity.getTable() : null);
        }
        PropertyHolder propertyHolder = PropertyHolderBuilder.buildPropertyHolder((PersistentClass)persistentClass);
        SecondaryTable secTabAnn = annotatedClass.getAnnotation(SecondaryTable.class);
        SecondaryTables secTabsAnn = annotatedClass.getAnnotation(SecondaryTables.class);
        JoinColumn joinColAnn = annotatedClass.getAnnotation(JoinColumn.class);
        JoinColumns joinColsAnn = annotatedClass.getAnnotation(JoinColumns.class);
        entityBinder.firstLevelSecondaryTablesBinding(secTabAnn, secTabsAnn, joinColAnn, joinColsAnn);
        if (InheritanceType.JOINED.equals((Object)inheritanceState.type) && inheritanceState.hasParents) {
            JoinedSubclass jsc = (JoinedSubclass)persistentClass;
            if (persistentClass.getEntityPersisterClass() == null) {
                persistentClass.getRootClass().setEntityPersisterClass(JoinedSubclassEntityPersister.class);
            }
            DependantValue key = new DependantValue(jsc.getTable(), jsc.getIdentifier());
            jsc.setKey((KeyValue)key);
            key.setCascadeDeleteEnabled(false);
            TableBinder.bindFk((PersistentClass)jsc, null, inheritanceJoinedColumns, (SimpleValue)key, false);
            jsc.createPrimaryKey();
            jsc.createForeignKey();
        } else if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.type)) {
            if (inheritanceState.hasParents) {
                if (persistentClass.getEntityPersisterClass() == null) {
                    persistentClass.getRootClass().setEntityPersisterClass(SingleTableEntityPersister.class);
                }
            } else if (inheritanceState.hasSons || !discriminatorColumn.isImplicit()) {
                AnnotationBinder.bindDiscriminatorToPersistentClass(persistentClass, discriminatorColumn, entityBinder.getSecondaryTables(), propertyHolder);
            }
        } else if (InheritanceType.TABLE_PER_CLASS.equals((Object)inheritanceState.type) && inheritanceState.hasParents && persistentClass.getEntityPersisterClass() == null) {
            persistentClass.getRootClass().setEntityPersisterClass(UnionSubclassEntityPersister.class);
        }
        HashMap<String, IdGenerator> classGenerators = AnnotationBinder.buildLocalGenerators(annotatedClass);
        HashMap<String, Properties> classGeneratorTables = AnnotationBinder.buildLocalGeneratorTable(annotatedClass);
        if (annotatedClass.isAnnotationPresent(IdClass.class)) {
            throw new NotYetImplementedException("@IdClass is not yet implemented");
        }
        Class currentClassInHierarchy = annotatedClass;
        do {
            AnnotationBinder.processElementsOfAClass(propertyHolder, entityBinder.isPropertyAccess(), true, currentClassInHierarchy, classGenerators, classGeneratorTables, entityBinder, mappings);
            currentClassInHierarchy = currentClassInHierarchy.getSuperclass();
        } while (!inheritanceState.hasParents && !Object.class.equals(currentClassInHierarchy));
        if (!inheritanceState.hasParents) {
            persistentClass.createPrimaryKey();
        } else {
            superEntity.addSubclass((Subclass)persistentClass);
        }
        mappings.addClass((PersistentClass)persistentClass);
        entityBinder.finalSecondaryTableBinding(propertyHolder);
        ResourceBundle rb = null;
        new ClassValidator(annotatedClass, rb).apply((PersistentClass)persistentClass);
    }

    private static void bindFilterDefs(AnnotatedElement annotatedElement, ExtendedMappings mappings) {
        FilterDef defAnn = annotatedElement.getAnnotation(FilterDef.class);
        FilterDefs defsAnn = annotatedElement.getAnnotation(FilterDefs.class);
        if (defAnn != null) {
            AnnotationBinder.bindFilterDef(defAnn, mappings);
        }
        if (defsAnn != null) {
            for (FilterDef def : defsAnn.value()) {
                AnnotationBinder.bindFilterDef(def, mappings);
            }
        }
    }

    private static void bindFilterDef(FilterDef defAnn, ExtendedMappings mappings) {
        FilterDefinition def = new FilterDefinition(defAnn.name());
        for (ParamDef param : defAnn.parameters()) {
            TypeFactory.heuristicType((String)param.type());
            def.addParameterType(param.name(), TypeFactory.heuristicType((String)param.type()));
        }
        mappings.addFilterDefinition(def);
    }

    private static void bindTypeDefs(AnnotatedElement annotatedElement, ExtendedMappings mappings) {
        TypeDef defAnn = annotatedElement.getAnnotation(TypeDef.class);
        TypeDefs defsAnn = annotatedElement.getAnnotation(TypeDefs.class);
        if (defAnn != null) {
            AnnotationBinder.bindTypeDef(defAnn, mappings);
        }
        if (defsAnn != null) {
            for (TypeDef def : defsAnn.value()) {
                AnnotationBinder.bindTypeDef(def, mappings);
            }
        }
    }

    private static void bindTypeDef(TypeDef defAnn, ExtendedMappings mappings) {
        Properties params = new Properties();
        for (Parameter param : defAnn.parameters()) {
            params.setProperty(param.name(), param.value());
        }
        mappings.addTypeDef(defAnn.name(), defAnn.typeClass().getName(), params);
    }

    private static HashMap<String, Properties> buildLocalGeneratorTable(AnnotatedElement annotatedClass) {
        HashMap<String, Properties> result = new HashMap<String, Properties>();
        GeneratedIdTable ann = annotatedClass.getAnnotation(GeneratedIdTable.class);
        if (ann != null) {
            result.put(ann.name(), AnnotationBinder.buildPropertiesFromGeneratorTable(ann));
        }
        return result;
    }

    private static void bindDiscriminatorToPersistentClass(RootClass rootClass, Ejb3DiscriminatorColumn discriminatorColumn, Map<String, Join> secondaryTables, PropertyHolder propertyHolder) {
        if (rootClass.getDiscriminator() == null) {
            if (discriminatorColumn == null) {
                throw new AssertionFailure("discriminator column should have been built");
            }
            discriminatorColumn.setJoins(secondaryTables);
            discriminatorColumn.setPropertyHolder(propertyHolder);
            SimpleValue discrim = new SimpleValue(rootClass.getTable());
            rootClass.setDiscriminator((Value)discrim);
            Column col = discriminatorColumn.getMappingColumn();
            col.setValue((Value)discrim);
            discrim.getTable().addColumn(col);
            discrim.addColumn(col);
            discrim.setTypeName(discriminatorColumn.getDiscriminatorTypeName());
            rootClass.setPolymorphic(true);
            log.debug((Object)("Setting discriminator for entity " + rootClass.getEntityName()));
        }
    }

    private static void processElementsOfAClass(PropertyHolder propertyHolder, boolean propertyAccess, boolean isNullable, Class annotatedClass, HashMap<String, IdGenerator> classGenerators, HashMap<String, Properties> classGeneratorTables, EntityBinder entityBinder, ExtendedMappings mappings) {
        AccessibleObject currentElt;
        int index;
        ArrayList<AnnotatedElement> annElts = new ArrayList<AnnotatedElement>();
        ArrayList<AnnotedElementInferredData> inferredDatas = new ArrayList<AnnotedElementInferredData>();
        if (propertyAccess) {
            log.debug((Object)("Processing " + propertyHolder.getEntityName() + " per property access"));
            Method[] methods = annotatedClass.getDeclaredMethods();
            for (index = 0; index < methods.length; ++index) {
                currentElt = methods[index];
                AnnotationBinder.addAnnotatedElement(currentElt, annElts, inferredDatas);
            }
        } else {
            log.debug((Object)("Processing " + propertyHolder.getEntityName() + " per field access"));
            Field[] fields = annotatedClass.getDeclaredFields();
            for (index = 0; index < fields.length; ++index) {
                currentElt = fields[index];
                AnnotationBinder.addAnnotatedElement(currentElt, annElts, inferredDatas);
            }
        }
        int size = annElts.size();
        for (int index2 = 0; index2 < size; ++index2) {
            AnnotationBinder.processElementAnnotations(propertyHolder, isNullable, annElts.get(index2), mappings, inferredDatas.get(index2), classGenerators, classGeneratorTables, entityBinder);
        }
    }

    private static void addAnnotatedElement(AnnotatedElement elt, ArrayList<AnnotatedElement> annElts, ArrayList<AnnotedElementInferredData> inferredDatas) {
        AnnotedElementInferredData inferredData = new AnnotedElementInferredData(elt);
        if (!inferredData.skip()) {
            if (elt.isAnnotationPresent(Id.class) || elt.isAnnotationPresent(EmbeddedId.class)) {
                annElts.add(0, elt);
                inferredDatas.add(0, inferredData);
            } else {
                annElts.add(elt);
                inferredDatas.add(inferredData);
            }
        }
    }

    private static void processElementAnnotations(PropertyHolder propertyHolder, boolean isNullable, AnnotatedElement annotedElt, ExtendedMappings mappings, AnnotedElementInferredData inferredData, HashMap<String, IdGenerator> classGenerators, HashMap<String, Properties> classGeneratorTables, EntityBinder entityBinder) throws MappingException {
        Cascade hibernateCascade;
        javax.persistence.Column ann;
        Ejb3Column[] columns = null;
        if (annotedElt.isAnnotationPresent(Transient.class)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing annotations of " + propertyHolder.getEntityName() + "." + inferredData.getPropertyName()));
        }
        if (annotedElt.isAnnotationPresent(javax.persistence.Column.class)) {
            ann = annotedElt.getAnnotation(javax.persistence.Column.class);
            columns = Ejb3Column.buildColumnFromAnnotation(new javax.persistence.Column[]{ann}, propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings);
        } else if (annotedElt.isAnnotationPresent(Columns.class)) {
            Columns anns = annotedElt.getAnnotation(Columns.class);
            columns = Ejb3Column.buildColumnFromAnnotation(anns.columns(), propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings);
        } else if (annotedElt.isAnnotationPresent(JoinColumn.class)) {
            ann = annotedElt.getAnnotation(JoinColumn.class);
            columns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn((JoinColumn)ann, null, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings)};
        } else if (annotedElt.isAnnotationPresent(JoinColumns.class)) {
            ann = annotedElt.getAnnotation(JoinColumns.class);
            JoinColumn[] annColumns = ann.value();
            int length = annColumns.length;
            if (length == 0) {
                throw new AnnotationException("Cannot bind an empty @JoinColumns");
            }
            columns = new Ejb3JoinColumn[length];
            for (int index = 0; index < length; ++index) {
                columns[index] = Ejb3JoinColumn.buildJoinColumn(annColumns[index], null, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings);
            }
        } else if (annotedElt.isAnnotationPresent(javax.persistence.ManyToOne.class) || annotedElt.isAnnotationPresent(OneToOne.class)) {
            columns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildImplicitJoinColumn(null, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings)};
        } else if (annotedElt.isAnnotationPresent(OneToMany.class)) {
            columns = new Ejb3JoinColumn[1];
            String mappedBy = annotedElt.getAnnotation(OneToMany.class).mappedBy();
            columns[0] = Ejb3JoinColumn.buildImplicitJoinColumn(mappedBy, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings);
        } else {
            columns = Ejb3Column.buildColumnFromAnnotation(null, propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings);
        }
        if (!isNullable) {
            for (Ejb3Column col : columns) {
                col.forceNotNull();
            }
        }
        if (annotedElt.isAnnotationPresent(Id.class) || annotedElt.isAnnotationPresent(EmbeddedId.class)) {
            log.debug((Object)(inferredData.getPropertyName() + " is an id"));
            Id idAnn = annotedElt.getAnnotation(Id.class);
            EmbeddedId embeddedId = annotedElt.getAnnotation(EmbeddedId.class);
            HashMap localGenerators = (HashMap)classGenerators.clone();
            HashMap localGeneratorTables = (HashMap)classGeneratorTables.clone();
            localGenerators.putAll(AnnotationBinder.buildLocalGenerators(annotedElt));
            localGeneratorTables.putAll(AnnotationBinder.buildLocalGeneratorTable(annotedElt));
            Embeddable embeddableAnn = inferredData.getReturnedClass().getAnnotation(Embeddable.class);
            Embedded overrideAnn = annotedElt.getAnnotation(Embedded.class);
            HashMap<String, javax.persistence.Column[]> columnOverride = new HashMap<String, javax.persistence.Column[]>();
            AttributeOverride[] overrides = null;
            overrides = overrideAnn != null ? overrideAnn.value() : null;
            AttributeOverride[] attributeOverrideArray = overrides = embeddedId != null ? embeddedId.value() : null;
            if (overrides != null) {
                for (AttributeOverride depAttr : overrides) {
                    columnOverride.put(depAttr.name(), depAttr.column());
                }
            }
            boolean isComponent = embeddableAnn != null || overrideAnn != null || embeddedId != null;
            boolean propertyAccess = true;
            if (isComponent && embeddableAnn != null && embeddableAnn.access() == AccessType.FIELD) {
                propertyAccess = false;
            }
            String generatorType = idAnn != null ? AnnotationBinder.generatorType(idAnn.generate()) : "assigned";
            String generator = idAnn != null ? idAnn.generator() : ANNOTATION_STRING_DEFAULT;
            Type typeAnn = annotedElt.getAnnotation(Type.class);
            AnnotationBinder.bindId(generatorType, generator, inferredData, columns[0], (RootClass)propertyHolder.getPersistentClass(), localGenerators, localGeneratorTables, isComponent, columnOverride, propertyAccess, entityBinder, typeAnn, mappings);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bind " + (isComponent ? "@Id" : "@EmbeddedId") + " on " + inferredData.getPropertyName()));
            }
        } else if (annotedElt.isAnnotationPresent(Version.class)) {
            log.debug((Object)(inferredData.getPropertyName() + " is a version property"));
            RootClass rootClass = (RootClass)propertyHolder.getPersistentClass();
            boolean lazy = false;
            Type annType = annotedElt.getAnnotation(Type.class);
            PropertyBinder propBinder = new PropertyBinder();
            propBinder.setName(inferredData.getPropertyName());
            propBinder.setReturnedClassName(inferredData.getReturnedClassName());
            propBinder.setLazy(lazy);
            propBinder.setPropertyAccessorName(inferredData.getDefaultAccess());
            propBinder.setColumns(columns);
            propBinder.setHolder(PropertyHolderBuilder.buildPropertyHolder((PersistentClass)rootClass));
            propBinder.setExplicitType(annType);
            propBinder.setMappings(mappings);
            Property prop = propBinder.bind();
            rootClass.setVersion(prop);
            SimpleValue simpleValue = (SimpleValue)prop.getValue();
            if (!simpleValue.isTypeSpecified()) {
                simpleValue.setTypeName("integer");
            }
            simpleValue.setNullValue("undefined");
            rootClass.setOptimisticLockMode(0);
            log.debug((Object)("Version name: " + rootClass.getVersion().getName() + ", unsavedValue: " + ((SimpleValue)rootClass.getVersion().getValue()).getNullValue()));
        } else if (annotedElt.isAnnotationPresent(javax.persistence.ManyToOne.class)) {
            ann = annotedElt.getAnnotation(javax.persistence.ManyToOne.class);
            hibernateCascade = annotedElt.getAnnotation(Cascade.class);
            Ejb3JoinColumn.checkIfJoinColumn(columns, propertyHolder, inferredData);
            AnnotationBinder.bindManyToOne(AnnotationBinder.getCascadeStrategy(ann.cascade(), hibernateCascade), (Ejb3JoinColumn[])columns, ann.optional(), AnnotationBinder.getFetchMode(ann.fetch()), inferredData.getPropertyName(), inferredData.getReturnedClassName(), ann.targetEntity(), inferredData.getDefaultAccess(), propertyHolder, false, mappings);
        } else if (annotedElt.isAnnotationPresent(OneToOne.class)) {
            ann = annotedElt.getAnnotation(OneToOne.class);
            hibernateCascade = annotedElt.getAnnotation(Cascade.class);
            Ejb3JoinColumn.checkIfJoinColumn(columns, propertyHolder, inferredData);
            AnnotationBinder.bindOneToOne(AnnotationBinder.getCascadeStrategy(ann.cascade(), hibernateCascade), (Ejb3JoinColumn[])columns, ann.optional(), AnnotationBinder.getFetchMode(ann.fetch()), inferredData.getPropertyName(), inferredData.getReturnedClassName(), ann.targetEntity(), inferredData.getDefaultAccess(), propertyHolder, ann.mappedBy(), ann.usePKasFK(), mappings);
        } else if (annotedElt.isAnnotationPresent(OneToMany.class) || annotedElt.isAnnotationPresent(ManyToMany.class)) {
            Filters filtersAnn;
            OneToMany oneToManyAnn = annotedElt.getAnnotation(OneToMany.class);
            ManyToMany manyToManyAnn = annotedElt.getAnnotation(ManyToMany.class);
            org.hibernate.annotations.IndexColumn indexAnn = annotedElt.getAnnotation(org.hibernate.annotations.IndexColumn.class);
            AssociationTable assocTable = annotedElt.getAnnotation(AssociationTable.class);
            boolean isForeignKey = oneToManyAnn != null && assocTable == null && (columns[0].isImplicit() && !AnnotationBinder.isDefault(oneToManyAnn.mappedBy()) || !columns[0].isImplicit());
            AbstractCollectionBinder collectionBinder = AbstractCollectionBinder.getCollectionBinder(inferredData.getReturnedClass(), inferredData.isArray());
            IndexColumn indexColumn = IndexColumn.buildColumnFromAnnotation(indexAnn, propertyHolder, inferredData, mappings);
            collectionBinder.setIndexColumn(indexColumn);
            collectionBinder.setPropertyName(inferredData.getPropertyName());
            BatchSize batchAnn = annotedElt.getAnnotation(BatchSize.class);
            collectionBinder.setBatchSize(batchAnn);
            OrderBy orderByAnn = annotedElt.getAnnotation(OrderBy.class);
            collectionBinder.setOrderBy(orderByAnn);
            Sort sortAnn = annotedElt.getAnnotation(Sort.class);
            collectionBinder.setSort(sortAnn);
            Cache cachAnn = annotedElt.getAnnotation(Cache.class);
            collectionBinder.setCache(cachAnn);
            Filter filterAnn = annotedElt.getAnnotation(Filter.class);
            if (filterAnn != null) {
                collectionBinder.addFilter(filterAnn.name(), filterAnn.condition());
            }
            if ((filtersAnn = annotedElt.getAnnotation(Filters.class)) != null) {
                for (Filter filter : filtersAnn.value()) {
                    collectionBinder.addFilter(filter.name(), filter.condition());
                }
            }
            collectionBinder.setPropertyHolder(propertyHolder);
            Where whereAnn = annotedElt.getAnnotation(Where.class);
            collectionBinder.setWhere(whereAnn);
            Cascade hibernateCascade2 = annotedElt.getAnnotation(Cascade.class);
            collectionBinder.setCollectionType(inferredData.getCollectionType());
            collectionBinder.setMappings(mappings);
            collectionBinder.setPropertyAccessorName(inferredData.getDefaultAccess());
            if (oneToManyAnn != null && manyToManyAnn != null) {
                throw new AnnotationException("@OneToMany and @ManyToMany on the same property is not allowed: " + propertyHolder.getEntityName() + "." + inferredData.getPropertyName());
            }
            String mappedBy = null;
            if (oneToManyAnn != null) {
                Ejb3JoinColumn.checkIfJoinColumn(columns, propertyHolder, inferredData);
                for (Ejb3JoinColumn column : (Ejb3JoinColumn[])columns) {
                    if (!column.isSecondary()) continue;
                    throw new NotYetImplementedException("Collections having FK in secondary table");
                }
                collectionBinder.setJoinColumns((Ejb3JoinColumn[])columns);
                mappedBy = oneToManyAnn.mappedBy();
                collectionBinder.setUnique(true);
                collectionBinder.setTargetEntity(oneToManyAnn.targetEntity());
                collectionBinder.setFetchType(oneToManyAnn.fetch());
                collectionBinder.setCascadeStrategy(AnnotationBinder.getCascadeStrategy(oneToManyAnn.cascade(), hibernateCascade2));
            } else if (manyToManyAnn != null) {
                mappedBy = manyToManyAnn.mappedBy();
                collectionBinder.setUnique(false);
                collectionBinder.setTargetEntity(manyToManyAnn.targetEntity());
                collectionBinder.setFetchType(manyToManyAnn.fetch());
                collectionBinder.setCascadeStrategy(AnnotationBinder.getCascadeStrategy(manyToManyAnn.cascade(), hibernateCascade2));
            }
            collectionBinder.setMappedBy(mappedBy);
            if (isForeignKey) {
                for (Ejb3JoinColumn column : (Ejb3JoinColumn[])columns) {
                    if (!column.isSecondary()) continue;
                    throw new NotYetImplementedException("Collections having FK in secondary table");
                }
                collectionBinder.setOneToMany(true);
            } else {
                collectionBinder.setOneToMany(false);
                AnnotationBinder.bindJoinedTableAssociation(assocTable, mappings, entityBinder, collectionBinder, propertyHolder, inferredData, mappedBy);
            }
            collectionBinder.bind();
        } else {
            boolean isComponent = false;
            Embeddable embeddableAnn = inferredData.getReturnedClass().getAnnotation(Embeddable.class);
            Embedded embeddedAnn = annotedElt.getAnnotation(Embedded.class);
            if (embeddedAnn != null || embeddableAnn != null) {
                isComponent = true;
            }
            if (isComponent) {
                boolean propertyAccess = true;
                if (embeddableAnn != null && embeddableAnn.access() == AccessType.FIELD) {
                    propertyAccess = false;
                }
                HashMap<String, javax.persistence.Column[]> columnOverride = new HashMap<String, javax.persistence.Column[]>();
                if (embeddedAnn != null) {
                    for (AttributeOverride depAttr : embeddedAnn.value()) {
                        columnOverride.put(depAttr.name(), depAttr.column());
                    }
                }
                AnnotationBinder.bindComponent(inferredData, propertyHolder, propertyAccess, entityBinder, columnOverride, mappings);
            } else {
                boolean lazy = false;
                String type = ANNOTATION_STRING_DEFAULT;
                if (annotedElt.isAnnotationPresent(Basic.class)) {
                    Basic ann2 = annotedElt.getAnnotation(Basic.class);
                    lazy = ann2.fetch() == FetchType.LAZY;
                } else if (annotedElt.isAnnotationPresent(Lob.class)) {
                    Lob lob = annotedElt.getAnnotation(Lob.class);
                    lazy = lob.fetch() == FetchType.LAZY;
                    LobType lobType = lob.type();
                    if (LobType.CLOB.equals((Object)lobType)) {
                        type = String.class.equals((Object)inferredData.getReturnedClass()) ? StringClobType.class.getName() : (Character.class.equals((Object)inferredData.getReturnedClass()) && inferredData.isArray() ? CharacterArrayClobType.class.getName() : (Character.TYPE.equals(inferredData.getReturnedClass()) && inferredData.isArray() ? PrimitiveCharacterArrayClobType.class.getName() : "clob"));
                    }
                    if (LobType.BLOB.equals((Object)lobType)) {
                        type = Byte.class.equals((Object)inferredData.getReturnedClass()) && inferredData.isArray() ? ByteArrayBlobType.class.getName() : (Byte.TYPE.equals(inferredData.getReturnedClass()) && inferredData.isArray() ? PrimitiveByteArrayBlobType.class.getName() : "blob");
                    }
                } else if (annotedElt.isAnnotationPresent(Serialized.class)) {
                    Serialized serialized = annotedElt.getAnnotation(Serialized.class);
                    lazy = serialized.fetch() == FetchType.LAZY;
                    type = "serializable";
                } else if (Clob.class.equals((Object)inferredData.getReturnedClass())) {
                    type = "clob";
                } else if (Blob.class.equals((Object)inferredData.getReturnedClass())) {
                    type = "blob";
                }
                Type annType = annotedElt.getAnnotation(Type.class);
                PropertyBinder propBinder = new PropertyBinder();
                propBinder.setName(inferredData.getPropertyName());
                propBinder.setReturnedClassName(inferredData.getReturnedClassName());
                propBinder.setLazy(lazy);
                propBinder.setPropertyAccessorName(inferredData.getDefaultAccess());
                propBinder.setColumns(columns);
                propBinder.setHolder(propertyHolder);
                propBinder.setExplicitType(annType);
                propBinder.setExplicitType(type);
                propBinder.setMappings(mappings);
                propBinder.bind();
            }
        }
    }

    private static void bindJoinedTableAssociation(AssociationTable associationTableAnn, ExtendedMappings mappings, EntityBinder entityBinder, AbstractCollectionBinder collectionBinder, PropertyHolder propertyHolder, AnnotedElementInferredData inferredData, String mappedBy) {
        JoinColumn[] annInverseJoins;
        JoinColumn[] annJoins;
        org.hibernate.mapping.Table assocTable;
        if (associationTableAnn != null) {
            assocTable = !associationTableAnn.table().specified() ? null : TableBinder.fillTable(associationTableAnn.table().schema(), associationTableAnn.table().catalog(), mappings.getNamingStrategy().tableName(associationTableAnn.table().name()), false, new ArrayList(), null, null, mappings);
            JoinColumn[] joins = associationTableAnn.joinColumns();
            annJoins = joins.length == 0 ? null : joins;
            JoinColumn[] inverseJoins = associationTableAnn.inverseJoinColumns();
            annInverseJoins = inverseJoins.length == 0 ? null : inverseJoins;
        } else {
            assocTable = null;
            annJoins = null;
            annInverseJoins = null;
        }
        Ejb3JoinColumn[] joinColumns = AnnotationBinder.buildArrayOfEjb3JoinColumn(annJoins, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappedBy, mappings);
        Ejb3JoinColumn[] inverseJoinColumns = AnnotationBinder.buildArrayOfEjb3JoinColumn(annInverseJoins, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappedBy, mappings);
        collectionBinder.setTable(assocTable);
        collectionBinder.setJoinColumns(joinColumns);
        collectionBinder.setInverseJoinColumns(inverseJoinColumns);
    }

    private static Ejb3JoinColumn[] buildArrayOfEjb3JoinColumn(JoinColumn[] annJoins, Map<String, Join> secondaryTables, PropertyHolder propertyHolder, String propertyName, String mappedBy, ExtendedMappings mappings) {
        Ejb3JoinColumn[] joinColumns;
        if (annJoins == null) {
            joinColumns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildImplicitJoinColumn(mappedBy, secondaryTables, propertyHolder, propertyName, mappings)};
        } else {
            joinColumns = new Ejb3JoinColumn[annJoins.length];
            for (JoinColumn annJoin : annJoins) {
                joinColumns[index] = Ejb3JoinColumn.buildJoinColumn(annJoin, propertyName, secondaryTables, propertyHolder, propertyName, mappings);
            }
        }
        return joinColumns;
    }

    private static void bindComponent(AnnotedElementInferredData inferredData, PropertyHolder propertyHolder, boolean propertyAccess, EntityBinder entityBinder, Map<String, javax.persistence.Column[]> columnOverride, ExtendedMappings mappings) {
        Component comp = AnnotationBinder.fillComponent(propertyHolder, inferredData, propertyAccess, true, entityBinder, columnOverride, mappings);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(inferredData.getPropertyName());
        binder.setValue((Value)comp);
        binder.setPropertyAccessorName(inferredData.getDefaultAccess());
        Property prop = binder.make();
        propertyHolder.addProperty(prop);
    }

    private static Component fillComponent(PropertyHolder propertyHolder, AnnotedElementInferredData inferredData, boolean propertyAccess, boolean isNullable, EntityBinder entityBinder, Map<String, javax.persistence.Column[]> columnOverride, ExtendedMappings mappings) {
        Component comp = new Component(propertyHolder.getPersistentClass());
        comp.setComponentClassName(inferredData.getReturnedClassName());
        String subpath = StringHelper.qualify((String)propertyHolder.getPath(), (String)inferredData.getPropertyName());
        log.debug((Object)("Binding component with path: " + subpath));
        PropertyHolder subHolder = PropertyHolderBuilder.buildPropertyHolder(comp, subpath, columnOverride);
        AnnotationBinder.processElementsOfAClass(subHolder, propertyAccess, isNullable, inferredData.getReturnedClass(), new HashMap<String, IdGenerator>(), new HashMap<String, Properties>(), entityBinder, mappings);
        return comp;
    }

    private static void bindId(String generatorType, String generatorName, AnnotedElementInferredData inferredData, Ejb3Column column, RootClass rootClass, Map<String, IdGenerator> localGenerators, HashMap<String, Properties> localGeneratorTables, boolean isComposite, Map<String, javax.persistence.Column[]> columnOverride, boolean isPropertyAccess, EntityBinder entityBinder, Type typeAnn, ExtendedMappings mappings) {
        Component id;
        String persistentClassName;
        String string = persistentClassName = rootClass == null ? null : rootClass.getClassName();
        if (isComposite) {
            id = AnnotationBinder.fillComponent(PropertyHolderBuilder.buildPropertyHolder((PersistentClass)rootClass), inferredData, isPropertyAccess, false, entityBinder, columnOverride, mappings);
        } else {
            column.forceNotNull();
            SimpleValueBinder value = new SimpleValueBinder();
            value.setPropertyName(inferredData.getPropertyName());
            value.setReturnedClassName(inferredData.getReturnedClassName());
            value.setColumns(new Ejb3Column[]{column});
            value.setPersistentClassName(persistentClassName);
            value.setMappings(mappings);
            value.setExplicitType(typeAnn);
            id = value.make();
        }
        rootClass.setIdentifier((KeyValue)id);
        org.hibernate.mapping.Table table = id.getTable();
        table.setIdentifierValue((KeyValue)id);
        id.setIdentifierGeneratorStrategy(generatorType);
        if (generatorType == "assigned") {
            id.setNullValue("undefined");
        }
        Properties params = new Properties();
        params.setProperty("target_table", table.getName());
        params.setProperty("target_column", ((Column)id.getColumnIterator().next()).getName());
        if (!AnnotationBinder.isDefault(generatorName)) {
            IdGenerator gen = mappings.getGenerator(generatorName, localGenerators);
            if (gen == null) {
                throw new AnnotationException("Unknown Id.generator: " + generatorName);
            }
            AnnotationBinder.checkIfMatchingGenerator(gen, generatorType, generatorName);
            for (Map.Entry<Object, Object> elt : gen.getParams().entrySet()) {
                params.setProperty((String)elt.getKey(), (String)elt.getValue());
            }
            if (MultipleHiLoPerTableGenerator.class.getName().equals(generatorType)) {
                AnnotationBinder.fillGeneratorWithGeneratorTableParams(params, localGeneratorTables, generatorName, mappings);
            }
        }
        id.setIdentifierGeneratorProperties(params);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(inferredData.getPropertyName());
        binder.setValue((Value)id);
        binder.setPropertyAccessorName(inferredData.getDefaultAccess());
        Property prop = binder.make();
        rootClass.setIdentifierProperty(prop);
    }

    private static void checkIfMatchingGenerator(IdGenerator gen, String generatorType, String generatorName) {
        boolean matchingGenerator = gen.getIdentifierGeneratorStrategy().equals(generatorType);
        boolean defaultGenerator = AnnotationBinder.generatorType(GeneratorType.AUTO).equals(generatorType);
        if (!matchingGenerator && !defaultGenerator) {
            throw new AnnotationException("Incompatible generator between Id.generate and its named generator: " + generatorType + "!=" + generatorName);
        }
    }

    private static void fillGeneratorWithGeneratorTableParams(Properties params, HashMap<String, Properties> localGeneratorTables, String generatorName, ExtendedMappings mappings) {
        String generatorTableName = params.getProperty(GENERATOR_TABLE_NAME_PARAM);
        Properties props = mappings.getGeneratorTableProperties(generatorTableName, localGeneratorTables);
        if (props == null) {
            if ("hibernate_sequences".equals(generatorTableName)) {
                return;
            }
            throw new AnnotationException("Unable to find a @GeneratedIdTable for table name in " + generatorName + ": " + generatorTableName);
        }
        for (Map.Entry<Object, Object> property : props.entrySet()) {
            params.setProperty((String)property.getKey(), (String)property.getValue());
        }
    }

    private static void bindManyToOne(String cascadeStrategy, Ejb3JoinColumn[] columns, boolean optional, FetchMode fetchMode, String propertyName, String returnedClassName, String targetEntity, String propertyAccessorName, PropertyHolder propertyHolder, boolean unique, ExtendedMappings mappings) {
        ManyToOne value = new ManyToOne(columns[0].getTable());
        if (AnnotationBinder.isDefault(targetEntity)) {
            value.setReferencedEntityName(returnedClassName);
        } else {
            value.setReferencedEntityName(targetEntity);
        }
        value.setFetchMode(fetchMode);
        value.setLazy(fetchMode != FetchMode.JOIN);
        if (!optional) {
            for (Ejb3JoinColumn column : columns) {
                column.setNullable(false);
            }
        }
        value.setTypeName(returnedClassName);
        value.setTypeUsingReflection(propertyHolder.getClassName(), propertyName);
        String propertyRef = value.getReferencedPropertyName();
        if (propertyRef != null) {
            mappings.addUniquePropertyReference(value.getReferencedEntityName(), propertyRef);
        }
        mappings.addSecondPass(new FkSecondPass((Value)value, columns, unique, mappings));
        Ejb3Column.checkPropertyConsistency(columns, propertyHolder.getEntityName() + propertyName);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(propertyName);
        binder.setValue((Value)value);
        binder.setCascade(cascadeStrategy);
        binder.setInsertable(columns[0].isInsertable());
        binder.setUpdatable(columns[0].isUpdatable());
        binder.setPropertyAccessorName(propertyAccessorName);
        binder.setCascade(cascadeStrategy);
        Property prop = binder.make();
        columns[0].addPropertyToMappingContainer(prop);
    }

    public static void bindFkSecondPass(ManyToOne manyToOne, Ejb3JoinColumn[] columns, Map persistentClasses, boolean unique) {
        PersistentClass ref = (PersistentClass)persistentClasses.get(manyToOne.getReferencedEntityName());
        if (ref == null) {
            throw new AnnotationException("Unable to find entity " + manyToOne.getReferencedEntityName());
        }
        TableBinder.bindFk(ref, null, columns, (SimpleValue)manyToOne, unique);
    }

    private static void bindOneToOne(String cascadeStrategy, Ejb3JoinColumn[] columns, boolean optional, FetchMode fetchMode, String propertyName, String returnedClassName, String targetEntity, String propertyAccessorName, PropertyHolder propertyHolder, String mappedBy, boolean trueOneToOne, ExtendedMappings mappings) {
        log.debug((Object)("Fetching " + propertyName + " with " + fetchMode));
        boolean mapToPK = true;
        if (!trueOneToOne) {
            Iterator idColumns = propertyHolder.getIdentifier().getColumnIterator();
            ArrayList<String> idColumnNames = new ArrayList<String>();
            while (idColumns.hasNext()) {
                Column currentColumn = (Column)idColumns.next();
                idColumnNames.add(currentColumn.getName());
            }
            for (Ejb3JoinColumn col : columns) {
                if (idColumnNames.contains(col.getMappingColumn().getName())) continue;
                mapToPK = false;
                break;
            }
        }
        if (trueOneToOne || mapToPK || !AnnotationBinder.isDefault(mappedBy)) {
            String propertyRef;
            org.hibernate.mapping.OneToOne value = new org.hibernate.mapping.OneToOne(propertyHolder.getTable(), propertyHolder.getPersistentClass());
            if (AnnotationBinder.isDefault(targetEntity)) {
                value.setReferencedEntityName(returnedClassName);
            } else {
                value.setReferencedEntityName(targetEntity);
            }
            value.setFetchMode(fetchMode);
            value.setLazy(fetchMode != FetchMode.JOIN);
            if (!optional) {
                value.setConstrained(true);
            }
            value.setForeignKeyType(value.isConstrained() ? ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT : ForeignKeyDirection.FOREIGN_KEY_TO_PARENT);
            if (!AnnotationBinder.isDefault(mappedBy)) {
                value.setReferencedPropertyName(mappedBy);
            }
            if ((propertyRef = value.getReferencedPropertyName()) != null) {
                mappings.addUniquePropertyReference(value.getReferencedEntityName(), propertyRef);
            }
            PropertyBinder binder = new PropertyBinder();
            binder.setName(propertyName);
            binder.setValue((Value)value);
            binder.setCascade(cascadeStrategy);
            binder.setPropertyAccessorName(propertyAccessorName);
            Property prop = binder.make();
            prop.setCascade(cascadeStrategy);
            propertyHolder.addProperty(prop);
        } else {
            AnnotationBinder.bindManyToOne(cascadeStrategy, columns, optional, fetchMode, propertyName, returnedClassName, targetEntity, propertyAccessorName, propertyHolder, true, mappings);
        }
    }

    private static String generatorType(GeneratorType generatorEnum) {
        switch (generatorEnum) {
            case NONE: {
                return "assigned";
            }
            case IDENTITY: {
                return "identity";
            }
            case AUTO: {
                return "native";
            }
            case TABLE: {
                return MultipleHiLoPerTableGenerator.class.getName();
            }
            case SEQUENCE: {
                return "sequence";
            }
        }
        throw new AssertionFailure("Unknown GeneratorType: " + generatorEnum);
    }

    private static EnumSet<org.hibernate.annotations.CascadeType> convertToHibernateCascadeType(CascadeType[] ejbCascades) {
        EnumSet<org.hibernate.annotations.CascadeType> hibernateCascadeSet = EnumSet.noneOf(org.hibernate.annotations.CascadeType.class);
        if (ejbCascades != null && ejbCascades.length > 0) {
            block7: for (CascadeType cascade : ejbCascades) {
                switch (cascade) {
                    case ALL: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.ALL);
                        continue block7;
                    }
                    case PERSIST: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.PERSIST);
                        continue block7;
                    }
                    case MERGE: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.MERGE);
                        continue block7;
                    }
                    case REMOVE: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.REMOVE);
                        continue block7;
                    }
                    case REFRESH: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.REFRESH);
                    }
                }
            }
        }
        return hibernateCascadeSet;
    }

    private static String getCascadeStrategy(CascadeType[] ejbCascades, Cascade hibernateCascadeAnnotation) {
        org.hibernate.annotations.CascadeType[] hibernateCascades;
        EnumSet<org.hibernate.annotations.CascadeType> hibernateCascadeSet = AnnotationBinder.convertToHibernateCascadeType(ejbCascades);
        org.hibernate.annotations.CascadeType[] cascadeTypeArray = hibernateCascades = hibernateCascadeAnnotation == null ? null : hibernateCascadeAnnotation.value();
        if (hibernateCascades != null && hibernateCascades.length > 0) {
            for (org.hibernate.annotations.CascadeType cascadeType : hibernateCascades) {
                hibernateCascadeSet.add(cascadeType);
            }
        }
        StringBuffer cascade = new StringBuffer();
        Iterator cascadeType = hibernateCascadeSet.iterator();
        while (cascadeType.hasNext()) {
            switch ((org.hibernate.annotations.CascadeType)((Object)cascadeType.next())) {
                case ALL: {
                    cascade.append(",").append("all");
                    break;
                }
                case SAVE_UPDATE: {
                    cascade.append(",").append("save-update");
                    break;
                }
                case PERSIST: {
                    cascade.append(",").append("persist");
                    break;
                }
                case MERGE: {
                    cascade.append(",").append("merge");
                    break;
                }
                case LOCK: {
                    cascade.append(",").append("lock");
                    break;
                }
                case REFRESH: {
                    cascade.append(",").append("refresh");
                    break;
                }
                case REPLICATE: {
                    cascade.append(",").append("replicate");
                    break;
                }
                case EVICT: {
                    cascade.append(",").append("evict");
                    break;
                }
                case DELETE: {
                    cascade.append(",").append("delete");
                    break;
                }
                case DELETE_ORPHAN: {
                    cascade.append(",").append("delete-orphan");
                    break;
                }
                case REMOVE: {
                    cascade.append(",").append("delete");
                }
            }
        }
        return cascade.length() > 0 ? cascade.substring(1) : "none";
    }

    private static FetchMode getFetchMode(FetchType fetch) {
        if (fetch == FetchType.EAGER) {
            return FetchMode.JOIN;
        }
        return FetchMode.SELECT;
    }

    private static HashMap<String, IdGenerator> buildLocalGenerators(AnnotatedElement annElt) {
        IdGenerator idGen;
        HashMap<String, IdGenerator> generators = new HashMap<String, IdGenerator>();
        TableGenerator tabGen = annElt.getAnnotation(TableGenerator.class);
        SequenceGenerator seqGen = annElt.getAnnotation(SequenceGenerator.class);
        if (tabGen != null) {
            idGen = AnnotationBinder.buildIdGenerator((Annotation)tabGen);
            generators.put(idGen.getName(), idGen);
        }
        if (seqGen != null) {
            idGen = AnnotationBinder.buildIdGenerator((Annotation)seqGen);
            generators.put(idGen.getName(), idGen);
        }
        return generators;
    }

    public static boolean isDefault(String annotationString) {
        return ANNOTATION_STRING_DEFAULT.equals(annotationString);
    }

    public static Map<Class, InheritanceState> buildInheritanceStates(List<Class> orderedClasses) {
        HashMap<Class, InheritanceState> inheritanceStatePerClass = new HashMap<Class, InheritanceState>(orderedClasses.size());
        for (Class clazz : orderedClasses) {
            Class superClazz = clazz.getSuperclass();
            InheritanceState state = new InheritanceState();
            state.setInheritanceType(clazz);
            if (orderedClasses.contains(superClazz)) {
                boolean mixingStrategy;
                InheritanceState superState = (InheritanceState)inheritanceStatePerClass.get(superClazz);
                superState.hasSons = true;
                state.hasParents = true;
                boolean nonDefault = !InheritanceType.SINGLE_TABLE.equals((Object)state.type);
                boolean bl = mixingStrategy = !state.type.equals((Object)superState.type);
                if (nonDefault && mixingStrategy) {
                    log.warn((Object)("Mixing inheritance strategy in a entity hierarchy is not allowed, ignoring sub strategy in: " + clazz.getName()));
                }
                state.type = superState.type;
            }
            inheritanceStatePerClass.put(clazz, state);
        }
        return inheritanceStatePerClass;
    }
}

