/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom.cache;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.persistence.Id;
import javax.persistence.IdClass;
import me.prettyprint.hom.CFMappingDef;
import me.prettyprint.hom.ClassCacheMgr;
import me.prettyprint.hom.KeyDefinition;
import me.prettyprint.hom.cache.HectorObjectMapperException;
import me.prettyprint.hom.cache.ParserValidator;

public class IdClassParserValidator
implements ParserValidator {
    @Override
    public <T> void parse(ClassCacheMgr cacheMgr, Annotation anno, CFMappingDef<T> cfMapDef) {
        if (!(anno instanceof IdClass)) {
            throw new HectorObjectMapperException("This class cannot parse annotation, " + anno.getClass().getSimpleName());
        }
        this.parseIdClassAnnotation(cacheMgr, (IdClass)anno, cfMapDef);
    }

    @Override
    public <T> void validateAndSetDefaults(ClassCacheMgr cacheMgr, CFMappingDef<T> cfMapDef) {
        Map<String, PropertyDescriptor> pdMap;
        KeyDefinition keyDef = cfMapDef.getKeyDef();
        if (null == keyDef.getPkClazz()) {
            return;
        }
        try {
            pdMap = cacheMgr.getFieldPropertyDescriptorMap(keyDef.getPkClazz());
        }
        catch (IntrospectionException e) {
            throw new HectorObjectMapperException("exception while introspecting class, " + keyDef.getPkClazz().getName(), e);
        }
        if (keyDef.getIdPropertyMap().size() != pdMap.size()) {
            throw new HectorObjectMapperException("Each field in the primary key class, " + keyDef.getPkClazz().getName() + ", must have a corresponding property in the entity, " + cfMapDef.getRealClass().getName() + ", annotated with @" + Id.class.getSimpleName());
        }
        for (String idFieldName : pdMap.keySet()) {
            if (keyDef.getIdPropertyMap().containsKey(idFieldName)) continue;
            throw new HectorObjectMapperException("Each field in the primary key class, " + keyDef.getPkClazz().getName() + ", must have a corresponding property in the entity, " + cfMapDef.getRealClass().getName() + ", annotated with @" + Id.class.getSimpleName() + " : missing ID field, " + idFieldName);
        }
    }

    private <T> void parseIdClassAnnotation(ClassCacheMgr cacheMgr, IdClass anno, CFMappingDef<T> cfMapDef) {
        Class pkClazz = anno.value();
        this.verifyClassConformsToJpaSpec(pkClazz);
        cfMapDef.getKeyDef().setPkClass(pkClazz);
    }

    private void verifyClassConformsToJpaSpec(Class<?> pkClazz) {
        if (!Serializable.class.isAssignableFrom(pkClazz)) {
            throw new HectorObjectMapperException("JPA requires that primary key class, " + pkClazz.getName() + ", must be Serializable");
        }
    }
}

