/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Metamodel;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.beans.ColumnSlice;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hom.CFMappingDef;
import me.prettyprint.hom.ClassCacheMgr;
import me.prettyprint.hom.EntityManagerFactoryImpl;
import me.prettyprint.hom.HectorObjectMapper;
import me.prettyprint.hom.annotations.AnnotationScanner;
import me.prettyprint.hom.annotations.DefaultAnnotationScanner;
import me.prettyprint.hom.cache.HectorObjectMapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagerImpl
implements EntityManager {
    private static Logger logger = LoggerFactory.getLogger(EntityManagerImpl.class);
    private Keyspace keyspace;
    private HectorObjectMapper objMapper;
    private ClassCacheMgr cacheMgr;
    private EntityManagerFactory emf;

    public EntityManagerImpl(Keyspace keyspace, String classpathPrefix) {
        this(keyspace, (AnnotationScanner)new DefaultAnnotationScanner(), classpathPrefix);
    }

    public EntityManagerImpl(Keyspace keyspace, AnnotationScanner scanner, String classpathPrefix) {
        this(keyspace, new String[]{classpathPrefix}, null, null, scanner);
    }

    public EntityManagerImpl(Keyspace keyspace, String[] classpathPrefix) {
        this(keyspace, (AnnotationScanner)new DefaultAnnotationScanner(), classpathPrefix);
    }

    public EntityManagerImpl(Keyspace keyspace, AnnotationScanner scanner, String[] classpathPrefix) {
        this(keyspace, classpathPrefix, null, null, scanner);
    }

    public EntityManagerImpl(Keyspace keyspace, EntityManagerFactory emf, Class<?> ... classes) {
        this(keyspace, (EntityManagerFactoryImpl)null, (String[])null, (AnnotationScanner)null);
        for (Class<?> clazz : classes) {
            this.cacheMgr.initializeCacheForClass(clazz);
        }
        this.emf = emf;
    }

    public EntityManagerImpl(Keyspace keyspace, String[] classpathPrefix, ClassCacheMgr cacheMgr, HectorObjectMapper objMapper, AnnotationScanner scanner) {
        this.keyspace = keyspace;
        this.cacheMgr = null != cacheMgr ? cacheMgr : new ClassCacheMgr();
        this.objMapper = null != objMapper ? objMapper : new HectorObjectMapper(this.cacheMgr);
        this.initialize(scanner, classpathPrefix);
    }

    public EntityManagerImpl(Keyspace space, EntityManagerFactoryImpl entityManagerFactory, String[] packageToScan, AnnotationScanner scanner) {
        this(space, packageToScan, null, null, scanner);
        this.emf = entityManagerFactory;
    }

    public void initialize(AnnotationScanner scanner, String[] classpathPrefixArr) {
        if (null != classpathPrefixArr && 0 < classpathPrefixArr.length) {
            for (String classpathPrefix : classpathPrefixArr) {
                this.initializeClasspath(scanner, classpathPrefix);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("classpath array has {} items : {}", null != classpathPrefixArr ? Integer.valueOf(classpathPrefixArr.length) : "0", (Object)classpathPrefixArr);
        }
    }

    private void initializeClasspath(AnnotationScanner scanner, String classpathPrefix) {
        Set<Class<?>> classSet = scanner.scan(classpathPrefix, Entity.class);
        for (Class<?> clazz : classSet) {
            this.cacheMgr.initializeCacheForClass(clazz);
        }
    }

    @Deprecated
    public <T, I> T load(Class<T> clazz, I id) {
        return this.find(clazz, id);
    }

    @Deprecated
    public <T> T load(Class<T> clazz, Object id, ColumnSlice<String, byte[]> colSlice) {
        return this.find(clazz, id, colSlice);
    }

    @Deprecated
    public <T> T save(T obj) {
        this.persist(obj);
        return obj;
    }

    public <T> T find(Class<T> clazz, Object id) {
        if (null == clazz) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        if (null == id) {
            throw new IllegalArgumentException("id cannot be null");
        }
        CFMappingDef<T> cfMapDef = this.cacheMgr.getCfMapDef(clazz, false);
        if (null == cfMapDef) {
            throw new HectorObjectMapperException("No class annotated with @" + Entity.class.getSimpleName() + " for type, " + clazz.getName());
        }
        return this.objMapper.getObject(this.keyspace, cfMapDef.getEffectiveColFamName(), id);
    }

    public <T> T find(Class<T> clazz, Object id, ColumnSlice<String, byte[]> colSlice) {
        if (null == clazz) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        if (null == id) {
            throw new IllegalArgumentException("id cannot be null");
        }
        CFMappingDef<T> cfMapDef = this.cacheMgr.getCfMapDef(clazz, false);
        if (null == cfMapDef) {
            throw new HectorObjectMapperException("No class annotated with @" + Entity.class.getSimpleName() + " for type, " + clazz.getName());
        }
        T obj = this.objMapper.createObject(cfMapDef, id, colSlice);
        return obj;
    }

    public Collection<Object> persist(Collection<Object> objColl) {
        if (null == objColl) {
            throw new IllegalArgumentException("object to save cannot be null");
        }
        this.objMapper.saveObjCollection(this.keyspace, objColl);
        return objColl;
    }

    public Collection<?> persist(Collection<?> objColl, Mutator<byte[]> m) {
        if (null == objColl) {
            throw new IllegalArgumentException("object to save cannot be null");
        }
        this.objMapper.saveObjCollection(this.keyspace, objColl, m);
        return objColl;
    }

    public void persist(Object obj) {
        if (null == obj) {
            throw new IllegalArgumentException("object to save cannot be null");
        }
        this.objMapper.saveObj(this.keyspace, obj);
    }

    public <T> T merge(T t) {
        return this.objMapper.saveObj(this.keyspace, t);
    }

    public void remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return this.find(entityClass, primaryKey);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        return this.find(entityClass, primaryKey);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        return this.find(entityClass, primaryKey);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return this.find(entityClass, primaryKey);
    }

    public void flush() {
    }

    public void setFlushMode(FlushModeType flushMode) {
    }

    public FlushModeType getFlushMode() {
        return FlushModeType.AUTO;
    }

    public void lock(Object entity, LockModeType lockMode) {
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
    }

    public void refresh(Object entity) {
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.refresh(entity);
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.refresh(entity);
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.refresh(entity);
    }

    public void clear() {
    }

    public void detach(Object entity) {
    }

    public boolean contains(Object entity) {
        return false;
    }

    public LockModeType getLockMode(Object entity) {
        return LockModeType.NONE;
    }

    public void setProperty(String propertyName, Object value) {
    }

    public Map<String, Object> getProperties() {
        return Collections.emptyMap();
    }

    public Query createQuery(String qlString) {
        return null;
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        return null;
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        return null;
    }

    public Query createNamedQuery(String name) {
        return null;
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        return null;
    }

    public Query createNativeQuery(String sqlString) {
        return null;
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        return null;
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        return null;
    }

    public void joinTransaction() {
    }

    public <T> T unwrap(Class<T> cls) {
        return null;
    }

    public Object getDelegate() {
        return this;
    }

    public void close() {
    }

    public boolean isOpen() {
        return true;
    }

    public EntityTransaction getTransaction() {
        return null;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.emf;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return null;
    }

    public Metamodel getMetamodel() {
        return null;
    }
}

