/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom;

import java.util.Map;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import org.apache.commons.lang.StringUtils;

public class EntityManagerConfigurator {
    public static final String PROP_PREFIX = "me.prettyprint.hom.";
    public static final String CLASSPATH_PREFIX_PROP = "me.prettyprint.hom.classpathPrefix";
    public static final String CLUSTER_NAME_PROP = "me.prettyprint.hom.clusterName";
    public static final String KEYSPACE_PROP = "me.prettyprint.hom.keyspace";
    public static final String HOST_LIST_PROP = "me.prettyprint.hom.hostList";
    private final String classpathPrefix;
    private final String clusterName;
    private final String keyspace;
    private CassandraHostConfigurator cassandraHostConfigurator;

    public EntityManagerConfigurator(Map<String, Object> properties) {
        this(properties, null);
    }

    public EntityManagerConfigurator(Map<String, Object> properties, CassandraHostConfigurator cassandraHostConfigurator) {
        this.classpathPrefix = EntityManagerConfigurator.getPropertyGently(properties, CLASSPATH_PREFIX_PROP, true);
        this.clusterName = EntityManagerConfigurator.getPropertyGently(properties, CLUSTER_NAME_PROP, true);
        this.keyspace = EntityManagerConfigurator.getPropertyGently(properties, KEYSPACE_PROP, true);
        if (cassandraHostConfigurator == null) {
            String hostList = EntityManagerConfigurator.getPropertyGently(properties, HOST_LIST_PROP, false);
            cassandraHostConfigurator = StringUtils.isNotBlank((String)hostList) ? new CassandraHostConfigurator(hostList) : new CassandraHostConfigurator();
        }
        this.cassandraHostConfigurator = cassandraHostConfigurator;
    }

    public static String getPropertyGently(Map<String, Object> props, String key, boolean throwError) {
        if (props.get(key) != null) {
            return props.get(key).toString();
        }
        if (throwError) {
            throw new IllegalArgumentException(String.format("The configuration property '%s' cannot be null.", key));
        }
        return null;
    }

    public String getClasspathPrefix() {
        return this.classpathPrefix;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public CassandraHostConfigurator getCassandraHostConfigurator() {
        return this.cassandraHostConfigurator;
    }

    public String toString() {
        return new StringBuilder(512).append(CLASSPATH_PREFIX_PROP).append(":").append(this.classpathPrefix).append(", ").append(CLUSTER_NAME_PROP).append(":").append(this.clusterName).append(", ").append(KEYSPACE_PROP).append(":").append(this.keyspace).toString();
    }
}

