/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.Table;
import me.prettyprint.hom.CFMappingDef;
import me.prettyprint.hom.HomMissingEntityAnnotationException;
import me.prettyprint.hom.PropertyMappingDefinition;
import me.prettyprint.hom.annotations.AnonymousPropertyHandling;
import me.prettyprint.hom.annotations.Column;
import me.prettyprint.hom.annotations.Id;
import me.prettyprint.hom.cache.AnonymousParserValidator;
import me.prettyprint.hom.cache.ColumnParser;
import me.prettyprint.hom.cache.HectorObjectMapperException;
import me.prettyprint.hom.cache.IdClassParserValidator;
import me.prettyprint.hom.cache.InheritanceParserValidator;
import me.prettyprint.hom.cache.TableParserValidator;
import me.prettyprint.hom.converters.DefaultConverter;

public class ClassCacheMgr {
    private Map<String, CFMappingDef<?>> cfMapByColFamName = new HashMap();
    private Map<Class<?>, CFMappingDef<?>> cfMapByClazz = new HashMap();
    private InheritanceParserValidator inheritanceParVal = new InheritanceParserValidator();
    private TableParserValidator tableParVal = new TableParserValidator();
    private IdClassParserValidator idClassParVal = new IdClassParserValidator();
    private ColumnParser columnPar = new ColumnParser();
    private AnonymousParserValidator anonymousParVal = new AnonymousParserValidator();

    public <T> CFMappingDef<? super T> findBaseClassViaMappings(CFMappingDef<T> cfMapDef) {
        CFMappingDef<T> cfSuperDef;
        CFMappingDef<T> tmpDef = cfMapDef;
        while (null != (cfSuperDef = tmpDef.getCfSuperMapDef())) {
            if (cfSuperDef.isBaseEntity()) {
                return cfSuperDef;
            }
            tmpDef = cfSuperDef;
        }
        return null;
    }

    public <T> CFMappingDef<T> getCfMapDef(Class<T> clazz, boolean throwException) {
        CFMappingDef<?> cfMapDef = this.cfMapByClazz.get(clazz);
        if (null == cfMapDef && throwException) {
            throw new HectorObjectMapperException("could not find property definitions for class, " + clazz.getSimpleName() + ", in class cache.  This indicates the EntityManager was not initialized properly.  If not using EntityManager the cache must be explicity initialized");
        }
        return cfMapDef;
    }

    public <T> CFMappingDef<T> getCfMapDef(String colFamName, boolean throwException) {
        CFMappingDef<?> cfMapDef = this.cfMapByColFamName.get(colFamName);
        if (null == cfMapDef && throwException) {
            throw new HectorObjectMapperException("could not find property definitions for column family, " + colFamName + ", in class cache.  This indicates the EntityManager was not initialized properly.  If not using EntityManager the cache must be explicity initialized");
        }
        return cfMapDef;
    }

    public <T> CFMappingDef<T> initializeCacheForClass(Class<T> clazz) {
        CFMappingDef<T> cfMapDef = this.initializeColumnFamilyMapDef(clazz);
        try {
            this.initializePropertiesMapDef(cfMapDef);
        }
        catch (IntrospectionException e) {
            throw new HectorObjectMapperException(e);
        }
        catch (InstantiationException e) {
            throw new HectorObjectMapperException(e);
        }
        catch (IllegalAccessException e) {
            throw new HectorObjectMapperException(e);
        }
        this.checkMappingAndSetDefaults(cfMapDef);
        if (!cfMapDef.isDerivedEntity()) {
            this.cfMapByColFamName.put(cfMapDef.getEffectiveColFamName(), cfMapDef);
        }
        this.cfMapByClazz.put(cfMapDef.getRealClass(), cfMapDef);
        return cfMapDef;
    }

    public Map<String, PropertyDescriptor> getFieldPropertyDescriptorMap(Class<?> clazz) throws IntrospectionException {
        HashMap<String, PropertyDescriptor> pdMap = new HashMap<String, PropertyDescriptor>();
        PropertyDescriptor[] pdArr = Introspector.getBeanInfo(clazz, clazz.getSuperclass()).getPropertyDescriptors();
        if (null == pdArr || 0 == pdArr.length) {
            return pdMap;
        }
        for (PropertyDescriptor pd : pdArr) {
            pdMap.put(pd.getName(), pd);
        }
        return pdMap;
    }

    private <T> void initializePropertiesMapDef(CFMappingDef<T> cfMapDef) throws IntrospectionException, InstantiationException, IllegalAccessException {
        Field[] fieldArr;
        Class<T> theType = cfMapDef.getEffectiveClass();
        Map<String, PropertyDescriptor> pdMap = this.getFieldPropertyDescriptorMap(theType);
        if (pdMap.isEmpty() && !cfMapDef.isPersistableDerivedEntity()) {
            throw new HectorObjectMapperException("could not find any properties annotated with @" + javax.persistence.Column.class.getSimpleName());
        }
        for (Field f : fieldArr = theType.getDeclaredFields()) {
            Annotation[] annoArr = f.getAnnotations();
            if (null == annoArr) continue;
            for (Annotation anno : annoArr) {
                PropertyDescriptor pd = pdMap.get(f.getName());
                if (null == pd) {
                    throw new HectorObjectMapperException("Property, " + cfMapDef.getEffectiveClass().getSimpleName() + "." + f.getName() + ", does not have proper setter/getter");
                }
                if (anno instanceof javax.persistence.Column || anno instanceof Column) {
                    this.columnPar.parse(f, anno, pd, cfMapDef);
                    continue;
                }
                if (anno instanceof Basic) continue;
                if (anno instanceof javax.persistence.Id) {
                    this.processIdAnnotation(f, (javax.persistence.Id)anno, cfMapDef, pdMap);
                    continue;
                }
                if (!(anno instanceof Id)) continue;
                this.processIdCustomAnnotation(f, (Id)anno, cfMapDef, pdMap);
            }
        }
    }

    private <T> void processIdAnnotation(Field f, javax.persistence.Id anno, CFMappingDef<T> cfMapDef, Map<String, PropertyDescriptor> pdMap) throws InstantiationException, IllegalAccessException {
        PropertyMappingDefinition md = new PropertyMappingDefinition(pdMap.get(f.getName()), null, DefaultConverter.class);
        if (null == md.getPropDesc() || null == md.getPropDesc().getReadMethod() || null == md.getPropDesc().getWriteMethod()) {
            throw new HectorObjectMapperException("@" + javax.persistence.Id.class.getSimpleName() + " is defined on property, " + f.getName() + ", but its missing proper setter/getter");
        }
        cfMapDef.getKeyDef().addIdPropertyMap(md);
    }

    private <T> void processIdCustomAnnotation(Field f, Id anno, CFMappingDef<T> cfMapDef, Map<String, PropertyDescriptor> pdMap) throws InstantiationException, IllegalAccessException {
        PropertyMappingDefinition md = new PropertyMappingDefinition(pdMap.get(f.getName()), null, anno.converter());
        if (null == md.getPropDesc() || null == md.getPropDesc().getReadMethod() || null == md.getPropDesc().getWriteMethod()) {
            throw new HectorObjectMapperException("@" + javax.persistence.Id.class.getSimpleName() + " is defined on property, " + f.getName() + ", but its missing proper setter/getter");
        }
        cfMapDef.getKeyDef().addIdPropertyMap(md);
    }

    private <T> CFMappingDef<T> initializeColumnFamilyMapDef(Class<T> realClass) {
        Annotation[] annoArr;
        CFMappingDef<T> cfMapDef = this.getCfMapDef(realClass, false);
        if (null != cfMapDef) {
            return cfMapDef;
        }
        cfMapDef = new CFMappingDef<T>(realClass);
        Class<T> effectiveType = cfMapDef.getEffectiveClass();
        CFMappingDef<T> cfSuperMapDef = null;
        if (null != effectiveType.getSuperclass()) {
            try {
                cfSuperMapDef = this.initializeCacheForClass(effectiveType.getSuperclass());
                cfMapDef.setCfSuperMapDef(cfSuperMapDef);
            }
            catch (HomMissingEntityAnnotationException e) {
                // empty catch block
            }
        }
        if (null == (annoArr = effectiveType.getAnnotations())) {
            return cfMapDef;
        }
        for (Annotation anno : annoArr) {
            if (anno instanceof Table) {
                this.tableParVal.parse(this, anno, cfMapDef);
                continue;
            }
            if (anno instanceof IdClass) {
                this.idClassParVal.parse(this, anno, cfMapDef);
                continue;
            }
            if (anno instanceof Inheritance) {
                this.inheritanceParVal.parse(this, anno, cfMapDef);
                continue;
            }
            if (anno instanceof DiscriminatorColumn) {
                this.inheritanceParVal.parse(this, anno, cfMapDef);
                continue;
            }
            if (anno instanceof DiscriminatorValue) {
                this.inheritanceParVal.parse(this, anno, cfMapDef);
                continue;
            }
            if (!(anno instanceof AnonymousPropertyHandling)) continue;
            this.anonymousParVal.parse(this, anno, cfMapDef);
        }
        return cfMapDef;
    }

    private <T> void checkMappingAndSetDefaults(CFMappingDef<T> cfMapDef) {
        this.inheritanceParVal.validateAndSetDefaults(this, cfMapDef);
        this.tableParVal.validateAndSetDefaults(this, cfMapDef);
        this.idClassParVal.validateAndSetDefaults(this, cfMapDef);
        this.anonymousParVal.validateAndSetDefaults(this, cfMapDef);
        this.checkForPojoPrimaryKey(cfMapDef);
        this.generateColumnSliceIfNeeded(cfMapDef);
    }

    private void checkForPojoPrimaryKey(CFMappingDef<?> cfMapDef) {
    }

    private void generateColumnSliceIfNeeded(CFMappingDef<?> cfMapDef) {
        if (cfMapDef.isColumnSliceRequired()) {
            Collection<PropertyMappingDefinition> propColl = cfMapDef.getAllProperties();
            String[] columnNames = new String[cfMapDef.isPersistableEntity() ? propColl.size() : propColl.size() + 1];
            Iterator<PropertyMappingDefinition> iter = propColl.iterator();
            int pos = 0;
            while (iter.hasNext()) {
                columnNames[pos++] = iter.next().getColName();
            }
            if (!cfMapDef.isPersistableEntity()) {
                columnNames[pos] = cfMapDef.getDiscColumn();
            }
            cfMapDef.setSliceColumnNameArr(columnNames);
        }
    }

    public Method findAnnotatedMethod(Class<?> clazz, Class<? extends Annotation> anno) {
        for (Method meth : clazz.getMethods()) {
            if (!meth.isAnnotationPresent(anno)) continue;
            return meth;
        }
        return null;
    }
}

