/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.persistence.spi.ProviderUtil;
import javax.sql.DataSource;
import me.prettyprint.cassandra.model.ConfigurableConsistencyLevel;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.ThriftCluster;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.ConsistencyLevelPolicy;
import me.prettyprint.hector.api.HConsistencyLevel;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hom.EntityManagerFactoryImpl;
import me.prettyprint.hom.annotations.AnnotationScanner;
import me.prettyprint.hom.annotations.DefaultAnnotationScanner;

public class CassandraPersistenceProvider
implements PersistenceProvider {
    private static final String KEYSPACE_PROP = "me.prettyprint.keyspace";
    private static final String CLUSTER_PROP = "me.prettyprint.cluster";
    private static final String HOST_PROP = "me.prettyprint.host";
    private static final String CONSISTENCY_PROP = "me.prettyprint.consistency";
    private static final String SCANNER = "me.prettyprint.scanner";

    public EntityManagerFactory createEntityManagerFactory(String emName, Map map) {
        Keyspace keyspace = this.keyspace((String)map.get(HOST_PROP), (String)map.get(CLUSTER_PROP), (String)map.get(KEYSPACE_PROP), (String)map.get(CONSISTENCY_PROP));
        AnnotationScanner scanner = CassandraPersistenceProvider.createScanner(CassandraPersistenceProvider.value(SCANNER, map, null));
        return new EntityManagerFactoryImpl(new LightPersistenceUnitInfo((String)map.get("me.prettyprint.hom.classpathPrefix")), keyspace, scanner);
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map map) {
        String keyspaceName = CassandraPersistenceProvider.value(KEYSPACE_PROP, map, info.getProperties());
        String host = CassandraPersistenceProvider.value(HOST_PROP, map, info.getProperties());
        String clusterName = CassandraPersistenceProvider.value(CLUSTER_PROP, map, info.getProperties());
        String consistency = CassandraPersistenceProvider.value(CONSISTENCY_PROP, map, info.getProperties());
        Keyspace keyspace = this.keyspace(host, clusterName, keyspaceName, consistency);
        AnnotationScanner scanner = CassandraPersistenceProvider.createScanner(CassandraPersistenceProvider.value(SCANNER, map, info.getProperties()));
        return new EntityManagerFactoryImpl(info, keyspace, scanner);
    }

    private static AnnotationScanner createScanner(String classname) {
        AnnotationScanner scanner;
        if (classname == null) {
            return new DefaultAnnotationScanner();
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = CassandraPersistenceProvider.class.getClassLoader();
        }
        try {
            scanner = (AnnotationScanner)loader.loadClass(classname).newInstance();
        }
        catch (Exception e) {
            scanner = new DefaultAnnotationScanner();
        }
        return scanner;
    }

    private static String value(String key, Map map, Properties properties) {
        if (map != null && map.containsKey(key)) {
            return (String)map.get(key);
        }
        if (properties != null) {
            return properties.getProperty(key);
        }
        return null;
    }

    private Keyspace keyspace(String host, String clusterName, String keyspaceName, String consistency) {
        if (clusterName == null) {
            throw new IllegalArgumentException("cluster name can't be null");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("keyspace name can't be null");
        }
        if (host == null) {
            throw new IllegalArgumentException("host can't be null");
        }
        ConfigurableConsistencyLevel consistencyLevelPolicy = new ConfigurableConsistencyLevel();
        if (consistency == null) {
            consistencyLevelPolicy.setDefaultReadConsistencyLevel(HConsistencyLevel.QUORUM);
        } else {
            consistencyLevelPolicy.setDefaultReadConsistencyLevel(HConsistencyLevel.valueOf((String)consistency.toUpperCase()));
        }
        ThriftCluster cluster = new ThriftCluster(clusterName, new CassandraHostConfigurator(host));
        return HFactory.createKeyspace((String)keyspaceName, (Cluster)cluster, (ConsistencyLevelPolicy)consistencyLevelPolicy);
    }

    public ProviderUtil getProviderUtil() {
        return null;
    }

    private class LightPersistenceUnitInfo
    implements PersistenceUnitInfo {
        private String toScan;

        private LightPersistenceUnitInfo(String toScan) {
            this.toScan = toScan;
        }

        public String getPersistenceUnitName() {
            return null;
        }

        public String getPersistenceProviderClassName() {
            return CassandraPersistenceProvider.class.getName();
        }

        public PersistenceUnitTransactionType getTransactionType() {
            return null;
        }

        public DataSource getJtaDataSource() {
            return null;
        }

        public DataSource getNonJtaDataSource() {
            return null;
        }

        public List<String> getMappingFileNames() {
            return null;
        }

        public List<URL> getJarFileUrls() {
            return null;
        }

        public URL getPersistenceUnitRootUrl() {
            return null;
        }

        public List<String> getManagedClassNames() {
            return null;
        }

        public boolean excludeUnlistedClasses() {
            return true;
        }

        public SharedCacheMode getSharedCacheMode() {
            return null;
        }

        public ValidationMode getValidationMode() {
            return null;
        }

        public Properties getProperties() {
            Properties properties = new Properties();
            properties.setProperty("me.prettyprint.hom.classpathPrefix", this.toScan);
            return properties;
        }

        public String getPersistenceXMLSchemaVersion() {
            return null;
        }

        public ClassLoader getClassLoader() {
            return null;
        }

        public void addTransformer(ClassTransformer transformer) {
        }

        public ClassLoader getNewTempClassLoader() {
            return null;
        }
    }
}

