/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.InheritanceType;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hom.HomMissingEntityAnnotationException;
import me.prettyprint.hom.KeyDefinition;
import me.prettyprint.hom.PropertyMappingDefinition;
import me.prettyprint.hom.cache.HectorObjectMapperException;

public class CFMappingDef<T> {
    private Class<T> realClass;
    private Class<T> effectiveClass;
    private CFMappingDef<? super T> cfBaseMapDef;
    private CFMappingDef<? super T> cfSuperMapDef;
    private String colFamName;
    private InheritanceType inheritanceType;
    private String discColumn;
    private DiscriminatorType discType;
    private Object discValue;
    private Method anonymousPropertyAddHandler;
    private Method anonymousPropertyGetHandler;
    private Class<?> anonymousValueType;
    private Serializer anonymousValueSerializer;
    private String[] sliceColumnNameArr;
    private KeyDefinition keyDef;
    private Map<Object, CFMappingDef<? extends T>> derivedClassMap = new HashMap<Object, CFMappingDef<? extends T>>();
    private Collection<PropertyMappingDefinition> allMappedProps;
    private Map<String, PropertyMappingDefinition> propertyCacheByPropName = new HashMap<String, PropertyMappingDefinition>();
    private Map<String, PropertyMappingDefinition> propertyCacheByColName = new HashMap<String, PropertyMappingDefinition>();

    public CFMappingDef(Class<T> clazz) {
        this.setDefaults(clazz);
    }

    public void setDefaults(Class<T> realClass) {
        boolean entityFound;
        this.realClass = realClass;
        this.keyDef = new KeyDefinition();
        this.effectiveClass = realClass;
        while (!(entityFound = null != this.effectiveClass.getAnnotation(Entity.class)) && this.effectiveClass.isAnonymousClass()) {
            this.effectiveClass = this.effectiveClass.getSuperclass();
        }
        if (!entityFound) {
            throw new HomMissingEntityAnnotationException("class, " + realClass.getName() + ", not annotated with @" + Entity.class.getSimpleName());
        }
    }

    public boolean isColumnSliceRequired() {
        return !this.isAnonymousHandlerAvailable() && !this.isAnyCollections() && !this.isAbstract() && !this.isDerivedEntity();
    }

    public boolean isAnyCollections() {
        if (null == this.getAllProperties()) {
            return false;
        }
        for (PropertyMappingDefinition md : this.getAllProperties()) {
            if (!md.isCollectionType()) continue;
            return true;
        }
        return false;
    }

    public void addDerivedClassMap(CFMappingDef<? extends T> cfDerivedMapDef) {
        this.derivedClassMap.put(cfDerivedMapDef.getDiscValue(), cfDerivedMapDef);
    }

    public PropertyMappingDefinition getPropMapByPropName(String propName) {
        return this.propertyCacheByPropName.get(propName);
    }

    public PropertyMappingDefinition getPropMapByColumnName(String colName) {
        PropertyMappingDefinition md = this.propertyCacheByColName.get(colName);
        if (null != md) {
            return md;
        }
        if (null != this.cfSuperMapDef) {
            return this.cfSuperMapDef.getPropMapByColumnName(colName);
        }
        return null;
    }

    public void addPropertyDefinition(PropertyMappingDefinition propDef) {
        this.propertyCacheByColName.put(propDef.getColName(), propDef);
        this.propertyCacheByPropName.put(propDef.getPropDesc().getName(), propDef);
    }

    public String getColFamName() {
        return this.colFamName;
    }

    public String getEffectiveColFamName() {
        if (null != this.colFamName) {
            return this.colFamName;
        }
        if (null != this.cfBaseMapDef) {
            return this.cfBaseMapDef.getColFamName();
        }
        throw new HectorObjectMapperException("trying to get ColumnFamily name, but is missing for mapping, " + this.toString());
    }

    public Class<T> getEffectiveClass() {
        return this.effectiveClass;
    }

    public InheritanceType getInheritanceType() {
        return this.inheritanceType;
    }

    public void setInheritanceType(InheritanceType inheritanceType) {
        this.inheritanceType = inheritanceType;
    }

    public String getDiscColumn() {
        if (null == this.cfBaseMapDef) {
            return this.discColumn;
        }
        return this.cfBaseMapDef.getDiscColumn();
    }

    public void setDiscColumn(String discColumn) {
        this.discColumn = discColumn;
    }

    public DiscriminatorType getDiscType() {
        if (null == this.cfBaseMapDef) {
            return this.discType;
        }
        return this.cfBaseMapDef.getDiscType();
    }

    public void setDiscType(DiscriminatorType discType) {
        this.discType = discType;
    }

    public Object getDiscValue() {
        return this.discValue;
    }

    public void setDiscValue(Object discValue) {
        this.discValue = discValue;
    }

    public KeyDefinition getKeyDef() {
        if (null == this.cfBaseMapDef) {
            return this.keyDef;
        }
        return this.cfBaseMapDef.getKeyDef();
    }

    public Collection<PropertyMappingDefinition> getAllProperties() {
        if (null == this.allMappedProps) {
            HashSet<PropertyMappingDefinition> propSet = new HashSet<PropertyMappingDefinition>();
            for (PropertyMappingDefinition propMapDef : this.propertyCacheByColName.values()) {
                propSet.add(propMapDef);
            }
            this.allMappedProps = null == this.cfSuperMapDef ? propSet : Sets.union(propSet, (Set)((Set)this.cfSuperMapDef.getAllProperties()));
        }
        return this.allMappedProps;
    }

    public CFMappingDef<? super T> getCfBaseMapDef() {
        return this.cfBaseMapDef;
    }

    public void setCfBaseMapDef(CFMappingDef<? super T> cfBaseMapDef) {
        this.cfBaseMapDef = cfBaseMapDef;
    }

    public void setColFamName(String colFamName) {
        this.colFamName = colFamName;
    }

    public Map<Object, CFMappingDef<? extends T>> getDerivedClassMap() {
        return this.derivedClassMap;
    }

    public CFMappingDef<? super T> getCfSuperMapDef() {
        return this.cfSuperMapDef;
    }

    public void setCfSuperMapDef(CFMappingDef<? super T> cfSuperMapDef) {
        this.cfSuperMapDef = cfSuperMapDef;
    }

    public Class<T> getRealClass() {
        return this.realClass;
    }

    public String toString() {
        return "CFMappingDef [colFamName=" + this.colFamName + ", realClass=" + this.realClass + ", effectiveClass=" + this.effectiveClass + "]";
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.effectiveClass.getModifiers());
    }

    public boolean isBaseEntity() {
        return null != this.inheritanceType;
    }

    public boolean isPersistableEntity() {
        return !this.isAbstract();
    }

    public boolean isPersistableDerivedEntity() {
        return !this.isBaseEntity() && null != this.getDiscValue() && !this.isAbstract();
    }

    public boolean isNonPersistableDerivedEntity() {
        return !this.isBaseEntity() && !this.isPersistableDerivedEntity() && this.isAbstract();
    }

    public boolean isDerivedEntity() {
        return this.isPersistableDerivedEntity() || this.isNonPersistableDerivedEntity();
    }

    public String[] getSliceColumnNameArr() {
        return this.sliceColumnNameArr;
    }

    public void setSliceColumnNameArr(String[] sliceColumnNameArr) {
        this.sliceColumnNameArr = sliceColumnNameArr;
    }

    public Method getAnonymousPropertyAddHandler() {
        if (null != this.anonymousPropertyAddHandler) {
            return this.anonymousPropertyAddHandler;
        }
        if (null != this.cfSuperMapDef) {
            return this.cfSuperMapDef.getAnonymousPropertyAddHandler();
        }
        return null;
    }

    public Method getAnonymousPropertyGetHandler() {
        if (null != this.anonymousPropertyGetHandler) {
            return this.anonymousPropertyGetHandler;
        }
        if (null != this.cfSuperMapDef) {
            return this.cfSuperMapDef.getAnonymousPropertyGetHandler();
        }
        return null;
    }

    public Class<?> getAnonymousValueType() {
        if (null != this.anonymousValueType) {
            return this.anonymousValueType;
        }
        if (null != this.cfSuperMapDef) {
            return this.cfSuperMapDef.getAnonymousValueType();
        }
        return null;
    }

    public Serializer getAnonymousValueSerializer() {
        if (null != this.anonymousValueSerializer) {
            return this.anonymousValueSerializer;
        }
        if (null != this.cfSuperMapDef) {
            return this.cfSuperMapDef.getAnonymousValueSerializer();
        }
        return null;
    }

    public void setAnonymousValueType(Class<?> anonymousValueType) {
        this.anonymousValueType = anonymousValueType;
    }

    public void setAnonymousValueSerializer(Serializer anonymousValueSerializer) {
        this.anonymousValueSerializer = anonymousValueSerializer;
    }

    public void setAnonymousPropertyAddHandler(Method anonymousPropertyAddHandler) {
        this.anonymousPropertyAddHandler = anonymousPropertyAddHandler;
    }

    public boolean isAnonymousHandlerAvailable() {
        return null != this.anonymousValueSerializer;
    }

    public Collection<PropertyMappingDefinition> getCollectionProperties() {
        HashSet<PropertyMappingDefinition> collSet = new HashSet<PropertyMappingDefinition>();
        for (PropertyMappingDefinition md : this.getAllProperties()) {
            if (!md.isCollectionType()) continue;
            collSet.add(md);
        }
        return collSet;
    }

    public void setAnonymousPropertyGetHandler(Method anonymousPropertyGetHandler) {
        this.anonymousPropertyGetHandler = anonymousPropertyGetHandler;
    }
}

